/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.AcceptedReactions;
import org.moera.lib.node.types.AvatarDescription;
import org.moera.lib.node.types.CommentOperations;
import org.moera.lib.node.types.MediaWithDigest;
import org.moera.lib.node.types.PostingOperations;
import org.moera.lib.node.types.ReactionOperations;
import org.moera.lib.node.types.SourceFormat;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.body.Body;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PostingSourceText
extends Structure
implements Cloneable {
    private AvatarDescription ownerAvatar;
    private Body bodySrc;
    private SourceFormat bodySrcFormat;
    private List<MediaWithDigest> media;
    private AcceptedReactions acceptedReactions;
    private PostingOperations operations;
    private CommentOperations commentOperations;
    private ReactionOperations reactionOperations;
    private ReactionOperations commentReactionOperations;

    public AvatarDescription getOwnerAvatar() {
        return this.ownerAvatar;
    }

    public void setOwnerAvatar(AvatarDescription ownerAvatar) {
        this.ownerAvatar = ownerAvatar;
    }

    public Body getBodySrc() {
        return this.bodySrc;
    }

    public void setBodySrc(Body bodySrc) {
        this.bodySrc = bodySrc;
    }

    public SourceFormat getBodySrcFormat() {
        return this.bodySrcFormat;
    }

    public void setBodySrcFormat(SourceFormat bodySrcFormat) {
        this.bodySrcFormat = bodySrcFormat;
    }

    public List<MediaWithDigest> getMedia() {
        return this.media;
    }

    public void setMedia(List<MediaWithDigest> media) {
        this.media = media;
    }

    public AcceptedReactions getAcceptedReactions() {
        return this.acceptedReactions;
    }

    public void setAcceptedReactions(AcceptedReactions acceptedReactions) {
        this.acceptedReactions = acceptedReactions;
    }

    public PostingOperations getOperations() {
        return this.operations;
    }

    public void setOperations(PostingOperations operations) {
        this.operations = operations;
    }

    public CommentOperations getCommentOperations() {
        return this.commentOperations;
    }

    public void setCommentOperations(CommentOperations commentOperations) {
        this.commentOperations = commentOperations;
    }

    public ReactionOperations getReactionOperations() {
        return this.reactionOperations;
    }

    public void setReactionOperations(ReactionOperations reactionOperations) {
        this.reactionOperations = reactionOperations;
    }

    public ReactionOperations getCommentReactionOperations() {
        return this.commentReactionOperations;
    }

    public void setCommentReactionOperations(ReactionOperations commentReactionOperations) {
        this.commentReactionOperations = commentReactionOperations;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull(this.bodySrc, "posting.body-src.blank");
        ValidationUtil.maxSize(this.bodySrc, 65535, "posting.body-src.wrong-size");
        if (this.acceptedReactions != null) {
            this.acceptedReactions.validate();
        }
    }

    public PostingSourceText clone() {
        try {
            return (PostingSourceText)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

