/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.test;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.boot.test.context.SpringBootContextLoader;
import org.springframework.boot.test.context.SpringBootTestContextBootstrapper;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.assertj.AssertableApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate;
import org.springframework.test.context.support.DefaultBootstrapContext;

public class TestUtils {
    public static void assertDependencyMissing(Class<?> testClass, Class<?> expectedMissingDependency) {
        DefaultCacheAwareContextLoaderDelegate delegate = new DefaultCacheAwareContextLoaderDelegate();
        DefaultBootstrapContext bootstrapContext = new DefaultBootstrapContext(testClass, (CacheAwareContextLoaderDelegate)delegate);
        SpringBootTestContextBootstrapper bootstrapper = new SpringBootTestContextBootstrapper();
        bootstrapper.setBootstrapContext((BootstrapContext)bootstrapContext);
        MergedContextConfiguration configuration = bootstrapper.buildMergedContextConfiguration();
        AssertableApplicationContext context = AssertableApplicationContext.get(() -> {
            SpringBootContextLoader loader = new SpringBootContextLoader();
            try {
                return (ConfigurableApplicationContext)loader.loadContext(configuration);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasFailed();
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).getFailure().isInstanceOfSatisfying(UnsatisfiedDependencyException.class, it -> Assertions.assertThat((Throwable)it.getMostSpecificCause()).isInstanceOfSatisfying(NoSuchBeanDefinitionException.class, ex -> Assertions.assertThat((Class)ex.getBeanType()).isEqualTo((Object)expectedMissingDependency)));
    }
}

