/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.test;

import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.moduliths.test.DefaultPublishedEvents;
import org.moduliths.test.PublishedEvents;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;

class PublishedEventsParameterResolver
implements ParameterResolver,
BeforeAllCallback,
AfterEachCallback {
    private ThreadBoundApplicationListenerAdapter listener = new ThreadBoundApplicationListenerAdapter();
    private final Function<ExtensionContext, ApplicationContext> lookup;

    PublishedEventsParameterResolver() {
        this(ctx -> SpringExtension.getApplicationContext((ExtensionContext)ctx));
    }

    PublishedEventsParameterResolver(Function<ExtensionContext, ApplicationContext> supplier) {
        this.lookup = supplier;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        ApplicationContext context = this.lookup.apply(extensionContext);
        ((ConfigurableApplicationContext)context).addApplicationListener((ApplicationListener)this.listener);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return PublishedEvents.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public PublishedEvents resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        DefaultPublishedEvents publishedEvents = new DefaultPublishedEvents();
        this.listener.registerDelegate(publishedEvents);
        return publishedEvents;
    }

    public void afterEach(ExtensionContext context) {
        this.listener.unregisterDelegate();
    }

    private static class ThreadBoundApplicationListenerAdapter
    implements ApplicationListener<ApplicationEvent> {
        private final ThreadLocal<ApplicationListener<ApplicationEvent>> delegate = new ThreadLocal();

        private ThreadBoundApplicationListenerAdapter() {
        }

        void registerDelegate(ApplicationListener<ApplicationEvent> listener) {
            Assert.notNull(listener, (String)"Delegate ApplicationListener must not be null!");
            this.delegate.set(listener);
        }

        void unregisterDelegate() {
            this.delegate.remove();
        }

        public void onApplicationEvent(ApplicationEvent event) {
            ApplicationListener<ApplicationEvent> listener = this.delegate.get();
            if (listener != null) {
                listener.onApplicationEvent(event);
            }
        }
    }
}

