/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.test;

import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.moduliths.model.JavaPackage;
import org.moduliths.model.Module;
import org.moduliths.model.Modules;
import org.moduliths.test.ModuleTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.AnnotatedClassFinder;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class ModuleTestExecution
implements Iterable<Module> {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleTestExecution.class);
    private static Map<Class<?>, Class<?>> MODULITH_TYPES = new HashMap();
    private static Map<Key, ModuleTestExecution> EXECUTIONS = new HashMap<Key, ModuleTestExecution>();
    private final Key key;
    private final ModuleTest.BootstrapMode bootstrapMode;
    private final Module module;
    private final Modules modules;
    private final List<Module> extraIncludes;
    private final Supplier<List<JavaPackage>> basePackages;
    private final Supplier<List<Module>> dependencies;

    private ModuleTestExecution(ModuleTest annotation, Modules modules, Module module) {
        this.key = Key.of(module.getBasePackage().getName(), annotation);
        this.modules = modules;
        this.bootstrapMode = annotation.mode();
        this.module = module;
        this.extraIncludes = ModuleTestExecution.getExtraModules(annotation, modules).collect(Collectors.toList());
        this.basePackages = Suppliers.memoize(() -> {
            Stream moduleBasePackages = module.getBasePackages(modules, this.bootstrapMode.getDepth());
            Stream<JavaPackage> sharedBasePackages = modules.getSharedModules().stream().map(it -> it.getBasePackage());
            Stream<JavaPackage> extraPackages = this.extraIncludes.stream().map(Module::getBasePackage);
            Stream<JavaPackage> intermediate = Stream.concat(moduleBasePackages, extraPackages);
            return Stream.concat(intermediate, sharedBasePackages).distinct().collect(Collectors.toList());
        });
        this.dependencies = Suppliers.memoize(() -> {
            Stream bootstrapDependencies = module.getBootstrapDependencies(modules, this.bootstrapMode.getDepth());
            return Stream.concat(bootstrapDependencies, this.extraIncludes.stream()).collect(Collectors.toList());
        });
        if (annotation.verifyAutomatically()) {
            this.verify();
        }
    }

    public static java.util.function.Supplier<ModuleTestExecution> of(Class<?> type) {
        return () -> {
            ModuleTest annotation = (ModuleTest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)type, ModuleTest.class);
            String packageName = type.getPackage().getName();
            Class modulithType = MODULITH_TYPES.computeIfAbsent(type, it -> new AnnotatedClassFinder(SpringBootApplication.class).findFromPackage(packageName));
            Modules modules = Modules.of((Class)modulithType);
            Module module = (Module)modules.getModuleForPackage(packageName).orElseThrow(() -> new IllegalStateException(String.format("Package %s is not part of any module!", packageName)));
            return EXECUTIONS.computeIfAbsent(Key.of(module.getBasePackage().getName(), annotation), it -> new ModuleTestExecution(annotation, modules, module));
        };
    }

    public Stream<String> getBasePackages() {
        return ((List)this.basePackages.get()).stream().map(JavaPackage::getName);
    }

    public boolean includes(String className) {
        boolean result;
        boolean bl = result = this.modules.withinRootPackages(className) || ((List)this.basePackages.get()).stream().anyMatch(it -> it.contains(className));
        if (result) {
            LOG.debug("Including class {}.", (Object)className);
        }
        return !result;
    }

    public List<Module> getDependencies() {
        return (List)this.dependencies.get();
    }

    public void verify() {
        this.modules.verify();
    }

    public void verifyModule() {
        this.module.verifyDependencies(this.modules);
    }

    @Override
    public Iterator<Module> iterator() {
        return this.modules.iterator();
    }

    private static Stream<Module> getExtraModules(ModuleTest annotation, Modules modules) {
        return Arrays.stream(annotation.extraIncludes()).map(arg_0 -> ((Modules)modules).getModuleByName(arg_0)).flatMap(it -> it.map(Stream::of).orElseGet(Stream::empty));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleTestExecution)) {
            return false;
        }
        ModuleTestExecution other = (ModuleTestExecution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$key = this.key;
        Key other$key = other.key;
        return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleTestExecution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $key = this.key;
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        return result;
    }

    public ModuleTest.BootstrapMode getBootstrapMode() {
        return this.bootstrapMode;
    }

    public Module getModule() {
        return this.module;
    }

    public Modules getModules() {
        return this.modules;
    }

    public List<Module> getExtraIncludes() {
        return this.extraIncludes;
    }

    private static final class Key {
        private final String moduleBasePackage;
        private final ModuleTest annotation;

        public String getModuleBasePackage() {
            return this.moduleBasePackage;
        }

        public ModuleTest getAnnotation() {
            return this.annotation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            String this$moduleBasePackage = this.getModuleBasePackage();
            String other$moduleBasePackage = other.getModuleBasePackage();
            if (this$moduleBasePackage == null ? other$moduleBasePackage != null : !this$moduleBasePackage.equals(other$moduleBasePackage)) {
                return false;
            }
            ModuleTest this$annotation = this.getAnnotation();
            ModuleTest other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $moduleBasePackage = this.getModuleBasePackage();
            result = result * 59 + ($moduleBasePackage == null ? 43 : $moduleBasePackage.hashCode());
            ModuleTest $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        public String toString() {
            return "ModuleTestExecution.Key(moduleBasePackage=" + this.getModuleBasePackage() + ", annotation=" + this.getAnnotation() + ")";
        }

        private Key(String moduleBasePackage, ModuleTest annotation) {
            this.moduleBasePackage = moduleBasePackage;
            this.annotation = annotation;
        }

        private static Key of(String moduleBasePackage, ModuleTest annotation) {
            return new Key(moduleBasePackage, annotation);
        }
    }
}

