/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.test;

import java.util.List;
import java.util.stream.Collectors;
import org.moduliths.test.ModuleTestExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={AutoConfigurationAndEntityScanPackageCustomizer.class})
class ModuleTestAutoConfiguration {
    private static final String AUTOCONFIG_PACKAGES = "org.springframework.boot.autoconfigure.AutoConfigurationPackages";
    private static final String ENTITY_SCAN_PACKAGE = "org.springframework.boot.autoconfigure.domain.EntityScanPackages";

    ModuleTestAutoConfiguration() {
    }

    static class AutoConfigurationAndEntityScanPackageCustomizer
    implements ImportBeanDefinitionRegistrar {
        private static final Logger LOG = LoggerFactory.getLogger(AutoConfigurationAndEntityScanPackageCustomizer.class);

        AutoConfigurationAndEntityScanPackageCustomizer() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            ModuleTestExecution execution = (ModuleTestExecution)((BeanFactory)registry).getBean(ModuleTestExecution.class);
            List<String> basePackages = execution.getBasePackages().collect(Collectors.toList());
            LOG.info("Re-configuring auto-configuration and entity scan packages to: {}.", (Object)StringUtils.collectionToDelimitedString(basePackages, (String)", "));
            this.setBasePackagesOn(registry, ModuleTestAutoConfiguration.AUTOCONFIG_PACKAGES, "packages", basePackages);
            this.setBasePackagesOn(registry, ModuleTestAutoConfiguration.ENTITY_SCAN_PACKAGE, "packageNames", basePackages);
        }

        private void setBasePackagesOn(BeanDefinitionRegistry registry, String beanName, String fieldName, List<String> packages) {
            if (!registry.containsBeanDefinition(beanName)) {
                return;
            }
            BeanDefinition definition = registry.getBeanDefinition(beanName);
            definition.getConstructorArgumentValues().addIndexedArgumentValue(0, packages);
        }
    }
}

