/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.moduliths.model.Module;
import org.moduliths.model.Modules;
import org.moduliths.test.DefaultPublishedEvents;
import org.moduliths.test.ModuleTest;
import org.moduliths.test.ModuleTestExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;

class ModuleContextCustomizerFactory
implements ContextCustomizerFactory {
    ModuleContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        ModuleTest moduleTest = (ModuleTest)AnnotatedElementUtils.getMergedAnnotation(testClass, ModuleTest.class);
        return moduleTest == null ? null : new ModuleContextCustomizer(testClass);
    }

    static class ModuleContextCustomizer
    implements ContextCustomizer {
        private static final Logger LOG = LoggerFactory.getLogger(ModuleContextCustomizer.class);
        private static final String BEAN_NAME = ModuleTestExecution.class.getName();
        private final Supplier<ModuleTestExecution> execution;

        private ModuleContextCustomizer(Class<?> testClass) {
            this.execution = ModuleTestExecution.of(testClass);
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            ModuleTestExecution testExecution = this.execution.get();
            ModuleContextCustomizer.logModules(testExecution);
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            beanFactory.registerSingleton(BEAN_NAME, (Object)testExecution);
            DefaultPublishedEvents events = new DefaultPublishedEvents();
            beanFactory.registerSingleton(events.getClass().getName(), (Object)events);
            context.addApplicationListener((ApplicationListener)events);
        }

        private static void logModules(ModuleTestExecution execution) {
            List<Module> dependencies;
            Set sharedModules;
            Module module = execution.getModule();
            Modules modules = execution.getModules();
            String moduleName = module.getDisplayName();
            String bootstrapMode = execution.getBootstrapMode().name();
            String message = String.format("Bootstrapping @ModuleTest for %s in mode %s (%s)\u2026", moduleName, bootstrapMode, modules.getModulithType());
            LOG.info(message);
            LOG.info(ModuleContextCustomizer.getSeparator("=", message));
            Arrays.stream(module.toString(modules).split("\n")).forEach(arg_0 -> ((Logger)LOG).info(arg_0));
            List<Module> extraIncludes = execution.getExtraIncludes();
            if (!extraIncludes.isEmpty()) {
                ModuleContextCustomizer.logHeadline("Extra includes:", message);
                extraIncludes.forEach(it -> LOG.info("> ".concat(it.getName())));
            }
            if (!(sharedModules = modules.getSharedModules()).isEmpty()) {
                ModuleContextCustomizer.logHeadline("Shared modules:", message);
                sharedModules.forEach(it -> LOG.info("> ".concat(it.getName())));
            }
            if (!(dependencies = execution.getDependencies()).isEmpty() || !sharedModules.isEmpty()) {
                ModuleContextCustomizer.logHeadline("Included dependencies:", message);
                Stream<Module> dependenciesPlusMissingSharedOnes = Stream.concat(dependencies.stream(), sharedModules.stream().filter(it -> !dependencies.contains(it)));
                dependenciesPlusMissingSharedOnes.map(it -> it.toString(modules)).forEach(it -> Arrays.stream(it.split("\n")).forEach(arg_0 -> ((Logger)LOG).info(arg_0)));
                LOG.info(ModuleContextCustomizer.getSeparator("=", message));
            }
        }

        private static String getSeparator(String character, String reference) {
            return String.join((CharSequence)"", Collections.nCopies(reference.length(), character));
        }

        private static void logHeadline(String headline, String reference) {
            ModuleContextCustomizer.logHeadline(headline, reference, () -> {});
        }

        private static void logHeadline(String headline, String reference, Runnable additional) {
            LOG.info(ModuleContextCustomizer.getSeparator("=", reference));
            LOG.info(headline);
            additional.run();
            LOG.info(ModuleContextCustomizer.getSeparator("=", reference));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleContextCustomizer)) {
                return false;
            }
            ModuleContextCustomizer other = (ModuleContextCustomizer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Supplier<ModuleTestExecution> this$execution = this.execution;
            Supplier<ModuleTestExecution> other$execution = other.execution;
            return !(this$execution == null ? other$execution != null : !this$execution.equals(other$execution));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModuleContextCustomizer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<ModuleTestExecution> $execution = this.execution;
            result = result * 59 + ($execution == null ? 43 : $execution.hashCode());
            return result;
        }
    }
}

