/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.moduliths.test.PublishedEvents;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.util.Assert;

class DefaultPublishedEvents
implements PublishedEvents,
ApplicationListener<ApplicationEvent> {
    private final List<Object> events;

    DefaultPublishedEvents() {
        this(Collections.emptyList());
    }

    DefaultPublishedEvents(Collection<? extends Object> events) {
        Assert.notNull(events, (String)"Events must not be null!");
        this.events = new ArrayList<Object>(events);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.events.add(DefaultPublishedEvents.unwrapPayloadEvent(event));
    }

    @Override
    public <T> PublishedEvents.TypedPublishedEvents<T> ofType(Class<T> type) {
        return SimpleTypedPublishedEvents.of(this.events.stream().filter(type::isInstance).map(type::cast));
    }

    private static Object unwrapPayloadEvent(Object source) {
        return PayloadApplicationEvent.class.isInstance(source) ? ((PayloadApplicationEvent)source).getPayload() : source;
    }

    private static class SimpleTypedPublishedEvents<T>
    implements PublishedEvents.TypedPublishedEvents<T> {
        private final List<T> events;

        private static <T> SimpleTypedPublishedEvents<T> of(Stream<T> stream) {
            return new SimpleTypedPublishedEvents(stream.collect(Collectors.toList()));
        }

        @Override
        public <S extends T> PublishedEvents.TypedPublishedEvents<S> ofSubType(Class<S> subType) {
            return SimpleTypedPublishedEvents.of(this.getFilteredEvents(subType::isInstance).map(subType::cast));
        }

        @Override
        public PublishedEvents.TypedPublishedEvents<T> matching(Predicate<? super T> predicate) {
            return SimpleTypedPublishedEvents.of(this.getFilteredEvents(predicate));
        }

        @Override
        public <S> PublishedEvents.TypedPublishedEvents<T> matchingMapped(Function<T, S> mapper, Predicate<? super S> predicate) {
            return SimpleTypedPublishedEvents.of(this.events.stream().flatMap(it -> {
                Object mapped = mapper.apply(it);
                return predicate.test((Object)mapped) ? Stream.of(it) : Stream.empty();
            }));
        }

        private Stream<T> getFilteredEvents(Predicate<? super T> predicate) {
            return this.events.stream().filter(predicate);
        }

        @Override
        public Iterator<T> iterator() {
            return this.events.iterator();
        }

        public String toString() {
            return this.events.toString();
        }

        private SimpleTypedPublishedEvents(List<T> events) {
            this.events = events;
        }

        public static <T> SimpleTypedPublishedEvents<T> of(List<T> events) {
            return new SimpleTypedPublishedEvents<T>(events);
        }
    }
}

