/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.test;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.moduliths.test.PublishedEvents;
import org.springframework.data.domain.DomainEvents;
import org.springframework.util.ReflectionUtils;

public class AggregateTestUtils {
    private static Map<Class<?>, Optional<Method>> CACHE = new ConcurrentHashMap();

    public static PublishedEvents eventsOf(Object aggregate) {
        Collection events = CACHE.computeIfAbsent(aggregate.getClass(), AggregateTestUtils::findAnnotatedMethod).map(it -> ReflectionUtils.invokeMethod((Method)it, (Object)aggregate)).map(Collection.class::cast).orElseGet(Collections::emptyList);
        return PublishedEvents.of(events);
    }

    private static Optional<Method> findAnnotatedMethod(Class<?> type) {
        DomainEventsMethodFinder finder = new DomainEventsMethodFinder();
        ReflectionUtils.doWithMethods(type, (ReflectionUtils.MethodCallback)finder);
        return Optional.ofNullable(finder.method);
    }

    private static class DomainEventsMethodFinder
    implements ReflectionUtils.MethodCallback {
        Method method;

        private DomainEventsMethodFinder() {
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            if (this.method != null) {
                return;
            }
            if (method.isAnnotationPresent(DomainEvents.class)) {
                this.method = method;
                ReflectionUtils.makeAccessible((Method)method);
            }
        }
    }
}

