/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.docs;

import com.structurizr.Workspace;
import com.structurizr.io.plantuml.BasicPlantUMLWriter;
import com.structurizr.io.plantuml.C4PlantUMLWriter;
import com.structurizr.io.plantuml.PlantUMLWriter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ComponentView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.Styles;
import com.structurizr.view.View;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.moduliths.docs.Asciidoctor;
import org.moduliths.model.Module;
import org.moduliths.model.Modules;
import org.moduliths.model.SpringBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class Documenter {
    private static final String DEFAULT_LOCATION = "target/moduliths-docs";
    private static final Map<Module.DependencyType, String> DEPENDENCY_DESCRIPTIONS = new LinkedHashMap<Module.DependencyType, String>();
    private static final String INVALID_FILE_NAME_PATTERN = "Configured file name pattern does not include a '%s' placeholder for the module name!";
    private final Modules modules;
    private final Workspace workspace;
    private final Container container;
    private Map<Module, Component> components;

    public Documenter(Class<?> modulithType) {
        this(Modules.of(modulithType));
    }

    public Documenter(Modules modules) {
        Assert.notNull((Object)modules, (String)"Modules must not be null!");
        this.modules = modules;
        this.workspace = new Workspace("Modulith", "");
        this.workspace.getViews().getConfiguration().getStyles().addElementStyle("Component").shape(Shape.Component);
        Model model = this.workspace.getModel();
        String systemName = modules.getSystemName().orElse("Modulith");
        SoftwareSystem system = model.addSoftwareSystem(systemName, "");
        this.container = system.addContainer("Application", "", "");
    }

    private Map<Module, Component> getComponents(Options options) {
        if (this.components == null) {
            this.components = this.modules.stream().collect(Collectors.toMap(Function.identity(), it -> this.container.addComponent((String)options.getDefaultDisplayName().apply(it), "", "Module")));
            this.components.forEach((key, value) -> this.addDependencies((Module)key, (Component)value, options));
        }
        return this.components;
    }

    public Documenter writeDocumentation(Options options, CanvasOptions canvasOptions) throws IOException {
        return this.writeModulesAsPlantUml(options).writeIndividualModulesAsPlantUml(options).writeModuleCanvases(canvasOptions);
    }

    public Documenter writeModulesAsPlantUml(Options options) throws IOException {
        Assert.notNull((Object)options, (String)"Options must not be null!");
        Path file = Documenter.recreateFile(options.getTargetFileName().orElse("components.uml"));
        try (FileWriter writer = new FileWriter(file.toFile());){
            this.createPlantUml(writer, options);
        }
        return this;
    }

    public Documenter writeIndividualModulesAsPlantUml(Options options) {
        this.modules.forEach(it -> this.writeModuleAsPlantUml((Module)it, options));
        return this;
    }

    public Documenter writeModuleAsPlantUml(Module module) {
        Assert.notNull((Object)module, (String)"Module must not be null!");
        return this.writeModuleAsPlantUml(module, Options.defaults());
    }

    public Documenter writeModuleAsPlantUml(Module module, Options options) {
        Assert.notNull((Object)module, (String)"Module must not be null!");
        Assert.notNull((Object)options, (String)"Options must not be null!");
        ComponentView view = this.workspace.getViews().createComponentView(this.container, module.getName(), "");
        view.setTitle((String)options.getDefaultDisplayName().apply(module));
        this.addComponentsToView(module, view, options);
        String fileNamePattern = options.getTargetFileName().orElse("module-%s.uml");
        Assert.isTrue((boolean)fileNamePattern.contains("%s"), () -> String.format(INVALID_FILE_NAME_PATTERN, fileNamePattern));
        return this.writeViewAsPlantUml((View)view, String.format(fileNamePattern, module.getName()), options);
    }

    public Documenter writeModuleCanvases() {
        return this.writeModuleCanvases(CanvasOptions.defaults());
    }

    public Documenter writeModuleCanvases(CanvasOptions options) {
        this.modules.forEach(module -> {
            String filename = String.format(options.getTargetFileName().orElse("module-%s.adoc"), module.getName());
            Path file = Documenter.recreateFile(filename);
            try (FileWriter writer = new FileWriter(file.toFile());){
                writer.write(this.toModuleCanvas((Module)module, options));
            }
            catch (IOException o_O) {
                throw new RuntimeException(o_O);
            }
        });
        return this;
    }

    @Deprecated
    public Documenter writeModuleCanvases(String javadocBase) {
        return this.writeModuleCanvases(CanvasOptions.defaults().withApiBase(javadocBase));
    }

    public String toModuleCanvas(Module module) {
        return this.toModuleCanvas(module, CanvasOptions.defaults());
    }

    public String toModuleCanvas(Module module, String apiBase) {
        return this.toModuleCanvas(module, CanvasOptions.defaults().withApiBase(apiBase));
    }

    public String toModuleCanvas(Module module, CanvasOptions options) {
        Asciidoctor asciidoctor = Asciidoctor.withJavadocBase(this.modules, options.getApiBase());
        Function mapper = asciidoctor::typesToBulletPoints;
        StringBuilder builder = new StringBuilder();
        builder.append(Asciidoctor.startTable("%autowidth.stretch, cols=\"h,a\""));
        builder.append(Asciidoctor.writeTableRow("Base package", asciidoctor.toInlineCode(module.getBasePackage().getName())));
        builder.append(Asciidoctor.writeTableRow("Spring components", asciidoctor.renderSpringBeans(options, module)));
        builder.append(this.addTableRow(module.getAggregateRoots(this.modules), "Aggregate roots", mapper));
        builder.append(Asciidoctor.writeTableRow("Published events", asciidoctor.renderEvents(module)));
        builder.append(this.addTableRow(module.getEventsListenedTo(this.modules), "Events listened to", mapper));
        builder.append(Asciidoctor.startOrEndTable());
        return builder.toString();
    }

    private <T> String addTableRow(List<T> types, String header, Function<List<T>, String> mapper) {
        return types.isEmpty() ? "" : Asciidoctor.writeTableRow(header, mapper.apply(types));
    }

    public String toPlantUml() throws IOException {
        return this.createPlantUml(new StringWriter(), Options.defaults()).toString();
    }

    private void addDependencies(Module module, Component component, Options options) {
        DEPENDENCY_DESCRIPTIONS.entrySet().stream().forEach(entry -> module.getDependencies(this.modules, new Module.DependencyType[]{(Module.DependencyType)entry.getKey()}).stream().map(it -> this.getComponents(options).get(it)).forEach(it -> {
            Relationship relationship = component.uses(it, (String)entry.getValue());
            relationship.addTags(new String[]{((Module.DependencyType)entry.getKey()).toString()});
        }));
        module.getBootstrapDependencies(this.modules).forEach(it -> {
            Relationship relationship = component.uses(this.getComponents(options).get(it), "uses");
            relationship.addTags(new String[]{Module.DependencyType.USES_COMPONENT.toString()});
        });
    }

    private void addComponentsToView(Module module, ComponentView view, Options options) {
        Supplier<Stream> bootstrapDependencies = () -> module.getBootstrapDependencies(this.modules, options.getDependencyDepth());
        Supplier<Stream> otherDependencies = () -> options.getDependencyTypes().flatMap(it -> module.getDependencies(this.modules, new Module.DependencyType[]{it}).stream());
        Supplier<Stream<Module>> dependencies = () -> Stream.concat((Stream)bootstrapDependencies.get(), (Stream)otherDependencies.get());
        this.addComponentsToView(dependencies, view, options, it -> it.add(this.getComponents(options).get(module)));
    }

    private void addComponentsToView(Supplier<Stream<Module>> modules, ComponentView view, Options options, Consumer<ComponentView> afterCleanup) {
        Styles styles = view.getViewSet().getConfiguration().getStyles();
        Map<Module, Component> components = this.getComponents(options);
        modules.get().distinct().filter(options.getExclusions().negate()).map(it -> Documenter.applyBackgroundColor(it, components, options, styles)).filter(options.getComponentFilter()).forEach(arg_0 -> ((ComponentView)view).add(arg_0));
        Module.DependencyType.allBut((Stream)options.getDependencyTypes()).map(Object::toString).forEach(it -> view.removeRelationshipsWithTag(it));
        afterCleanup.accept(view);
        modules.get().filter(options.getTargetOnly()).forEach(module -> {
            Component component = (Component)components.get(module);
            view.getRelationships().stream().map(RelationshipView::getRelationship).filter(it -> it.getSource().equals(component)).forEach(it -> view.remove(it));
        });
        view.removeElementsWithNoRelationships();
        afterCleanup.accept(view);
        view.getRelationships().stream().map(RelationshipView::getRelationship).collect(Collectors.groupingBy(Connection::of)).values().stream().forEach(it -> this.potentiallyRemoveDefaultRelationship((View)view, (Collection<Relationship>)it));
    }

    private void potentiallyRemoveDefaultRelationship(View view, Collection<Relationship> relationships) {
        if (relationships.size() <= 1) {
            return;
        }
        relationships.stream().filter(it -> it.getTagsAsSet().contains(Module.DependencyType.DEFAULT.toString())).findFirst().ifPresent(arg_0 -> ((View)view).remove(arg_0));
    }

    private static Component applyBackgroundColor(Module module, Map<Module, Component> components, Options options, Styles styles) {
        Component component = components.get(module);
        Function selector = options.getColorSelector();
        ((Optional)selector.apply(module)).ifPresent(color -> {
            String tag = module.getName() + "-" + color;
            component.addTags(new String[]{tag});
            styles.addElementStyle(tag).background(color);
        });
        return component;
    }

    private Documenter writeViewAsPlantUml(View view, String filename, Options options) {
        try {
            Path file = Documenter.recreateFile(filename);
            try (FileWriter writer = new FileWriter(file.toFile());){
                options.getWriter().write(view, (Writer)writer);
            }
            return this;
        }
        catch (IOException o_O) {
            throw new RuntimeException(o_O);
        }
    }

    private <T extends Writer> T createPlantUml(T writer, Options options) throws IOException {
        ComponentView componentView = this.workspace.getViews().createComponentView(this.container, "modules-" + options.toString(), "");
        componentView.setTitle(this.modules.getSystemName().orElse("Modules"));
        this.addComponentsToView(() -> this.modules.stream(), componentView, options, it -> {});
        options.getWriter().write((View)componentView, writer);
        return writer;
    }

    private static Path recreateFile(String name) {
        try {
            Files.createDirectories(Paths.get(DEFAULT_LOCATION, new String[0]), new FileAttribute[0]);
            Path filePath = Paths.get(DEFAULT_LOCATION, name);
            Files.deleteIfExists(filePath);
            return Files.createFile(filePath, new FileAttribute[0]);
        }
        catch (IOException o_O) {
            throw new RuntimeException(o_O);
        }
    }

    @Generated
    public Modules getModules() {
        return this.modules;
    }

    static {
        DEPENDENCY_DESCRIPTIONS.put(Module.DependencyType.EVENT_LISTENER, "listens to");
        DEPENDENCY_DESCRIPTIONS.put(Module.DependencyType.DEFAULT, "depends on");
    }

    public static class CanvasOptions {
        static final Grouping FALLBACK_GROUP = Grouping.of("Others", null, __ -> true);
        private final List<Grouping> groupers;
        @Nullable
        private final String apiBase;
        @Nullable
        private final String targetFileName;

        public static CanvasOptions defaults() {
            return CanvasOptions.withoutDefaultGroupings().groupingBy("Controllers", (SpringBean bean) -> bean.toArchitecturallyEvidentType().isController()).groupingBy("Services", (SpringBean bean) -> bean.toArchitecturallyEvidentType().isService()).groupingBy("Repositories", (SpringBean bean) -> bean.toArchitecturallyEvidentType().isRepository()).groupingBy("Event listeners", (SpringBean bean) -> bean.toArchitecturallyEvidentType().isEventListener());
        }

        public static CanvasOptions withoutDefaultGroupings() {
            return new CanvasOptions(new ArrayList<Grouping>(), null, null);
        }

        public CanvasOptions groupingBy(Grouping ... groupings) {
            ArrayList<Grouping> result = new ArrayList<Grouping>(this.groupers);
            result.addAll(Arrays.asList(groupings));
            return new CanvasOptions(result, this.apiBase, this.targetFileName);
        }

        public CanvasOptions groupingBy(String name, Predicate<SpringBean> filter) {
            return this.groupingBy(Grouping.of(name, null, filter));
        }

        Groupings groupBeans(Module module) {
            ArrayList<Grouping> sources = new ArrayList<Grouping>(this.groupers);
            sources.add(FALLBACK_GROUP);
            LinkedMultiValueMap result = new LinkedMultiValueMap();
            ArrayList alreadyMapped = new ArrayList();
            sources.forEach(arg_0 -> CanvasOptions.lambda$groupBeans$5(module, alreadyMapped, (MultiValueMap)result, arg_0));
            new HashSet(result.keySet()).forEach(arg_0 -> CanvasOptions.lambda$groupBeans$6((MultiValueMap)result, arg_0));
            return Groupings.of((MultiValueMap<Grouping, SpringBean>)result);
        }

        private Optional<String> getTargetFileName() {
            return Optional.ofNullable(this.targetFileName);
        }

        private static List<SpringBean> getMatchingBeans(Module module, Grouping filter, List<SpringBean> alreadyMapped) {
            return module.getSpringBeans().stream().filter(it -> !alreadyMapped.contains(it)).filter(filter::matches).collect(Collectors.toList());
        }

        @Generated
        CanvasOptions(List<Grouping> groupers, @Nullable String apiBase, @Nullable String targetFileName) {
            this.groupers = groupers;
            this.apiBase = apiBase;
            this.targetFileName = targetFileName;
        }

        @Generated
        public CanvasOptions withApiBase(@Nullable String apiBase) {
            return this.apiBase == apiBase ? this : new CanvasOptions(this.groupers, apiBase, this.targetFileName);
        }

        @Nullable
        @Generated
        public String getApiBase() {
            return this.apiBase;
        }

        @Generated
        public CanvasOptions withTargetFileName(@Nullable String targetFileName) {
            return this.targetFileName == targetFileName ? this : new CanvasOptions(this.groupers, this.apiBase, targetFileName);
        }

        private static /* synthetic */ void lambda$groupBeans$6(MultiValueMap result, Grouping key) {
            if (((List)result.get((Object)key)).isEmpty()) {
                result.remove((Object)key);
            }
        }

        private static /* synthetic */ void lambda$groupBeans$5(Module module, List alreadyMapped, MultiValueMap result, Grouping it) {
            List<SpringBean> matchingBeans = CanvasOptions.getMatchingBeans(module, it, alreadyMapped);
            result.addAll((Object)it, matchingBeans);
            alreadyMapped.addAll(matchingBeans);
        }

        static class Groupings {
            private final MultiValueMap<Grouping, SpringBean> groupings;

            Set<Grouping> keySet() {
                return this.groupings.keySet();
            }

            List<SpringBean> byGrouping(Grouping grouping) {
                return this.byFilter(grouping::equals);
            }

            List<SpringBean> byGroupName(String name) {
                return this.byFilter(it -> it.getName().equals(name));
            }

            void forEach(BiConsumer<Grouping, List<SpringBean>> consumer) {
                this.groupings.forEach(consumer);
            }

            private List<SpringBean> byFilter(Predicate<Grouping> filter) {
                return this.groupings.entrySet().stream().filter(it -> filter.test((Grouping)it.getKey())).findFirst().map(Map.Entry::getValue).orElseGet(Collections::emptyList);
            }

            boolean hasOnlyFallbackGroup() {
                return this.groupings.size() == 1 && this.groupings.get((Object)FALLBACK_GROUP) != null;
            }

            @Generated
            private Groupings(MultiValueMap<Grouping, SpringBean> groupings) {
                this.groupings = groupings;
            }

            @Generated
            static Groupings of(MultiValueMap<Grouping, SpringBean> groupings) {
                return new Groupings(groupings);
            }
        }

        public static final class Grouping {
            private final String name;
            @Nullable
            private final String description;
            private final Predicate<SpringBean> predicate;

            public static Grouping of(String name) {
                return new Grouping(name, null, __ -> false);
            }

            public static Grouping of(String name, Predicate<SpringBean> predicate) {
                return new Grouping(name, null, predicate);
            }

            public boolean matches(SpringBean candidate) {
                return this.predicate.test(candidate);
            }

            public static Predicate<SpringBean> nameMatching(String pattern) {
                return bean -> bean.getFullyQualifiedTypeName().matches(pattern);
            }

            public static Predicate<SpringBean> implementing(Class<?> type) {
                return bean -> bean.getType().isAssignableTo(type);
            }

            public static Predicate<SpringBean> subtypeOf(Class<?> type) {
                return Grouping.implementing(type).and(bean -> !bean.getType().isEquivalentTo(type));
            }

            @Generated
            private Grouping(String name, @Nullable String description, Predicate<SpringBean> predicate) {
                this.name = name;
                this.description = description;
                this.predicate = predicate;
            }

            @Generated
            public static Grouping of(String name, @Nullable String description, Predicate<SpringBean> predicate) {
                return new Grouping(name, description, predicate);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grouping)) {
                    return false;
                }
                Grouping other = (Grouping)o;
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                Predicate<SpringBean> this$predicate = this.getPredicate();
                Predicate<SpringBean> other$predicate = other.getPredicate();
                return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                Predicate<SpringBean> $predicate = this.getPredicate();
                result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Documenter.CanvasOptions.Grouping(name=" + this.getName() + ", description=" + this.getDescription() + ", predicate=" + this.getPredicate() + ")";
            }

            @Generated
            String getName() {
                return this.name;
            }

            @Nullable
            @Generated
            String getDescription() {
                return this.description;
            }

            @Generated
            Predicate<SpringBean> getPredicate() {
                return this.predicate;
            }
        }
    }

    public static class Options {
        private static Set<Module.DependencyType> ALL_TYPES = Arrays.stream(Module.DependencyType.values()).collect(Collectors.toSet());
        private final Set<Module.DependencyType> dependencyTypes;
        private final Module.DependencyDepth dependencyDepth;
        private final Predicate<Module> exclusions;
        private final Predicate<Component> componentFilter;
        private final Predicate<Module> targetOnly;
        @Nullable
        private final String targetFileName;
        private final Function<Module, Optional<String>> colorSelector;
        private final Function<Module, String> defaultDisplayName;
        private final DiagramStyle style;

        public static Options defaults() {
            return new Options(ALL_TYPES, Module.DependencyDepth.IMMEDIATE, it -> false, it -> true, it -> false, null, __ -> Optional.empty(), it -> it.getDisplayName(), DiagramStyle.UML);
        }

        public Options withDependencyTypes(Module.DependencyType ... types) {
            Assert.notNull((Object)types, (String)"Dependency types must not be null!");
            Set<Module.DependencyType> dependencyTypes = Arrays.stream(types).collect(Collectors.toSet());
            return new Options(dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style);
        }

        private Optional<String> getTargetFileName() {
            return Optional.ofNullable(this.targetFileName);
        }

        private Stream<Module.DependencyType> getDependencyTypes() {
            return this.dependencyTypes.stream();
        }

        private PlantUMLWriter getWriter() {
            switch (this.style) {
                case C4: {
                    return new C4PlantUMLWriter();
                }
            }
            BasicPlantUMLWriter writer = new BasicPlantUMLWriter();
            writer.addSkinParam("componentStyle", "uml1");
            return writer;
        }

        @Generated
        private Module.DependencyDepth getDependencyDepth() {
            return this.dependencyDepth;
        }

        @Generated
        private Predicate<Module> getExclusions() {
            return this.exclusions;
        }

        @Generated
        private Predicate<Component> getComponentFilter() {
            return this.componentFilter;
        }

        @Generated
        private Predicate<Module> getTargetOnly() {
            return this.targetOnly;
        }

        @Generated
        private Function<Module, Optional<String>> getColorSelector() {
            return this.colorSelector;
        }

        @Generated
        private Function<Module, String> getDefaultDisplayName() {
            return this.defaultDisplayName;
        }

        @Generated
        private DiagramStyle getStyle() {
            return this.style;
        }

        @Generated
        private Options(Set<Module.DependencyType> dependencyTypes, Module.DependencyDepth dependencyDepth, Predicate<Module> exclusions, Predicate<Component> componentFilter, Predicate<Module> targetOnly, @Nullable String targetFileName, Function<Module, Optional<String>> colorSelector, Function<Module, String> defaultDisplayName, DiagramStyle style) {
            this.dependencyTypes = dependencyTypes;
            this.dependencyDepth = dependencyDepth;
            this.exclusions = exclusions;
            this.componentFilter = componentFilter;
            this.targetOnly = targetOnly;
            this.targetFileName = targetFileName;
            this.colorSelector = colorSelector;
            this.defaultDisplayName = defaultDisplayName;
            this.style = style;
        }

        @Generated
        public Options withDependencyDepth(Module.DependencyDepth dependencyDepth) {
            return this.dependencyDepth == dependencyDepth ? this : new Options(this.dependencyTypes, dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style);
        }

        @Generated
        public Options withExclusions(Predicate<Module> exclusions) {
            return this.exclusions == exclusions ? this : new Options(this.dependencyTypes, this.dependencyDepth, exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style);
        }

        @Generated
        public Options withComponentFilter(Predicate<Component> componentFilter) {
            return this.componentFilter == componentFilter ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style);
        }

        @Generated
        public Options withTargetOnly(Predicate<Module> targetOnly) {
            return this.targetOnly == targetOnly ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, this.style);
        }

        @Generated
        public Options withTargetFileName(@Nullable String targetFileName) {
            return this.targetFileName == targetFileName ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, targetFileName, this.colorSelector, this.defaultDisplayName, this.style);
        }

        @Generated
        public Options withColorSelector(Function<Module, Optional<String>> colorSelector) {
            return this.colorSelector == colorSelector ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, colorSelector, this.defaultDisplayName, this.style);
        }

        @Generated
        public Options withDefaultDisplayName(Function<Module, String> defaultDisplayName) {
            return this.defaultDisplayName == defaultDisplayName ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, defaultDisplayName, this.style);
        }

        @Generated
        public Options withStyle(DiagramStyle style) {
            return this.style == style ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName, style);
        }

        public static enum DiagramStyle {
            UML,
            C4;

        }
    }

    private static final class Connection {
        private final Element source;
        private final Element target;

        public static Connection of(Relationship relationship) {
            return new Connection(relationship.getSource(), relationship.getDestination());
        }

        @Generated
        public Connection(Element source, Element target) {
            this.source = source;
            this.target = target;
        }

        @Generated
        public Element getSource() {
            return this.source;
        }

        @Generated
        public Element getTarget() {
            return this.target;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection other = (Connection)o;
            Element this$source = this.getSource();
            Element other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            Element this$target = this.getTarget();
            Element other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !this$target.equals(other$target));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Element $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            Element $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Documenter.Connection(source=" + this.getSource() + ", target=" + this.getTarget() + ")";
        }
    }
}

