/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.docs;

import com.structurizr.Workspace;
import com.structurizr.io.plantuml.PlantUMLWriter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ComponentView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.moduliths.docs.Asciidoctor;
import org.moduliths.model.Module;
import org.moduliths.model.Modules;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Documenter {
    private static final String DEFAULT_LOCATION = "target/moduliths-docs";
    private static final Map<Module.DependencyType, String> DEPENDENCY_DESCRIPTIONS = new LinkedHashMap<Module.DependencyType, String>();
    private static final String INVALID_FILE_NAME_PATTERN = "Configured file name pattern does not include a '%s' placeholder for the module name!";
    private final Modules modules;
    private final Workspace workspace;
    private final Container container;
    private Map<Module, Component> components;

    public Documenter(Class<?> modulithType) {
        this(Modules.of(modulithType));
    }

    public Documenter(Modules modules) {
        Assert.notNull((Object)modules, (String)"Modules must not be null!");
        this.modules = modules;
        this.workspace = new Workspace("Modulith", "");
        Model model = this.workspace.getModel();
        String systemName = modules.getSystemName().orElse("Modulith");
        SoftwareSystem system = model.addSoftwareSystem(systemName, "");
        this.container = system.addContainer("Application", "", "");
    }

    private Map<Module, Component> getComponents(Options options) {
        if (this.components == null) {
            this.components = this.modules.stream().collect(Collectors.toMap(Function.identity(), it -> this.container.addComponent((String)options.getDefaultDisplayName().apply(it), "", "Module")));
            this.components.forEach((key, value) -> this.addDependencies((Module)key, (Component)value, options));
        }
        return this.components;
    }

    public void writeModulesAsPlantUml(Options options) throws IOException {
        Assert.notNull((Object)options, (String)"Options must not be null!");
        Path file = Documenter.recreateFile(options.getTargetFileName().orElse("components.uml"));
        try (FileWriter writer = new FileWriter(file.toFile());){
            this.createPlantUml(writer, options);
        }
    }

    public void writeModuleAsPlantUml(Module module) {
        Assert.notNull((Object)module, (String)"Module must not be null!");
        this.writeModuleAsPlantUml(module, Options.defaults());
    }

    public void writeModuleAsPlantUml(Module module, Options options) {
        Assert.notNull((Object)module, (String)"Module must not be null!");
        Assert.notNull((Object)options, (String)"Options must not be null!");
        ComponentView view = this.workspace.getViews().createComponentView(this.container, module.getName(), "");
        view.setTitle((String)options.getDefaultDisplayName().apply(module));
        this.addComponentsToView(module, view, options);
        String fileNamePattern = options.getTargetFileName().orElse("module-%s.uml");
        Assert.isTrue((boolean)fileNamePattern.contains("%s"), () -> String.format(INVALID_FILE_NAME_PATTERN, fileNamePattern));
        this.writeViewAsPlantUml((View)view, String.format(fileNamePattern, module.getName()), options);
    }

    public void writeModuleCanvases(String javadocBase) {
        Options options = Options.defaults();
        this.modules.forEach(module -> {
            String filename = String.format(options.getTargetFileName().orElse("module-%s.adoc"), module.getName());
            Path file = Documenter.recreateFile(filename);
            try (FileWriter writer = new FileWriter(file.toFile());){
                writer.write(this.toModuleCanvas((Module)module, javadocBase));
            }
            catch (IOException o_O) {
                throw new RuntimeException(o_O);
            }
        });
    }

    public String toModuleCanvas(Module module) {
        return this.toModuleCanvas(module, "{javadocBase}");
    }

    public String toModuleCanvas(Module module, String apiBase) {
        Asciidoctor asciidoctor = Asciidoctor.withJavadocBase(apiBase, module);
        Function mapper = asciidoctor::typesToBulletPoints;
        StringBuilder builder = new StringBuilder();
        builder.append(Asciidoctor.startTable("%autowidth.stretch, cols=\"h,a\""));
        builder.append(Asciidoctor.writeTableRow("Base package", asciidoctor.toInlineCode(module.getBasePackage().getName())));
        builder.append(this.addTableRow(module.getSpringBeans(), "Spring components", asciidoctor::beansToBulletPoints));
        builder.append(this.addTableRow(module.getAggregateRoots(this.modules), "Aggregate roots", mapper));
        builder.append(this.addTableRow(module.getEventsPublished(), "Published events", mapper));
        builder.append(this.addTableRow(module.getEventsListenedTo(this.modules), "Events listened to", mapper));
        builder.append(Asciidoctor.startOrEndTable());
        return builder.toString();
    }

    private <T> String addTableRow(List<T> types, String header, Function<List<T>, String> mapper) {
        return types.isEmpty() ? "" : Asciidoctor.writeTableRow(header, mapper.apply(types));
    }

    public String toPlantUml() throws IOException {
        return this.createPlantUml(new StringWriter(), Options.defaults()).toString();
    }

    private void addDependencies(Module module, Component component, Options options) {
        DEPENDENCY_DESCRIPTIONS.entrySet().stream().forEach(entry -> module.getDependencies(this.modules, new Module.DependencyType[]{(Module.DependencyType)entry.getKey()}).stream().map(it -> this.getComponents(options).get(it)).forEach(it -> {
            Relationship relationship = component.uses(it, (String)entry.getValue());
            relationship.addTags(new String[]{((Module.DependencyType)entry.getKey()).toString()});
        }));
        module.getBootstrapDependencies(this.modules).forEach(it -> {
            Relationship relationship = component.uses(this.getComponents(options).get(it), "uses");
            relationship.addTags(new String[]{Module.DependencyType.USES_COMPONENT.toString()});
        });
    }

    private void addComponentsToView(Module module, ComponentView view, Options options) {
        Supplier<Stream> bootstrapDependencies = () -> module.getBootstrapDependencies(this.modules, options.getDependencyDepth());
        Supplier<Stream> otherDependencies = () -> options.getDependencyTypes().flatMap(it -> module.getDependencies(this.modules, new Module.DependencyType[]{it}).stream());
        Supplier<Stream<Module>> dependencies = () -> Stream.concat((Stream)bootstrapDependencies.get(), (Stream)otherDependencies.get());
        this.addComponentsToView(dependencies, view, options, it -> it.add(this.getComponents(options).get(module)));
    }

    private void addComponentsToView(Supplier<Stream<Module>> modules, ComponentView view, Options options, Consumer<ComponentView> afterCleanup) {
        modules.get().filter(options.getExclusions().negate()).map(it -> this.getComponents(options).get(it)).filter(options.getComponentFilter()).forEach(arg_0 -> ((ComponentView)view).add(arg_0));
        Module.DependencyType.allBut((Stream)options.getDependencyTypes()).map(Object::toString).forEach(it -> view.removeRelationshipsWithTag(it));
        afterCleanup.accept(view);
        modules.get().filter(options.getTargetOnly()).forEach(module -> {
            Component component = this.getComponents(options).get(module);
            view.getRelationships().stream().map(RelationshipView::getRelationship).filter(it -> it.getSource().equals((Object)component)).forEach(it -> view.remove(it));
        });
        view.removeElementsWithNoRelationships();
        afterCleanup.accept(view);
        view.getRelationships().stream().map(RelationshipView::getRelationship).collect(Collectors.groupingBy(Connection::of)).values().stream().forEach(it -> this.potentiallyRemoveDefaultRelationship((View)view, (Collection<Relationship>)it));
    }

    private void potentiallyRemoveDefaultRelationship(View view, Collection<Relationship> relationships) {
        if (relationships.size() <= 1) {
            return;
        }
        relationships.stream().filter(it -> it.getTagsAsSet().contains(Module.DependencyType.DEFAULT.toString())).findFirst().ifPresent(arg_0 -> ((View)view).remove(arg_0));
    }

    private void writeViewAsPlantUml(View view, String filename, Options options) {
        try {
            Path file = Documenter.recreateFile(filename);
            try (FileWriter writer = new FileWriter(file.toFile());){
                this.getPlantUMLWriter(options).write(view, (Writer)writer);
            }
        }
        catch (IOException o_O) {
            throw new RuntimeException(o_O);
        }
    }

    private PlantUMLWriter getPlantUMLWriter(Options options) {
        return new CustomPlantUmlWriter(options.getColorSelector(), this.getComponents(options));
    }

    private <T extends Writer> T createPlantUml(T writer, Options options) throws IOException {
        ComponentView componentView = this.workspace.getViews().createComponentView(this.container, "modules-" + options.toString(), "");
        componentView.setTitle(this.modules.getSystemName().orElse("Modules"));
        this.addComponentsToView(() -> this.modules.stream(), componentView, options, it -> {});
        this.getPlantUMLWriter(options).write((View)componentView, writer);
        return writer;
    }

    private static Path recreateFile(String name) {
        try {
            Files.createDirectories(Paths.get(DEFAULT_LOCATION, new String[0]), new FileAttribute[0]);
            Path filePath = Paths.get(DEFAULT_LOCATION, name);
            Files.deleteIfExists(filePath);
            return Files.createFile(filePath, new FileAttribute[0]);
        }
        catch (IOException o_O) {
            throw new RuntimeException(o_O);
        }
    }

    public Modules getModules() {
        return this.modules;
    }

    static {
        DEPENDENCY_DESCRIPTIONS.put(Module.DependencyType.EVENT_LISTENER, "listens to");
        DEPENDENCY_DESCRIPTIONS.put(Module.DependencyType.DEFAULT, "depends on");
    }

    private static class CustomPlantUmlWriter
    extends PlantUMLWriter {
        private final Function<Module, Optional<String>> colorSelector;
        private final Map<Module, Component> components;

        protected String backgroundOf(@Nullable View view, @Nullable Element element) {
            if (!Component.class.isInstance(element)) {
                return super.backgroundOf(view, element);
            }
            Component component = (Component)element;
            return this.components.entrySet().stream().filter(it -> ((Component)it.getValue()).equals((Object)component)).map(Map.Entry::getKey).findFirst().flatMap(this.colorSelector).orElseGet(() -> super.backgroundOf(view, element));
        }

        public CustomPlantUmlWriter(Function<Module, Optional<String>> colorSelector, Map<Module, Component> components) {
            this.colorSelector = colorSelector;
            this.components = components;
        }
    }

    public static class Options {
        private static Set<Module.DependencyType> ALL_TYPES = Arrays.stream(Module.DependencyType.values()).collect(Collectors.toSet());
        private final Set<Module.DependencyType> dependencyTypes;
        private final Module.DependencyDepth dependencyDepth;
        private final Predicate<Module> exclusions;
        private final Predicate<Component> componentFilter;
        private final Predicate<Module> targetOnly;
        @Nullable
        private final String targetFileName;
        private final Function<Module, Optional<String>> colorSelector;
        private final Function<Module, String> defaultDisplayName;

        public static Options defaults() {
            return new Options(ALL_TYPES, Module.DependencyDepth.IMMEDIATE, it -> false, it -> true, it -> false, null, __ -> Optional.empty(), it -> it.getDisplayName());
        }

        public Options withDependencyTypes(Module.DependencyType ... types) {
            Assert.notNull((Object)types, (String)"Dependency types must not be null!");
            Set<Module.DependencyType> dependencyTypes = Arrays.stream(types).collect(Collectors.toSet());
            return new Options(dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName);
        }

        private Optional<String> getTargetFileName() {
            return Optional.ofNullable(this.targetFileName);
        }

        private Stream<Module.DependencyType> getDependencyTypes() {
            return this.dependencyTypes.stream();
        }

        private Module.DependencyDepth getDependencyDepth() {
            return this.dependencyDepth;
        }

        private Predicate<Module> getExclusions() {
            return this.exclusions;
        }

        private Predicate<Component> getComponentFilter() {
            return this.componentFilter;
        }

        private Predicate<Module> getTargetOnly() {
            return this.targetOnly;
        }

        private Function<Module, Optional<String>> getColorSelector() {
            return this.colorSelector;
        }

        private Function<Module, String> getDefaultDisplayName() {
            return this.defaultDisplayName;
        }

        private Options(Set<Module.DependencyType> dependencyTypes, Module.DependencyDepth dependencyDepth, Predicate<Module> exclusions, Predicate<Component> componentFilter, Predicate<Module> targetOnly, @Nullable String targetFileName, Function<Module, Optional<String>> colorSelector, Function<Module, String> defaultDisplayName) {
            this.dependencyTypes = dependencyTypes;
            this.dependencyDepth = dependencyDepth;
            this.exclusions = exclusions;
            this.componentFilter = componentFilter;
            this.targetOnly = targetOnly;
            this.targetFileName = targetFileName;
            this.colorSelector = colorSelector;
            this.defaultDisplayName = defaultDisplayName;
        }

        public Options withDependencyDepth(Module.DependencyDepth dependencyDepth) {
            return this.dependencyDepth == dependencyDepth ? this : new Options(this.dependencyTypes, dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName);
        }

        public Options withExclusions(Predicate<Module> exclusions) {
            return this.exclusions == exclusions ? this : new Options(this.dependencyTypes, this.dependencyDepth, exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName);
        }

        public Options withComponentFilter(Predicate<Component> componentFilter) {
            return this.componentFilter == componentFilter ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName);
        }

        public Options withTargetOnly(Predicate<Module> targetOnly) {
            return this.targetOnly == targetOnly ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, targetOnly, this.targetFileName, this.colorSelector, this.defaultDisplayName);
        }

        public Options withTargetFileName(@Nullable String targetFileName) {
            return this.targetFileName == targetFileName ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, targetFileName, this.colorSelector, this.defaultDisplayName);
        }

        public Options withColorSelector(Function<Module, Optional<String>> colorSelector) {
            return this.colorSelector == colorSelector ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, colorSelector, this.defaultDisplayName);
        }

        public Options withDefaultDisplayName(Function<Module, String> defaultDisplayName) {
            return this.defaultDisplayName == defaultDisplayName ? this : new Options(this.dependencyTypes, this.dependencyDepth, this.exclusions, this.componentFilter, this.targetOnly, this.targetFileName, this.colorSelector, defaultDisplayName);
        }
    }

    private static final class Connection {
        private final Element source;
        private final Element target;

        public static Connection of(Relationship relationship) {
            return new Connection(relationship.getSource(), relationship.getDestination());
        }

        public Connection(Element source, Element target) {
            this.source = source;
            this.target = target;
        }

        public Element getSource() {
            return this.source;
        }

        public Element getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection other = (Connection)o;
            Element this$source = this.getSource();
            Element other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            Element this$target = this.getTarget();
            Element other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !this$target.equals(other$target));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Element $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            Element $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            return result;
        }

        public String toString() {
            return "Documenter.Connection(source=" + this.getSource() + ", target=" + this.getTarget() + ")";
        }
    }
}

