/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.Logger;
import org.modeshape.jcr.api.NamedRepository;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jcr.api.RepositoryFactory;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.web.jcr.NoSuchRepositoryException;
import org.modeshape.web.jcr.WebLogger;

@ThreadSafe
public class RepositoryManager {
    private static final Logger LOGGER = WebLogger.getLogger(RepositoryManager.class);
    private static final Map<String, Object> factoryParams = new HashMap<String, Object>();
    private static final Map<String, Object> immutableFactoryParams = Collections.unmodifiableMap(factoryParams);

    private RepositoryManager() {
    }

    static synchronized void initialize(ServletContext context) {
        CheckArg.isNotNull((Object)context, (String)"context");
        factoryParams.clear();
        Enumeration names = context.getInitParameterNames();
        if (names == null) {
            RepositoryManager.addParameter("org.modeshape.jcr.URL", context);
            RepositoryManager.addParameter("org.modeshape.jcr.RepositoryName", context);
        } else {
            while (names.hasMoreElements()) {
                Object next = names.nextElement();
                if (next == null) continue;
                String name = next.toString();
                RepositoryManager.addParameter(name, context);
            }
        }
    }

    private static void addParameter(String name, ServletContext context) {
        String value = context.getInitParameter(name);
        if (value != null) {
            factoryParams.put(name, value);
        }
    }

    public static Session getSession(HttpServletRequest request, String repositoryName, String workspaceName) throws RepositoryException {
        Repository repository = RepositoryManager.getRepository(repositoryName);
        if (request == null || request.getUserPrincipal() == null) {
            return repository.login(workspaceName);
        }
        return repository.login((Credentials)new ServletCredentials(request), workspaceName);
    }

    public static Repository getRepository(String repositoryName) throws NoSuchRepositoryException {
        Repository repository = null;
        boolean found = false;
        for (javax.jcr.RepositoryFactory factory : ServiceLoader.load(javax.jcr.RepositoryFactory.class)) {
            found = true;
            if (factory instanceof Repositories) {
                Repositories repositories = (Repositories)factory;
                try {
                    repository = repositories.getRepository(repositoryName);
                    break;
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
            }
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(immutableFactoryParams);
                params.put("org.modeshape.jcr.RepositoryName", repositoryName);
                repository = factory.getRepository(params);
                if (repository == null) continue;
                break;
            }
            catch (RepositoryException e) {
            }
        }
        if (!found) {
            throw new IllegalStateException("No javax.jcr.RepositoryFactory implementation on the classpath");
        }
        if (repository == null) {
            throw new NoSuchRepositoryException("No repository named '" + repositoryName + "' was found");
        }
        return repository;
    }

    public static Set<String> getJcrRepositoryNames() {
        Set<String> jndiNames = RepositoryManager.searchJNDIForRepositoryNames(immutableFactoryParams);
        if (!jndiNames.isEmpty()) {
            return jndiNames;
        }
        HashSet<String> names = new HashSet<String>();
        boolean found = false;
        for (javax.jcr.RepositoryFactory factory : ServiceLoader.load(javax.jcr.RepositoryFactory.class)) {
            found = true;
            if (factory instanceof Repositories) {
                Repositories repositories = (Repositories)factory;
                Set someNames = repositories.getRepositoryNames();
                if (someNames.isEmpty()) {
                    try {
                        Repository repository = factory.getRepository(immutableFactoryParams);
                        if (repository instanceof NamedRepository) {
                            String name = ((NamedRepository)repository).getName();
                            names.add(name);
                        }
                    }
                    catch (RepositoryException e) {
                        LOGGER.warn((Throwable)e, "Error retrieving repository", new Object[0]);
                    }
                }
                names.addAll(repositories.getRepositoryNames());
                continue;
            }
            try {
                Repository repository = factory.getRepository(immutableFactoryParams);
                if (!(repository instanceof NamedRepository)) continue;
                String name = ((NamedRepository)repository).getName();
                names.add(name);
            }
            catch (RepositoryException e) {
                LOGGER.warn((Throwable)e, "Error retrieving repository", new Object[0]);
            }
        }
        if (!found) {
            throw new IllegalStateException("No RepositoryFactory implementation on the classpath");
        }
        return names;
    }

    private static Set<String> searchJNDIForRepositoryNames(Map<String, Object> parameters) {
        if (parameters == null || !parameters.containsKey("org.modeshape.jcr.URL")) {
            return Collections.emptySet();
        }
        String urlString = parameters.get("org.modeshape.jcr.URL").toString();
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Invalid URL:" + urlString, new Object[0]);
            return Collections.emptySet();
        }
        if (!"jndi".equals(url.getProtocol())) {
            return Collections.emptySet();
        }
        String jndiName = url.getPath();
        try {
            Hashtable<String, Object> icParams = new Hashtable<String, Object>();
            icParams.putAll(parameters);
            InitialContext ic = new InitialContext(icParams);
            Object ob = ic.lookup(jndiName);
            if (ob instanceof NamedRepository) {
                return Collections.singleton(((NamedRepository)ob).getName());
            }
            if (ob instanceof Repositories) {
                Repositories repos = (Repositories)ob;
                return repos.getRepositoryNames();
            }
        }
        catch (NamingException ne) {
            LOGGER.warn((Throwable)ne, "Exception while searching JNDI", new Object[0]);
        }
        return Collections.emptySet();
    }

    static void shutdown() {
        for (javax.jcr.RepositoryFactory factory : ServiceLoader.load(javax.jcr.RepositoryFactory.class)) {
            if (!(factory instanceof RepositoryFactory)) continue;
            RepositoryFactory modeShapeFactory = (RepositoryFactory)factory;
            modeShapeFactory.shutdown();
        }
    }
}

