/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.model.JSONAble;

public final class RestRepositories
implements JSONAble {
    private final List<Repository> repositories = new ArrayList<Repository>();

    public Repository addRepository(String name, HttpServletRequest request) {
        Repository repository = new Repository(name, request);
        this.repositories.add(repository);
        return repository;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray repositories = new JSONArray();
        for (Repository repository : this.repositories) {
            repositories.put((Object)repository.toJSON());
        }
        result.put("repositories", (Object)repositories);
        return result;
    }

    public final class Repository
    implements JSONAble {
        private final String name;
        private final String workspacesUrl;
        private final Map<String, List<String>> metadata;
        private final String backupUrl;
        private final String restoreUrl;
        private int activeSessionsCount;

        protected Repository(String name, HttpServletRequest request) {
            this.name = name;
            this.workspacesUrl = RestHelper.urlFrom(request, name);
            this.backupUrl = RestHelper.urlFrom(request, name, "backup");
            this.restoreUrl = RestHelper.urlFrom(request, name, "restore");
            this.metadata = new TreeMap<String, List<String>>();
        }

        public void addMetadata(String key, List<String> value) {
            if (key != null && value != null && !value.isEmpty()) {
                this.metadata.put(key, value);
            }
        }

        public void setActiveSessionsCount(int activeSessionsCount) {
            this.activeSessionsCount = activeSessionsCount;
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject object = new JSONObject();
            object.put("name", (Object)this.name);
            object.put("workspaces", (Object)this.workspacesUrl);
            object.put("backup", (Object)this.backupUrl);
            object.put("restore", (Object)this.restoreUrl);
            object.put("activeSessionsCount", this.activeSessionsCount);
            JSONObject metadata = new JSONObject();
            for (String metadataKey : this.metadata.keySet()) {
                List<String> values = this.metadata.get(metadataKey);
                if (values.size() == 1) {
                    metadata.put(metadataKey, (Object)values.get(0));
                    continue;
                }
                metadata.put(metadataKey, values);
            }
            object.put("metadata", (Object)metadata);
            return object;
        }
    }
}

