/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.jcr.api.Logger;
import org.modeshape.web.jcr.RepositoryManager;
import org.modeshape.web.jcr.WebLogger;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.modeshape.web.jcr.rest.model.RestNode;
import org.modeshape.web.jcr.rest.model.RestProperty;

public abstract class AbstractHandler {
    protected static final String BASE64_ENCODING_SUFFIX = "/base64/";
    public static final String EMPTY_REPOSITORY_NAME = "<default>";
    public static final String NODE_ID_CUSTOM_PROPERTY = "id";
    protected static final String EMPTY_WORKSPACE_NAME = "<default>";
    protected final Logger logger = WebLogger.getLogger(this.getClass());

    protected Session getSession(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName) throws RepositoryException {
        assert (request != null);
        return RepositoryManager.getSession((HttpServletRequest)request, (String)this.repositoryNameFor(rawRepositoryName), (String)this.workspaceNameFor(rawWorkspaceName));
    }

    private String workspaceNameFor(String rawWorkspaceName) {
        String workspaceName = RestHelper.URL_ENCODER.decode(rawWorkspaceName);
        if ("<default>".equals(workspaceName)) {
            workspaceName = "";
        }
        return workspaceName;
    }

    private String repositoryNameFor(String rawRepositoryName) {
        String repositoryName = RestHelper.URL_ENCODER.decode(rawRepositoryName);
        if ("<default>".equals(repositoryName)) {
            repositoryName = "";
        }
        return repositoryName;
    }

    protected List<String> restPropertyValues(Property property, String baseUrl, Session session) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        if (property.isMultiple()) {
            Value[] values = property.getValues();
            if (values == null || values.length == 0) {
                return null;
            }
            if (values.length == 1) {
                String value = this.valueToString(property.getPath(), values[0], baseUrl, session);
                if (value != null) {
                    result.add(value);
                }
            } else {
                for (Value value : values) {
                    String valueString;
                    if (value == null || (valueString = this.valueToString(property.getPath(), value, baseUrl, session)) == null) continue;
                    result.add(valueString);
                }
            }
        } else {
            result.add(this.valueToString(property.getPath(), property.getValue(), baseUrl, session));
        }
        return result;
    }

    protected String valueToString(String absPropertyPath, Value value, String baseUrl, Session session) {
        if (value == null) {
            return null;
        }
        try {
            switch (value.getType()) {
                case 2: {
                    assert (baseUrl != null);
                    return this.restValueForBinary(absPropertyPath, baseUrl);
                }
                case 9: 
                case 10: {
                    assert (session != null);
                    return this.restValueForReference(value, baseUrl, session);
                }
            }
            return value.getString();
        }
        catch (Exception e) {
            this.logger.error("Cannot create JSON string from value ", new Object[]{e});
            return null;
        }
    }

    private String restValueForReference(Value value, String baseUrl, Session session) throws RepositoryException {
        String nodeId = value.getString();
        Node referredNode = session.getNodeByIdentifier(nodeId);
        if (referredNode != null) {
            return RestHelper.urlFrom(baseUrl, "items", referredNode.getPath());
        }
        this.logger.warn("Cannot resolve reference with id: {0}", new Object[]{nodeId});
        return nodeId;
    }

    private String restValueForBinary(String absPropertyPath, String baseUrl) {
        if (absPropertyPath == null) {
            this.logger.warn("Cannot generate rest representation of a binary value, because the property is unknown", new Object[0]);
            return null;
        }
        return RestHelper.urlFrom(baseUrl, "binary", absPropertyPath);
    }

    protected Node getParentNode(Property property) throws RepositoryException {
        Node parentNode = property.getParent();
        if ("jcr:content".equalsIgnoreCase(parentNode.getName()) && parentNode.getIndex() == 1) {
            parentNode = parentNode.getParent();
        }
        return parentNode;
    }

    protected Item itemAtPath(String path, Session session) throws RepositoryException {
        return this.isRootPath(path) ? session.getRootNode() : session.getItem(path);
    }

    protected Node nodeWithId(String id, Session session) throws RepositoryException {
        return session.getNodeByIdentifier(id);
    }

    protected boolean isRootPath(String path) {
        return "/".equals(path) || "".equals(path);
    }

    protected RestItem createRestItem(HttpServletRequest request, int depth, Session session, Item item) throws RepositoryException {
        String baseUrl = RestHelper.repositoryUrl(request);
        return item instanceof Node ? this.createRestNode(session, (Node)item, baseUrl, depth) : this.createRestProperty(session, (Property)item, baseUrl);
    }

    protected String parentPath(String path) {
        int lastSlashInd = path.lastIndexOf(47);
        if (lastSlashInd == -1) {
            return "/";
        }
        String subPath = path.substring(0, lastSlashInd);
        return this.absPath(subPath);
    }

    protected String absPath(String pathString) {
        return pathString.startsWith("/") ? pathString : "/" + pathString;
    }

    protected String nodeName(Node node) throws RepositoryException {
        int index = node.getIndex();
        String name = node.getName();
        if (index != 1) {
            name = name + "[" + index + "]";
        }
        return name;
    }

    private RestNode createRestNode(Session session, Node node, String baseUrl, int depth) throws RepositoryException {
        String nodeUrl = RestHelper.urlFrom(baseUrl, "items", node.getPath());
        boolean isRoot = node.getPath().equals("/");
        String parentUrl = isRoot ? RestHelper.urlFrom(baseUrl, "items", "..", "..") : RestHelper.urlFrom(baseUrl, "items", node.getParent().getPath());
        RestNode restNode = new RestNode(node.getName(), node.getIdentifier(), nodeUrl, parentUrl);
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            restNode.addJcrProperty(this.createRestProperty(session, property, baseUrl));
        }
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node childNode = nodeIterator.nextNode();
            RestNode restChild = null;
            if (depth != 0) {
                restChild = this.createRestNode(session, childNode, baseUrl, depth - 1);
            } else {
                String childUrl = RestHelper.urlFrom(baseUrl, "items", childNode.getPath());
                restChild = new RestNode(this.nodeName(childNode), childNode.getIdentifier(), childUrl, nodeUrl);
            }
            restNode.addChild(restChild);
        }
        return restNode;
    }

    private RestProperty createRestProperty(Session session, Property property, String baseUrl) throws RepositoryException {
        List<String> values = this.restPropertyValues(property, baseUrl, session);
        String url = RestHelper.urlFrom(baseUrl, "items", property.getPath());
        String parentUrl = RestHelper.urlFrom(baseUrl, "items", property.getParent().getPath());
        boolean multiValued = property.isMultiple();
        return new RestProperty(property.getName(), url, parentUrl, values, multiValued);
    }
}

