/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.util.ArrayList;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.web.jcr.RepositoryManager;
import org.modeshape.web.jcr.rest.AbstractHandler;

@Immutable
class ServerHandler
extends AbstractHandler {
    ServerHandler() {
    }

    public String getRepositories(HttpServletRequest request) throws JSONException, RepositoryException {
        assert (request != null);
        JSONObject jsonRepositories = new JSONObject();
        String uri = request.getRequestURI();
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        Set repoNames = RepositoryManager.getJcrRepositoryNames();
        for (String repoName : repoNames) {
            if (repoName.trim().length() == 0) {
                repoName = "<default>";
            }
            String name = URL_ENCODER.encode(repoName);
            JSONObject repository = new JSONObject();
            JSONObject resources = new JSONObject();
            resources.put("workspaces", (Object)(uri + "/" + name));
            repository.put("name", (Object)name);
            repository.put("resources", (Object)resources);
            try {
                JSONObject metadata;
                String workspaceName = null;
                Session session = this.getSession(request, name, workspaceName);
                if (session != null && (metadata = this.getRepositoryMetadata(session)) != null) {
                    repository.put("metadata", (Object)metadata);
                }
                JSONObject mapped = new JSONObject();
                mapped.put("repository", (Object)repository);
                jsonRepositories.put(name, (Object)mapped);
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return jsonRepositories.toString();
    }

    protected JSONObject getRepositoryMetadata(Session session) throws JSONException, RepositoryException {
        JSONObject metadata = new JSONObject();
        Repository repository = session.getRepository();
        for (String key : repository.getDescriptorKeys()) {
            Value[] values = repository.getDescriptorValues(key);
            if (values == null) continue;
            if (values.length == 1) {
                Value value = values[0];
                if (value == null) continue;
                metadata.put(key, (Object)this.jsonEncodedStringFor(value));
                continue;
            }
            ArrayList<String> valueStrings = new ArrayList<String>();
            for (Value value : values) {
                if (value == null) continue;
                valueStrings.add(this.jsonEncodedStringFor(value));
            }
            if (valueStrings.isEmpty()) continue;
            if (valueStrings.size() == 1) {
                metadata.put(key, valueStrings.get(0));
                continue;
            }
            metadata.put(key, (Object)new JSONArray(valueStrings));
        }
        return metadata;
    }
}

