/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import net.jcip.annotations.Immutable;
import org.modeshape.web.jcr.RepositoryFactory;
import org.modeshape.web.jcr.rest.AbstractJcrResource;
import org.modeshape.web.jcr.rest.model.RepositoryEntry;

@Immutable
@Path(value="/")
public class ServerResource
extends AbstractJcrResource {
    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Map<String, RepositoryEntry> getRepositories(@Context HttpServletRequest request) {
        assert (request != null);
        HashMap<String, RepositoryEntry> repositories = new HashMap<String, RepositoryEntry>();
        for (String name : RepositoryFactory.getJcrRepositoryNames()) {
            if (name.trim().length() == 0) {
                name = "<default>";
            }
            name = URL_ENCODER.encode(name);
            repositories.put(name, new RepositoryEntry(request.getContextPath(), name));
        }
        return repositories;
    }
}

