/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.AddMixinDialog;
import org.modeshape.web.client.AddPrincipalDialog;
import org.modeshape.web.client.AddPropertyDialog;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.Contents;
import org.modeshape.web.client.ExportDialog;
import org.modeshape.web.client.ImportDialog;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.NewNodeDialog;
import org.modeshape.web.client.RemoveMixinDialog;
import org.modeshape.web.client.RenameNodeDialog;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;
import org.modeshape.web.client.grid.AccessList;
import org.modeshape.web.client.grid.Children;
import org.modeshape.web.client.grid.Properties;
import org.modeshape.web.client.grid.TabGrid;
import org.modeshape.web.client.grid.TabsetGrid;
import org.modeshape.web.shared.Acl;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrPermission;
import org.modeshape.web.shared.Policy;

public class Contents
extends View {
    private Console console;
    private JcrServiceAsync jcrService;
    private String repository;
    private JcrNode node;
    private String path;
    private ComboBoxItem workspaces = new ComboBoxItem();
    private PathLabel pathLabel = new PathLabel(this);
    private Children children = new Children(this);
    private Properties properties = new Properties(this);
    private AccessList accessList = new AccessList(this);
    private TabsetGrid mainGrid = new TabsetGrid(new String[]{"Children", "Properties", "Access list"}, new TabGrid[]{this.children, this.properties, this.accessList});
    private NewNodeDialog newNodeDialog = new NewNodeDialog(this);
    private RenameNodeDialog renameNodeDialog = new RenameNodeDialog(this);
    private AddMixinDialog addMixinDialog = new AddMixinDialog(this);
    private RemoveMixinDialog removeMixinDialog = new RemoveMixinDialog(this);
    private AddPropertyDialog setPropertyDialog = new AddPropertyDialog(this);
    private AddPrincipalDialog addAccessListDialog = new AddPrincipalDialog(this);
    private ExportDialog exportDialog = new ExportDialog(this);
    private ImportDialog importDialog = new ImportDialog(this);
    private Button saveButton;

    public Contents(Console console, JcrServiceAsync jcrService, ViewPort viewPort) {
        super(viewPort, null);
        this.console = console;
        this.jcrService = jcrService;
        Canvas text = new Canvas();
        text.setContents("ModeShape is a distributed, hierarchical, transactional, and consistent data store with support for queries, full-text search, events, versioning, references, and flexible and dynamic schemas. It is very fast, highly available, extremely scalable, and it is 100% open source and written in Java. Clients use the JSR-283 standard Java API for content repositories (aka, JCR) or ModeShape's REST API, and can query content through JDBC and SQL.");
        text.setWidth100();
        text.setAutoHeight();
        text.setStyleName("caption");
        this.addMember(text);
        this.addMember((Canvas)new Spacer(this, 20));
        DynamicForm form = new DynamicForm();
        form.setFields(new FormItem[]{this.workspaces});
        this.workspaces.setTitle("Workspace");
        this.workspaces.addChangedHandler((ChangedHandler)new /* Unavailable Anonymous Inner Class!! */);
        VLayout wsPanel = new VLayout();
        wsPanel.addMember((Canvas)form);
        wsPanel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        wsPanel.setLayoutAlign(VerticalAlignment.CENTER);
        HLayout panel = new HLayout();
        panel.addMember((Canvas)wsPanel);
        panel.setStyleName("viewport");
        panel.setHeight(45);
        panel.setLayoutAlign(VerticalAlignment.CENTER);
        panel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        HLayout buttonPanel = new HLayout();
        buttonPanel.setWidth100();
        this.saveButton = new Button();
        this.saveButton.disable();
        this.saveButton.setTitle("Save");
        this.saveButton.setIcon("icons/save.png");
        this.saveButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        panel.addMember((Canvas)buttonPanel);
        this.addMember((Canvas)panel);
        panel.addMember((Canvas)this.saveButton);
        HLayout spacer = new HLayout();
        spacer.setWidth(5);
        panel.addMember((Canvas)spacer);
        VLayout strut = new VLayout();
        strut.setHeight(20);
        this.addMember((Canvas)strut);
        this.addMember((Canvas)this.pathLabel);
        this.addMember((Canvas)this.mainGrid);
    }

    public void show(String repository, boolean changeHistory) {
        this.repository = repository;
        this.jcrService.getWorkspaces(repository, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void select(String repository, String workspace, String path, boolean changeHistory) {
        this.repository = repository;
        this.jcrService.getWorkspaces(repository, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void select(String path, boolean changeHistory) {
        this.console.showLoadingIcon();
        this.path = path;
        this.jcrService.node(this.repository(), this.workspace(), path, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void export() {
        this.exportDialog.showModal();
    }

    public void importXML() {
        this.importDialog.showModal();
    }

    public void export(String name, boolean skipBinary, boolean noRecurse) {
        this.jcrService.export(this.repository, this.workspace(), this.path(), name, true, true, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void importXML(String name, int option) {
        this.jcrService.importXML(this.repository, this.workspace(), this.path(), name, option, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void removeNode() {
        String path = this.parent(this.path());
        this.jcrService.removeNode(this.repository(), this.workspace(), this.path(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addNode() {
        this.newNodeDialog.showModal();
    }

    public void renameNode() {
        this.renameNodeDialog.showModal();
    }

    public void updateMixinTypes() {
        this.jcrService.getMixinTypes(this.repository(), this.workspace(), false, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addMixin() {
        this.addMixinDialog.showModal();
    }

    public void addMixin(String name) {
        this.jcrService.addMixin(this.repository(), this.workspace(), this.path(), name, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void removeMixin() {
        this.removeMixinDialog.showModal();
    }

    public void removeMixin(String name) {
        this.jcrService.removeMixin(this.repository(), this.workspace(), this.path(), name, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updatePropertyDefs() {
        this.setPropertyDialog.updatePropertyDefs(this.node.getPropertyDefs());
    }

    public void setProperty() {
        this.setPropertyDialog.showModal();
    }

    protected void setNodeProperty(String name, String value) {
        this.jcrService.setProperty(this.repository(), this.workspace(), this.path(), name, value, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void addNode(String name, String primaryType) {
        this.jcrService.addNode(this.repository(), this.workspace(), this.path(), name, primaryType, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void renameNode(String name) {
        this.jcrService.renameNode(this.repository(), this.workspace(), this.path(), name, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updatePrimaryTypes() {
        this.jcrService.getPrimaryTypes(this.repository(), this.workspace(), true, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addAccessList() {
        this.addAccessListDialog.showModal();
    }

    public void addAccessList(String name) {
        Acl acl = this.node.getAcl();
        if (acl == null) {
            acl = new Acl();
            this.node.setAcl(acl);
        }
        Policy policy = new Policy();
        policy.setPrincipal(name);
        policy.add(JcrPermission.ALL);
        acl.addPolicy(policy);
        this.accessList.show(this.node);
        this.saveButton.enable();
    }

    public void updateAccessList(String principal, JcrPermission permission, boolean enabled) {
        this.jcrService.updateAccessList(this.repository, this.workspace(), this.path(), principal, permission, enabled, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void removeAccessList(String name) {
        this.node.getAccessList().remove(name);
        this.accessList.show(this.node);
    }

    public void applyAccessList() {
        this.jcrService.updateAccessList(this.repository(), this.workspace(), this.path(), this.node.getAccessList(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setNode(JcrNode node) {
        this.node = node;
        this.pathLabel.display(node.getPath());
    }

    public String repository() {
        return this.repository;
    }

    public String workspace() {
        return this.workspaces.getValueAsString();
    }

    public JcrNode node() {
        return this.node;
    }

    public String path() {
        return this.path == null ? "/" : this.path;
    }

    private String parent(String path) {
        if (path == null) {
            return "/";
        }
        if ((path = path.substring(0, path.lastIndexOf(47))).length() == 0) {
            return "/";
        }
        return path;
    }

    static /* synthetic */ Button access$000(Contents x0) {
        return x0.saveButton;
    }

    static /* synthetic */ ComboBoxItem access$100(Contents x0) {
        return x0.workspaces;
    }

    static /* synthetic */ Console access$200(Contents x0) {
        return x0.console;
    }

    static /* synthetic */ JcrNode access$302(Contents x0, JcrNode x1) {
        x0.node = x1;
        return x0.node;
    }

    static /* synthetic */ String access$402(Contents x0, String x1) {
        x0.path = x1;
        return x0.path;
    }

    static /* synthetic */ PathLabel access$500(Contents x0) {
        return x0.pathLabel;
    }

    static /* synthetic */ JcrNode access$300(Contents x0) {
        return x0.node;
    }

    static /* synthetic */ Children access$600(Contents x0) {
        return x0.children;
    }

    static /* synthetic */ Properties access$700(Contents x0) {
        return x0.properties;
    }

    static /* synthetic */ AccessList access$800(Contents x0) {
        return x0.accessList;
    }

    static /* synthetic */ AddMixinDialog access$900(Contents x0) {
        return x0.addMixinDialog;
    }

    static /* synthetic */ RemoveMixinDialog access$1000(Contents x0) {
        return x0.removeMixinDialog;
    }

    static /* synthetic */ NewNodeDialog access$1100(Contents x0) {
        return x0.newNodeDialog;
    }
}

