/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.shared;

import com.smartgwt.client.widgets.grid.ListGridRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.modeshape.web.shared.JcrPermission;
import org.modeshape.web.shared.JcrPolicy;

public class JcrAccessControlList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static JcrPermission[] PERMISSIONS = new JcrPermission[]{JcrPermission.ALL, JcrPermission.LIFECYCLE_MANAGEMENT, JcrPermission.LOCK_MANAGEMENT, JcrPermission.NODE_TYPE_MANAGEMENT, JcrPermission.RETENTION_MANAGEMENT, JcrPermission.VERSION_MANAGEMENT, JcrPermission.READ_ACCESS_CONTROL, JcrPermission.MODIFY_ACCESS_CONTROL, JcrPermission.READ, JcrPermission.WRITE, JcrPermission.ADD_CHILD_NODES, JcrPermission.MODIFY_PROPERTIES, JcrPermission.REMOVE_CHILD_NODES};
    private ArrayList<JcrPolicy> entries = new ArrayList();
    private boolean isModified = false;

    public static JcrAccessControlList defaultInstance() {
        return new JcrAccessControlList(new JcrPolicy[]{JcrPolicy.everyone()});
    }

    public JcrAccessControlList() {
    }

    public JcrAccessControlList(JcrPolicy ... policy) {
        this.entries.addAll(Arrays.asList(policy));
    }

    public void add(JcrPolicy entry) {
        this.entries.add(entry);
        this.isModified = true;
    }

    public void remove(JcrPolicy entry) {
        this.entries.remove(entry);
        this.isModified = true;
    }

    public void remove(String principal) {
        JcrPolicy policy = this.find(principal);
        if (policy != null) {
            this.entries.remove(policy);
            this.isModified = true;
        }
    }

    public Collection<JcrPolicy> entries() {
        return this.entries;
    }

    public JcrPolicy find(String principal) {
        for (JcrPolicy entry : this.entries) {
            if (!entry.getPrincipal().equals(principal)) continue;
            return entry;
        }
        return null;
    }

    public ListGridRecord[] test(String principal) {
        JcrPolicy entry = this.find(principal);
        ListGridRecord[] records = new ListGridRecord[PERMISSIONS.length];
        for (int i = 0; i < records.length; ++i) {
            String status = this.status(entry.getPermissions(), PERMISSIONS[i]);
            records[i] = new ListGridRecord();
            records[i].setAttribute("icon", "blue");
            records[i].setAttribute("permission", PERMISSIONS[i].getDisplayName());
            records[i].setAttribute("sign", status.toLowerCase());
            records[i].setAttribute("status", status);
        }
        return records;
    }

    private String status(Collection<JcrPermission> list, JcrPermission value) {
        for (JcrPermission p : list) {
            if (!p.matches(value)) continue;
            return "Allow";
        }
        return "Deny";
    }

    public void modify(String principal, String action, String value) {
        JcrPolicy entry = this.find(principal);
        entry.update(action, value);
        this.isModified = true;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void cleanModificationFlag() {
        this.isModified = false;
    }
}

