/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.xml.ModeShapeDtdLexicon;
import org.modeshape.sequencer.xml.ModeShapeXmlLexicon;
import org.modeshape.sequencer.xml.XmlSequencer;
import org.modeshape.sequencer.xml.XmlSequencerI18n;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class XmlSequencerHandler
extends DefaultHandler2 {
    private final SequencerOutput output;
    private final StreamSequencerContext context;
    public static TextDecoder DEFAULT_DECODER = new XmlNameEncoder();
    public static XmlSequencer.AttributeScoping DEFAULT_ATTRIBUTE_SCOPING = XmlSequencer.AttributeScoping.USE_DEFAULT_NAMESPACE;
    protected final Name nameAttribute;
    protected final Name defaultPrimaryType;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final PropertyFactory propertyFactory;
    protected final NamespaceRegistry namespaceRegistry;
    protected final TextDecoder decoder;
    private final Map<String, LinkedList<String>> prefixStackByUri = new HashMap<String, LinkedList<String>>();
    private final XmlSequencer.AttributeScoping attributeScoping;
    protected Path currentPath;
    private Map<Name, List<IndexedName>> nameToIndexedNamesMap = new HashMap<Name, List<IndexedName>>();
    private final LinkedList<Map<Name, List<IndexedName>>> nameToIndexedNamesMapStack = new LinkedList();
    private String currentEntityName;
    private StringBuilder cDataContent;
    private StringBuilder contentBuilder;
    private final Problems problems;
    private final Map<String, String> entityValues = new HashMap<String, String>();

    XmlSequencerHandler(SequencerOutput output, StreamSequencerContext context, Name nameAttribute, Name defaultPrimaryType, TextDecoder textDecoder, XmlSequencer.AttributeScoping scoping) {
        CheckArg.isNotNull((Object)output, (String)"output");
        CheckArg.isNotNull((Object)context, (String)"context");
        this.output = output;
        this.context = context;
        this.problems = context.getProblems();
        assert (this.problems != null);
        this.nameAttribute = nameAttribute;
        this.defaultPrimaryType = defaultPrimaryType;
        this.decoder = textDecoder != null ? textDecoder : DEFAULT_DECODER;
        this.attributeScoping = scoping != null ? scoping : DEFAULT_ATTRIBUTE_SCOPING;
        LocalNamespaceRegistry namespaceRegistry = new LocalNamespaceRegistry(this.context.getNamespaceRegistry());
        ExecutionContext localContext = this.context.with((NamespaceRegistry)namespaceRegistry);
        this.nameFactory = localContext.getValueFactories().getNameFactory();
        this.pathFactory = localContext.getValueFactories().getPathFactory();
        this.propertyFactory = localContext.getPropertyFactory();
        this.namespaceRegistry = localContext.getNamespaceRegistry();
        assert (this.nameFactory != null);
        assert (this.pathFactory != null);
        assert (this.propertyFactory != null);
        assert (this.namespaceRegistry != null);
        this.currentPath = this.pathFactory.createRelativePath();
        assert (this.currentPath != null);
    }

    private void startNode(Name name) {
        List<IndexedName> indexedNames;
        if (this.contentBuilder != null) {
            this.endContent();
        }
        if ((indexedNames = this.nameToIndexedNamesMap.get(name)) == null) {
            indexedNames = new ArrayList<IndexedName>();
            this.nameToIndexedNamesMap.put(name, indexedNames);
        }
        IndexedName indexedName = new IndexedName();
        indexedNames.add(indexedName);
        this.currentPath = this.pathFactory.create(this.currentPath, name, indexedNames.size()).getNormalizedPath();
        this.nameToIndexedNamesMapStack.addFirst(this.nameToIndexedNamesMap);
        this.nameToIndexedNamesMap = indexedName.nameToIndexedNamesMap;
    }

    private void endNode() {
        this.currentPath = this.currentPath.getParent();
        this.currentPath = this.currentPath.getNormalizedPath();
        this.nameToIndexedNamesMap.clear();
        this.nameToIndexedNamesMap = this.nameToIndexedNamesMapStack.removeFirst();
    }

    protected void endContent() {
        String content = StringUtil.normalize((String)this.contentBuilder.toString());
        this.contentBuilder = null;
        if (content.length() > 0) {
            this.startNode(ModeShapeXmlLexicon.ELEMENT_CONTENT);
            this.output.setProperty(this.currentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeXmlLexicon.ELEMENT_CONTENT});
            this.output.setProperty(this.currentPath, ModeShapeXmlLexicon.ELEMENT_CONTENT, new Object[]{content});
            this.endNode();
        }
    }

    public void startDocument() {
        this.output.setProperty(this.currentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeXmlLexicon.DOCUMENT});
    }

    public void startDTD(String name, String publicId, String systemId) {
        this.output.setProperty(this.currentPath, ModeShapeDtdLexicon.NAME, new Object[]{name});
        this.output.setProperty(this.currentPath, ModeShapeDtdLexicon.PUBLIC_ID, new Object[]{publicId});
        this.output.setProperty(this.currentPath, ModeShapeDtdLexicon.SYSTEM_ID, new Object[]{systemId});
    }

    public void externalEntityDecl(String name, String publicId, String systemId) {
        this.startNode(ModeShapeDtdLexicon.ENTITY);
        this.output.setProperty(this.currentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeDtdLexicon.ENTITY});
        this.output.setProperty(this.currentPath, ModeShapeDtdLexicon.NAME, new Object[]{name});
        if (publicId != null) {
            this.output.setProperty(this.currentPath, ModeShapeDtdLexicon.PUBLIC_ID, new Object[]{publicId});
        }
        if (systemId != null) {
            this.output.setProperty(this.currentPath, ModeShapeDtdLexicon.SYSTEM_ID, new Object[]{systemId});
        }
        this.endNode();
    }

    public void internalEntityDecl(String name, String value) {
        this.startNode(ModeShapeDtdLexicon.ENTITY);
        this.output.setProperty(this.currentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeDtdLexicon.ENTITY});
        this.output.setProperty(this.currentPath, ModeShapeDtdLexicon.NAME, new Object[]{name});
        this.output.setProperty(this.currentPath, ModeShapeDtdLexicon.VALUE, new Object[]{value});
        this.entityValues.put(name, value);
        this.endNode();
    }

    public void processingInstruction(String target, String data) {
        this.startNode(ModeShapeXmlLexicon.PROCESSING_INSTRUCTION);
        this.output.setProperty(this.currentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeXmlLexicon.PROCESSING_INSTRUCTION});
        this.output.setProperty(this.currentPath, ModeShapeXmlLexicon.TARGET, new Object[]{target.trim()});
        if (data != null) {
            this.output.setProperty(this.currentPath, ModeShapeXmlLexicon.PROCESSING_INSTRUCTION_CONTENT, new Object[]{data.trim()});
        }
        this.endNode();
    }

    public void startPrefixMapping(String prefix, String uri) {
        assert (uri != null);
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        if (prefixStack == null) {
            prefixStack = new LinkedList();
            this.prefixStackByUri.put(uri, prefixStack);
        }
        prefixStack.addFirst(prefix);
        if (!this.namespaceRegistry.isRegisteredNamespaceUri(uri)) {
            NamespaceRegistry contextRegistry = this.context.getNamespaceRegistry();
            if (contextRegistry.getNamespaceForPrefix(prefix) != null) {
                this.context.getNamespaceRegistry().getPrefixForNamespaceUri(uri, true);
                this.namespaceRegistry.register(prefix, uri);
            } else {
                this.context.getNamespaceRegistry().register(prefix, uri);
            }
        } else {
            this.namespaceRegistry.register(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) {
        assert (prefix != null);
        String uri = this.namespaceRegistry.getNamespaceForPrefix(prefix);
        assert (uri != null);
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        assert (prefixStack != null);
        assert (!prefixStack.isEmpty());
        String existingPrefix = prefixStack.removeFirst();
        assert (prefix.equals(existingPrefix));
        if (prefixStack.isEmpty()) {
            this.namespaceRegistry.unregister(uri);
            this.prefixStackByUri.remove(uri);
        } else {
            String previous = prefixStack.getFirst();
            this.namespaceRegistry.register(previous, uri);
        }
    }

    public void startEntity(String name) {
        this.currentEntityName = name;
    }

    public void endEntity(String name) {
    }

    public void startCDATA() {
        if (this.contentBuilder != null) {
            this.endContent();
        }
        this.cDataContent = new StringBuilder();
    }

    public void endCDATA() {
        this.startNode(ModeShapeXmlLexicon.CDATA);
        this.output.setProperty(this.currentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{this.defaultPrimaryType});
        this.output.setProperty(this.currentPath, ModeShapeXmlLexicon.CDATA_CONTENT, new Object[]{this.cDataContent.toString()});
        this.endNode();
        this.cDataContent = null;
    }

    public void characters(char[] ch, int start, int length) {
        String content = String.valueOf(ch, start, length);
        if (this.cDataContent != null) {
            this.cDataContent.append(ch, start, length);
        } else {
            if (this.contentBuilder == null) {
                this.contentBuilder = new StringBuilder();
            }
            if (this.currentEntityName != null) {
                this.contentBuilder.append('&').append(this.currentEntityName).append(';');
                String entityValue = this.entityValues.get(this.currentEntityName);
                if (!content.equals(entityValue) && entityValue != null && entityValue.length() < content.length()) {
                    String extraContent = content.substring(entityValue.length());
                    this.contentBuilder.append(extraContent);
                }
                this.currentEntityName = null;
            } else {
                this.contentBuilder.append(content);
            }
        }
    }

    public void comment(char[] ch, int start, int length) {
        this.startNode(ModeShapeXmlLexicon.COMMENT);
        this.output.setProperty(this.currentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeXmlLexicon.COMMENT});
        this.output.setProperty(this.currentPath, ModeShapeXmlLexicon.COMMENT_CONTENT, new Object[]{String.valueOf(ch, start, length).trim()});
        this.endNode();
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) {
        assert (localName != null);
        Name nodeName = null;
        if (this.nameAttribute != null) {
            try {
                String jcrNameValue = attributes.getValue(this.nameAttribute.getNamespaceUri(), this.nameAttribute.getLocalName());
                nodeName = (Name)this.nameFactory.create(jcrNameValue);
            }
            catch (ValueFormatException e) {
                // empty catch block
            }
        }
        if (nodeName == null) {
            nodeName = this.nameFactory.create(uri, localName, this.decoder);
        }
        this.startNode(nodeName);
        if (this.defaultPrimaryType != null) {
            this.output.setProperty(this.currentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{this.defaultPrimaryType});
        }
        int len = attributes.getLength();
        for (int i = 0; i != len; ++i) {
            String attributeLocalName = attributes.getLocalName(i);
            String attributeUri = attributes.getURI(i);
            Name attributeName = null;
            if ((attributeUri == null || attributeUri.length() == 0) && attributes.getQName(i).indexOf(58) == -1) {
                switch (this.attributeScoping) {
                    case INHERIT_ELEMENT_NAMESPACE: {
                        attributeName = this.nameFactory.create(uri, attributeLocalName, this.decoder);
                        break;
                    }
                    case USE_DEFAULT_NAMESPACE: {
                        attributeName = (Name)this.nameFactory.create(attributeLocalName, this.decoder);
                    }
                }
            } else {
                attributeName = this.nameFactory.create(attributeUri, attributeLocalName, this.decoder);
            }
            assert (attributeName != null);
            if (JcrLexicon.NAME.equals(attributeName)) continue;
            Object value = attributes.getValue(i);
            if (JcrLexicon.PRIMARY_TYPE.equals(attributeName)) {
                value = this.nameFactory.create(value);
            }
            this.output.setProperty(this.currentPath, attributeName, new Object[]{attributes.getValue(i)});
        }
    }

    public void endElement(String uri, String localName, String name) {
        if (this.contentBuilder != null) {
            this.endContent();
        }
        this.endNode();
    }

    public void warning(SAXParseException warning) {
        this.problems.addWarning((Throwable)warning, XmlSequencerI18n.warningSequencingXmlDocument, new Object[]{warning});
    }

    public void error(SAXParseException error) {
        this.problems.addError((Throwable)error, XmlSequencerI18n.errorSequencingXmlDocument, new Object[]{error});
    }

    public void fatalError(SAXParseException error) {
        this.problems.addError((Throwable)error, XmlSequencerI18n.errorSequencingXmlDocument, new Object[]{error});
    }

    private class IndexedName {
        Map<Name, List<IndexedName>> nameToIndexedNamesMap = new HashMap<Name, List<IndexedName>>();

        IndexedName() {
        }
    }
}

