/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.io.InputStream;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.wsdl.Wsdl11Reader;
import org.modeshape.sequencer.wsdl.WsdlReader;

public class WsdlSequencer
implements StreamSequencer {
    protected static final boolean TRACE = true;
    private String[] localPathsToCachedSchemas;

    public String[] getLocalPathsToCachedSchemas() {
        return this.localPathsToCachedSchemas;
    }

    public void setLocalPathsToCachedSchemas(String[] localPathsToCachedSchemas) {
        this.localPathsToCachedSchemas = localPathsToCachedSchemas != null && localPathsToCachedSchemas.length != 0 ? localPathsToCachedSchemas : null;
    }

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        assert (stream != null);
        assert (output != null);
        assert (context != null);
        Path pathToArchiveFile = context.getInputPath();
        Name xsdName = null;
        if (pathToArchiveFile != null && !pathToArchiveFile.isRoot()) {
            if (pathToArchiveFile.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
                pathToArchiveFile = pathToArchiveFile.getParent();
            }
            if (!pathToArchiveFile.isRoot()) {
                xsdName = pathToArchiveFile.getLastSegment().getName();
            }
        }
        assert (xsdName != null);
        Path docPath = context.getValueFactories().getPathFactory().createRelativePath(new Name[]{xsdName});
        this.newReader(output, context).read(stream, docPath);
    }

    protected WsdlReader<?> newReader(SequencerOutput output, StreamSequencerContext context) {
        return new Wsdl11Reader(output, context);
    }
}

