/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.odf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.odf.OdfMetadata;

public class OdfMetadataSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("odf.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(OdfMetadata.MIME_TYPE_STRINGS);
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = (Binary)inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        String mimeType = binaryValue.getMimeType();
        Node sequencedNode = this.getMetadataNode(outputNode);
        this.setPropertyIfMetadataPresent(sequencedNode, "jcr:mimeType", mimeType);
        return this.processBasicMetadata(sequencedNode, binaryValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processBasicMetadata(Node sequencedNode, Binary binaryValue) {
        OdfMetadata metadata = null;
        try (InputStream stream = binaryValue.getStream();){
            metadata = new OdfMetadata(stream);
            if (!metadata.check()) return false;
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:pages", metadata.getPages());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:sheets", metadata.getSheets());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:creationDate", metadata.getCreationDate());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:creator", metadata.getCreator());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:description", metadata.getDescription());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:editingCycles", metadata.getEditingCycles());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:editingTime", metadata.getEditingTime());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:generator", metadata.getGenerator());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:initialCreator", metadata.getInitialCreator());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:keywords", metadata.getKeywords());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:language", metadata.getLanguage());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:modificationDate", metadata.getModificationDate());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:printedBy", metadata.getPrintedBy());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:printDate", metadata.getPrintDate());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:subject", metadata.getSubject());
            this.setPropertyIfMetadataPresent(sequencedNode, "odf:title", metadata.getTitle());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e, "Couldn't process stream.", new Object[0]);
        }
        return false;
    }

    private Node getMetadataNode(Node outputNode) throws RepositoryException {
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("odf:metadata");
            return outputNode;
        }
        return outputNode.addNode("odf:metadata", "odf:metadata");
    }

    private void setPropertyIfMetadataPresent(Node node, String propertyName, Object value) throws RepositoryException {
        if (value != null) {
            if (value instanceof String && !StringUtil.isBlank((String)((String)value))) {
                node.setProperty(propertyName, (String)value);
            } else if (value instanceof Boolean) {
                node.setProperty(propertyName, ((Boolean)value).booleanValue());
            } else if (value instanceof Long) {
                node.setProperty(propertyName, ((Long)value).longValue());
            } else if (value instanceof Integer) {
                node.setProperty(propertyName, new Long(((Integer)value).intValue()).longValue());
            } else if (value instanceof Calendar) {
                node.setProperty(propertyName, (Calendar)value);
            } else if (value instanceof byte[]) {
                ByteArrayInputStream is = new ByteArrayInputStream((byte[])value);
                javax.jcr.Binary binaryProperty = node.getSession().getValueFactory().createBinary((InputStream)is);
                node.setProperty(propertyName, binaryProperty);
            } else if (value instanceof List) {
                ValueFactory vf = node.getSession().getValueFactory();
                List<Value> values = ((List)value).stream().filter(val -> val instanceof String).map(val -> vf.createValue((String)val)).collect(Collectors.toList());
                if (!values.isEmpty()) {
                    node.setProperty(propertyName, values.toArray(new Value[values.size()]));
                }
            } else {
                this.getLogger().warn("The value of the property {0} has unknown type and couldn't be saved.", new Object[]{propertyName});
            }
        }
    }
}

