/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.LinkedList;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.ChildNodeJoinCondition;
import org.modeshape.jcr.query.model.DescendantNodeJoinCondition;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;

public class JoinOrder
implements OptimizerRule {
    public static final JoinOrder INSTANCE = new JoinOrder();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode join : plan.findAllAtOrBelow(PlanNode.Type.JOIN)) {
            JoinCondition condition;
            boolean swapChildren = false;
            javax.jcr.query.qom.JoinCondition joinCondition = join.getProperty(PlanNode.Property.JOIN_CONDITION, javax.jcr.query.qom.JoinCondition.class);
            if (joinCondition instanceof DescendantNodeJoinCondition) {
                condition = (DescendantNodeJoinCondition)joinCondition;
                SelectorName ancestorSelector = ((DescendantNodeJoinCondition)condition).ancestorSelectorName();
                swapChildren = !join.getFirstChild().getSelectors().contains(ancestorSelector);
            } else if (joinCondition instanceof ChildNodeJoinCondition) {
                condition = (ChildNodeJoinCondition)joinCondition;
                SelectorName parentSelector = ((ChildNodeJoinCondition)condition).parentSelectorName();
                swapChildren = !join.getFirstChild().getSelectors().contains(parentSelector);
            }
            JoinType joinType = join.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class);
            if (!swapChildren) continue;
            PlanNode first = join.getFirstChild();
            first.removeFromParent();
            join.addLastChild(first);
            if (joinType == JoinType.LEFT_OUTER) {
                join.setProperty(PlanNode.Property.JOIN_TYPE, JoinType.RIGHT_OUTER);
                continue;
            }
            if (joinType != JoinType.RIGHT_OUTER) continue;
            join.setProperty(PlanNode.Property.JOIN_TYPE, JoinType.LEFT_OUTER);
        }
        return plan;
    }
}

