/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShape;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.Upgrades;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.change.RepositoryMetadataChanged;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.cache.document.DocumentOptimizer;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.LocalDocumentStore;
import org.modeshape.jcr.cache.document.ReadOnlySessionCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.cache.document.WritableSessionCache;
import org.modeshape.jcr.clustering.ClusteringService;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.StringFactory;

public class RepositoryCache {
    private static final Logger LOGGER = Logger.getLogger(RepositoryCache.class);
    private static final String SYSTEM_METADATA_IDENTIFIER = "jcr:system/mode:metadata";
    private static final String REPOSITORY_INFO_KEY = "repository:info";
    private static final String REPOSITORY_NAME_FIELD_NAME = "repositoryName";
    private static final String REPOSITORY_KEY_FIELD_NAME = "repositoryKey";
    private static final String REPOSITORY_SOURCE_NAME_FIELD_NAME = "sourceName";
    private static final String REPOSITORY_SOURCE_KEY_FIELD_NAME = "sourceKey";
    private static final String REPOSITORY_CREATED_AT_FIELD_NAME = "createdAt";
    private static final String REPOSITORY_INITIALIZED_AT_FIELD_NAME = "intializedAt";
    private static final String REPOSITORY_INITIALIZER_FIELD_NAME = "intializer";
    private static final String REPOSITORY_CREATED_WITH_MODESHAPE_VERSION_FIELD_NAME = "createdWithModeShapeVersion";
    private static final String REPOSITORY_UPGRADE_ID_FIELD_NAME = "lastUpgradeId";
    private static final String REPOSITORY_UPGRADED_AT_FIELD_NAME = "lastUpgradedAt";
    private static final String REPOSITORY_UPGRADER_FIELD_NAME = "upgrader";
    private final ExecutionContext context;
    private final RepositoryConfiguration configuration;
    private final DocumentStore documentStore;
    private final DocumentTranslator translator;
    private final ConcurrentHashMap<String, WorkspaceCache> workspaceCachesByName;
    private final AtomicLong minimumStringLengthForBinaryStorage = new AtomicLong();
    private final AtomicBoolean accessControlEnabled = new AtomicBoolean(false);
    private final String name;
    private final String repoKey;
    private final String sourceKey;
    private final String rootNodeId;
    protected final ChangeBus changeBus;
    protected final NodeKey systemMetadataKey;
    private final NodeKey systemKey;
    protected final Set<String> workspaceNames;
    protected final String systemWorkspaceName;
    protected final Logger logger;
    private final SessionEnvironment sessionContext;
    private final String processKey;
    private final CacheContainer workspaceCacheManager;
    protected final Upgrades upgrades;
    private volatile boolean initializingRepository = false;
    private volatile boolean upgradingRepository = false;
    private int lastUpgradeId;
    private final ClusteringService clusteringService;
    private volatile boolean isHoldingClusterLock = false;
    private final RepositoryFeaturesDetector repositoryFeaturesDetector;
    public static final ContentInitializer NO_OP_INITIALIZER = new ContentInitializer(){

        @Override
        public void initialize(SessionCache session, MutableCachedNode parent) {
        }
    };

    public RepositoryCache(ExecutionContext context, DocumentStore documentStore, ClusteringService clusteringService, RepositoryConfiguration configuration, ContentInitializer initializer, SessionEnvironment sessionContext, ChangeBus changeBus, CacheContainer workspaceCacheContainer, Upgrades upgradeFunctions) {
        this.context = context;
        this.configuration = configuration;
        this.documentStore = documentStore;
        this.clusteringService = clusteringService;
        this.minimumStringLengthForBinaryStorage.set(configuration.getBinaryStorage().getMinimumStringSize());
        this.translator = new DocumentTranslator(this.context, this.documentStore, this.minimumStringLengthForBinaryStorage.get());
        this.sessionContext = sessionContext;
        this.processKey = context.getProcessId();
        this.workspaceCacheManager = workspaceCacheContainer;
        this.logger = Logger.getLogger(this.getClass());
        this.rootNodeId = "/";
        this.name = configuration.getName();
        this.workspaceCachesByName = new ConcurrentHashMap();
        this.workspaceNames = new CopyOnWriteArraySet<String>(configuration.getAllWorkspaceNames());
        this.upgrades = upgradeFunctions;
        if (clusteringService != null) {
            int minutesToWait = 10;
            LOGGER.debug("Waiting at most for {0} minutes while verifying the status of the '{1}' repository", new Object[]{minutesToWait, this.name});
            if (!clusteringService.tryLock(minutesToWait, TimeUnit.MINUTES)) {
                throw new SystemFailureException(JcrI18n.repositoryWasNeverInitializedAfterMinutes.text(new Object[]{this.name, minutesToWait}));
            }
            LOGGER.debug("Repository '{0}' acquired clustered-wide lock for performing initialization or verifying status", new Object[]{this.name});
            this.isHoldingClusterLock = true;
        }
        SchematicEntry repositoryInfo = this.documentStore.localStore().get(REPOSITORY_INFO_KEY);
        boolean upgradeRequired = false;
        if (repositoryInfo == null) {
            String initializerId = UUID.randomUUID().toString();
            this.repoKey = NodeKey.keyForSourceName(this.name);
            this.sourceKey = NodeKey.keyForSourceName(configuration.getStoreName());
            DateTime now = context.getValueFactories().getDateFactory().create();
            EditableDocument doc = Schematic.newDocument();
            doc.setString(REPOSITORY_NAME_FIELD_NAME, this.name);
            doc.setString(REPOSITORY_KEY_FIELD_NAME, this.repoKey);
            doc.setString(REPOSITORY_SOURCE_NAME_FIELD_NAME, configuration.getStoreName());
            doc.setString(REPOSITORY_SOURCE_KEY_FIELD_NAME, this.sourceKey);
            doc.setDate(REPOSITORY_CREATED_AT_FIELD_NAME, now.toDate());
            doc.setString(REPOSITORY_INITIALIZER_FIELD_NAME, initializerId);
            doc.setString(REPOSITORY_CREATED_WITH_MODESHAPE_VERSION_FIELD_NAME, ModeShape.getVersion());
            doc.setNumber(REPOSITORY_UPGRADE_ID_FIELD_NAME, this.upgrades.getLatestAvailableUpgradeId());
            if (this.documentStore.localStore().putIfAbsent(REPOSITORY_INFO_KEY, (Document)doc) != null) {
                throw new SystemFailureException(JcrI18n.repositoryWasInitializedByOtherProcess.text(new Object[]{this.name}));
            }
            repositoryInfo = this.documentStore.get(REPOSITORY_INFO_KEY);
            this.initializingRepository = true;
            LOGGER.debug("Initializing the '{0}' repository", new Object[]{this.name});
        } else {
            Document info = repositoryInfo.getContent();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Repository '{0}' already initialized at '{1}'", new Object[]{this.name, info.get(REPOSITORY_INITIALIZED_AT_FIELD_NAME)});
            }
            String repoName = info.getString(REPOSITORY_NAME_FIELD_NAME, this.name);
            String sourceName = info.getString(REPOSITORY_SOURCE_NAME_FIELD_NAME, configuration.getStoreName());
            this.repoKey = info.getString(REPOSITORY_KEY_FIELD_NAME, NodeKey.keyForSourceName(repoName));
            this.sourceKey = info.getString(REPOSITORY_SOURCE_KEY_FIELD_NAME, NodeKey.keyForSourceName(sourceName));
            this.lastUpgradeId = info.getInteger(REPOSITORY_UPGRADE_ID_FIELD_NAME, 0);
            upgradeRequired = this.upgrades.isUpgradeRequired(this.lastUpgradeId);
            if (upgradeRequired && info.getString(REPOSITORY_UPGRADER_FIELD_NAME) == null) {
                int nextId = this.upgrades.getLatestAvailableUpgradeId();
                LOGGER.debug("The content in repository '{0}' needs to be upgraded (steps {1}->{2})", new Object[]{this.name, this.lastUpgradeId, nextId});
                this.upgradingRepository = this.runInTransaction(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int lastUpgradeId;
                        LocalDocumentStore store = RepositoryCache.this.documentStore().localStore();
                        store.prepareDocumentsForUpdate(Collections.unmodifiableSet((Object[])new String[]{RepositoryCache.REPOSITORY_INFO_KEY}));
                        EditableDocument editor = store.edit(RepositoryCache.REPOSITORY_INFO_KEY, true);
                        if (editor.get(RepositoryCache.REPOSITORY_UPGRADER_FIELD_NAME) == null && RepositoryCache.this.upgrades.isUpgradeRequired(lastUpgradeId = editor.getInteger(RepositoryCache.REPOSITORY_UPGRADE_ID_FIELD_NAME, 0))) {
                            String upgraderId = UUID.randomUUID().toString();
                            editor.setString(RepositoryCache.REPOSITORY_UPGRADER_FIELD_NAME, upgraderId);
                            return true;
                        }
                        return false;
                    }
                });
                if (this.upgradingRepository) {
                    LOGGER.debug("This process will upgrade the content in repository '{0}'", new Object[]{this.name});
                } else {
                    LOGGER.debug("The content in repository '{0}' does not need to be upgraded", new Object[]{this.name});
                }
            }
        }
        if (upgradeRequired && !this.upgradingRepository) {
            LOGGER.debug("Waiting at most for 10 minutes for another process in the cluster to upgrade the content in existing repository '{0}'", new Object[]{this.name});
            this.waitUntil(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    Document info = RepositoryCache.this.documentStore().localStore().get(RepositoryCache.REPOSITORY_INFO_KEY).getContent();
                    int lastUpgradeId = info.getInteger(RepositoryCache.REPOSITORY_UPGRADE_ID_FIELD_NAME, 0);
                    return !RepositoryCache.this.upgrades.isUpgradeRequired(lastUpgradeId);
                }
            }, 10L, TimeUnit.MINUTES, JcrI18n.repositoryWasNeverUpgradedAfterMinutes);
            LOGGER.debug("Content in existing repository '{0}' has been fully upgraded", new Object[]{this.name});
        } else if (!this.initializingRepository) {
            LOGGER.debug("Content in existing repository '{0}' does not need to be upgraded", new Object[]{this.name});
        }
        this.systemWorkspaceName = "system";
        String systemWorkspaceKey = NodeKey.keyForWorkspaceName(this.systemWorkspaceName);
        this.systemMetadataKey = new NodeKey(this.sourceKey, systemWorkspaceKey, SYSTEM_METADATA_IDENTIFIER);
        this.refreshRepositoryMetadata(false);
        this.changeBus = changeBus;
        this.changeBus.registerInThread(new ChangesToWorkspacesListener());
        SessionCache systemSession = this.createSession(context, this.systemWorkspaceName, false);
        NodeKey systemRootKey = systemSession.getRootKey();
        CachedNode systemRoot = systemSession.getNode(systemRootKey);
        this.logger.debug("System root: {0}", new Object[]{systemRoot});
        ChildReference systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        this.logger.debug("jcr:system child reference: {0}", new Object[]{systemRef});
        CachedNode systemNode = systemRef != null ? systemSession.getNode(systemRef) : null;
        this.logger.debug("System node: {0}", new Object[]{systemNode});
        if (systemRef == null || systemNode == null) {
            this.logger.debug("Creating the '{0}' workspace in repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
            MutableCachedNode root = systemSession.mutable(systemRootKey);
            if (initializer == null) {
                initializer = NO_OP_INITIALIZER;
            }
            initializer.initialize(systemSession, root);
            systemSession.save();
            this.refreshWorkspace(this.systemWorkspaceName);
            systemSession = this.createSession(context, this.systemWorkspaceName, false);
            systemRoot = systemSession.getNode(systemRootKey);
            systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
            if (systemRef == null) {
                throw new SystemFailureException(JcrI18n.unableToInitializeSystemWorkspace.text(new Object[]{this.name}));
            }
        } else {
            this.logger.debug("Found existing '{0}' workspace in repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
        }
        this.systemKey = systemRef.getKey();
        this.documentStore.setLocalSourceKey(this.sourceKey);
        this.repositoryFeaturesDetector = new RepositoryFeaturesDetector(systemSession, systemRef.getKey());
    }

    protected boolean waitUntil(Callable<Boolean> condition, long time, TimeUnit unit, I18n failureMsg) {
        long startTime = System.currentTimeMillis();
        long quitTime = startTime + TimeUnit.MILLISECONDS.convert(time, unit);
        Exception lastError = null;
        while (System.currentTimeMillis() < quitTime) {
            try {
                lastError = null;
                if (condition.call().booleanValue()) {
                    return true;
                }
            }
            catch (Exception e) {
                lastError = e;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
        LOGGER.error((Throwable)lastError, (I18nResource)failureMsg, new Object[]{this.name, time});
        String msg = failureMsg.text(new Object[]{this.name, time});
        throw new SystemFailureException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollbackRepositoryInfo() {
        block4: {
            try {
                Document repoInfoDoc;
                SchematicEntry repositoryInfoEntry = this.documentStore.localStore().get(REPOSITORY_INFO_KEY);
                if (repositoryInfoEntry != null && !(repoInfoDoc = repositoryInfoEntry.getContent()).containsField(REPOSITORY_INITIALIZED_AT_FIELD_NAME)) {
                    this.documentStore.localStore().remove(REPOSITORY_INFO_KEY);
                }
                if (!this.isHoldingClusterLock) break block4;
                this.clusteringService.unlock();
            }
            catch (Throwable throwable) {
                if (this.isHoldingClusterLock) {
                    this.clusteringService.unlock();
                    LOGGER.debug("Repository '{0}' released clustered-wide lock after failing to start up ", new Object[]{this.name});
                }
                throw throwable;
            }
            LOGGER.debug("Repository '{0}' released clustered-wide lock after failing to start up ", new Object[]{this.name});
        }
    }

    public final boolean versioningUsed() {
        return this.repositoryFeaturesDetector.versioningUsed();
    }

    public final boolean lockingUsed() {
        return this.repositoryFeaturesDetector.lockingUsed();
    }

    public final ChangeBus changeBus() {
        return this.changeBus;
    }

    protected final SessionEnvironment sessionContext() {
        return this.sessionContext;
    }

    protected final String processKey() {
        return this.processKey;
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public final boolean isInitializingRepository() {
        return this.initializingRepository;
    }

    public final boolean isAccessControlEnabled() {
        return this.accessControlEnabled.get();
    }

    public final void setAccessControlEnabled(boolean enabled) {
        if (this.accessControlEnabled.compareAndSet(!enabled, enabled)) {
            this.refreshRepositoryMetadata(true);
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.context.getProcessId(), this.getKey(), null, this.sessionContext.journalId());
            changes.repositoryMetadataChanged();
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
        }
    }

    protected final DocumentStore documentStore() {
        return this.documentStore;
    }

    protected final ExecutionContext context() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryCache completeInitialization() {
        RepositoryCache repositoryCache;
        block4: {
            try {
                if (this.initializingRepository) {
                    LOGGER.debug("Marking repository '{0}' as fully initialized", new Object[]{this.name});
                    this.runInTransaction(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            LocalDocumentStore store = RepositoryCache.this.documentStore().localStore();
                            store.prepareDocumentsForUpdate(Collections.unmodifiableSet((Object[])new String[]{RepositoryCache.REPOSITORY_INFO_KEY}));
                            EditableDocument editor = store.edit(RepositoryCache.REPOSITORY_INFO_KEY, true);
                            if (editor.get(RepositoryCache.REPOSITORY_INITIALIZED_AT_FIELD_NAME) == null) {
                                DateTime now = RepositoryCache.this.context().getValueFactories().getDateFactory().create();
                                editor.setDate(RepositoryCache.REPOSITORY_INITIALIZED_AT_FIELD_NAME, now.toDate());
                            }
                            return null;
                        }
                    });
                    LOGGER.debug("Repository '{0}' is fully initialized", new Object[]{this.name});
                }
                repositoryCache = this;
                if (!this.isHoldingClusterLock) break block4;
                this.clusteringService.unlock();
            }
            catch (Throwable throwable) {
                if (this.isHoldingClusterLock) {
                    this.clusteringService.unlock();
                    LOGGER.debug("Repository '{0}' released clustered-wide lock after successful startup", new Object[]{this.name});
                }
                throw throwable;
            }
            LOGGER.debug("Repository '{0}' released clustered-wide lock after successful startup", new Object[]{this.name});
        }
        return repositoryCache;
    }

    public RepositoryCache completeUpgrade(final Upgrades.Context resources) {
        if (this.upgradingRepository) {
            try {
                this.runInTransaction(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        LOGGER.debug("Upgrading repository '{0}'", new Object[]{RepositoryCache.this.name});
                        RepositoryCache.this.lastUpgradeId = RepositoryCache.this.upgrades.applyUpgradesSince(RepositoryCache.this.lastUpgradeId, resources);
                        LOGGER.debug("Recording upgrade completion in repository '{0}'", new Object[]{RepositoryCache.this.name});
                        LocalDocumentStore store = RepositoryCache.this.documentStore().localStore();
                        store.prepareDocumentsForUpdate(Collections.unmodifiableSet((Object[])new String[]{RepositoryCache.REPOSITORY_INFO_KEY}));
                        EditableDocument editor = store.edit(RepositoryCache.REPOSITORY_INFO_KEY, true);
                        DateTime now = RepositoryCache.this.context().getValueFactories().getDateFactory().create();
                        editor.setDate(RepositoryCache.REPOSITORY_UPGRADED_AT_FIELD_NAME, now.toDate());
                        editor.setNumber(RepositoryCache.REPOSITORY_UPGRADE_ID_FIELD_NAME, RepositoryCache.this.lastUpgradeId);
                        editor.remove(RepositoryCache.REPOSITORY_UPGRADER_FIELD_NAME);
                        return null;
                    }
                });
                LOGGER.debug("Repository '{0}' is fully upgraded", new Object[]{this.name});
            }
            catch (Throwable err) {
                this.logger.error(err, (I18nResource)JcrI18n.failureDuringUpgradeOperation, new Object[]{this.getName(), err});
                resources.getProblems().addError(err, JcrI18n.failureDuringUpgradeOperation, new Object[]{this.getName(), err});
            }
        }
        return this;
    }

    private <V> V runInTransaction(Callable<V> operation) {
        Transactions txns = this.sessionContext.getTransactions();
        try {
            Transactions.Transaction txn = txns.begin();
            try {
                V result = operation.call();
                txn.commit();
                return result;
            }
            catch (Exception e) {
                txn.rollback();
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }
        catch (IllegalStateException | SystemException err) {
            throw new SystemFailureException(err);
        }
        catch (NotSupportedException e) {
            this.logger.debug((Throwable)e, "nested transactions not supported", new Object[0]);
            return null;
        }
    }

    public void startShutdown() {
        for (Map.Entry<String, WorkspaceCache> entry : this.workspaceCachesByName.entrySet()) {
            entry.getValue().signalClosing();
        }
    }

    public void completeShutdown() {
        for (Map.Entry<String, WorkspaceCache> entry : this.workspaceCachesByName.entrySet()) {
            EmbeddedCacheManager embeddedCacheManager;
            String workspaceName = entry.getKey();
            entry.getValue().signalClosed();
            if (!(this.workspaceCacheManager instanceof EmbeddedCacheManager) || !(embeddedCacheManager = (EmbeddedCacheManager)this.workspaceCacheManager).getStatus().equals((Object)ComponentStatus.RUNNING)) continue;
            String cacheName = this.cacheNameForWorkspace(workspaceName);
            ((EmbeddedCacheManager)this.workspaceCacheManager).removeCache(cacheName);
        }
    }

    public NodeKey getRepositoryMetadataDocumentKey() {
        return this.systemMetadataKey;
    }

    public void setLargeStringLength(long sizeInBytes) {
        assert (sizeInBytes > -1L);
        this.minimumStringLengthForBinaryStorage.set(sizeInBytes);
        for (WorkspaceCache workspaceCache : this.workspaceCachesByName.values()) {
            assert (workspaceCache != null);
            workspaceCache.setMinimumStringLengthForBinaryStorage(this.minimumStringLengthForBinaryStorage.get());
        }
    }

    public long largeValueSizeInBytes() {
        return this.minimumStringLengthForBinaryStorage.get();
    }

    protected void refreshRepositoryMetadata(boolean update) {
        final DocumentTranslator translator = new DocumentTranslator(this.context, this.documentStore, this.minimumStringLengthForBinaryStorage.get());
        final String systemMetadataKeyStr = this.systemMetadataKey.toString();
        final boolean accessControlEnabled = this.accessControlEnabled.get();
        SchematicEntry entry = this.documentStore.get(systemMetadataKeyStr);
        if (!update && entry != null) {
            Document doc = entry.getContent();
            Property accessProp = translator.getProperty(doc, this.name("accessControl"));
            boolean enabled = false;
            if (accessProp != null) {
                enabled = this.context.getValueFactories().getBooleanFactory().create(accessProp.getFirstValue());
            }
            this.accessControlEnabled.set(enabled);
            Property prop = translator.getProperty(doc, this.name("workspaces"));
            HashSet<String> persistedWorkspaceNames = new HashSet<String>();
            StringFactory strings = this.context.getValueFactories().getStringFactory();
            boolean workspaceNotYetPersisted = false;
            for (Object value : prop) {
                String workspaceName = (String)strings.create(value);
                persistedWorkspaceNames.add(workspaceName);
            }
            for (String configuredWorkspaceName : this.workspaceNames) {
                if (persistedWorkspaceNames.contains(configuredWorkspaceName)) continue;
                workspaceNotYetPersisted = true;
                break;
            }
            this.workspaceNames.addAll(persistedWorkspaceNames);
            if (!workspaceNotYetPersisted) {
                return;
            }
        }
        try {
            this.runInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SchematicEntry entry = RepositoryCache.this.documentStore().get(systemMetadataKeyStr);
                    if (entry == null) {
                        EditableDocument newDoc = Schematic.newDocument();
                        translator.setKey(newDoc, RepositoryCache.this.systemMetadataKey);
                        entry = RepositoryCache.this.documentStore().localStore().putIfAbsent(systemMetadataKeyStr, (Document)newDoc);
                        if (entry == null) {
                            entry = RepositoryCache.this.documentStore().localStore().get(systemMetadataKeyStr);
                        }
                    }
                    EditableDocument doc = RepositoryCache.this.documentStore().localStore().edit(systemMetadataKeyStr, true);
                    PropertyFactory propFactory = RepositoryCache.this.context().getPropertyFactory();
                    translator.setProperty(doc, propFactory.create(RepositoryCache.this.name("workspaces"), RepositoryCache.this.workspaceNames), null, null);
                    translator.setProperty(doc, propFactory.create(RepositoryCache.this.name("accessControl"), accessControlEnabled), null, null);
                    return null;
                }
            });
        }
        catch (RuntimeException re) {
            LOGGER.error((I18nResource)JcrI18n.errorUpdatingRepositoryMetadata, new Object[]{this.name, re.getMessage()});
            throw re;
        }
    }

    public void runOneTimeSystemInitializationOperation(Callable<Void> initOperation) throws Exception {
        if (!this.isInitializingRepository()) {
            return;
        }
        SessionCache systemSession = this.createSession(this.context, this.systemWorkspaceName, false);
        MutableCachedNode systemNode = this.getSystemNode(systemSession);
        ChildReference repositoryReference = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.REPOSITORY);
        if (repositoryReference != null) {
            return;
        }
        initOperation.call();
        Property primaryType = this.context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.REPOSITORY);
        systemNode.createChild(systemSession, systemNode.getKey().withId("mode:repository"), ModeShapeLexicon.REPOSITORY, primaryType, new Property[0]);
        systemSession.save();
    }

    private MutableCachedNode getSystemNode(SessionCache systemSession) {
        NodeKey systemRootKey = systemSession.getRootKey();
        CachedNode systemRoot = systemSession.getNode(systemRootKey);
        ChildReference systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        return systemSession.mutable(systemRef.getKey());
    }

    public final String getKey() {
        return this.repoKey;
    }

    public final NodeKey getSystemKey() {
        return this.systemKey;
    }

    public final String getSystemWorkspaceKey() {
        return NodeKey.keyForWorkspaceName(this.getSystemWorkspaceName());
    }

    public final String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    public final String getName() {
        return this.name;
    }

    public final Set<String> getWorkspaceNames() {
        return Collections.unmodifiableSet(this.workspaceNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkspaceCache workspace(final String name) {
        WorkspaceCache workspaceCache = this.workspaceCachesByName.get(name);
        if (workspaceCache != null) {
            return workspaceCache;
        }
        boolean isSystemWorkspace = this.systemWorkspaceName.equals(name);
        if (!this.workspaceNames.contains(name) && !isSystemWorkspace) {
            throw new WorkspaceNotFoundException(name);
        }
        final WorkspaceCache systemWorkspaceCache = isSystemWorkspace ? null : this.workspaceCachesByName.get(this.systemWorkspaceName);
        RepositoryCache repositoryCache = this;
        synchronized (repositoryCache) {
            if (!this.workspaceCachesByName.containsKey(name)) {
                WorkspaceCache initializedWsCache = this.runInTransaction(new Callable<WorkspaceCache>(){

                    @Override
                    public WorkspaceCache call() throws Exception {
                        Cache<NodeKey, CachedNode> nodeCache = RepositoryCache.this.cacheForWorkspace(name);
                        ExecutionContext context = RepositoryCache.this.context();
                        String workspaceKey = NodeKey.keyForWorkspaceName(name);
                        NodeKey rootKey = new NodeKey(RepositoryCache.this.sourceKey, workspaceKey, RepositoryCache.this.rootNodeId);
                        EditableDocument rootDoc = Schematic.newDocument();
                        DocumentTranslator trans = new DocumentTranslator(context, RepositoryCache.this.documentStore, Long.MAX_VALUE);
                        trans.setProperty(rootDoc, context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.ROOT), null, null);
                        trans.setProperty(rootDoc, context.getPropertyFactory().create(JcrLexicon.UUID, rootKey.toString()), null, null);
                        WorkspaceCache workspaceCache = new WorkspaceCache(context, RepositoryCache.this.getKey(), name, systemWorkspaceCache, RepositoryCache.this.documentStore, RepositoryCache.this.translator, rootKey, (ConcurrentMap<NodeKey, CachedNode>)nodeCache, RepositoryCache.this.changeBus);
                        if (RepositoryCache.this.documentStore.localStore().putIfAbsent(rootKey.toString(), (Document)rootDoc) == null && !RepositoryCache.this.systemWorkspaceName.equals(name)) {
                            RepositoryCache.this.logger.debug("Creating '{0}' workspace in repository '{1}'", new Object[]{name, RepositoryCache.this.getName()});
                            WritableSessionCache workspaceSession = new WritableSessionCache(context, workspaceCache, RepositoryCache.this.sessionContext);
                            MutableCachedNode workspaceRootNode = workspaceSession.mutable(workspaceSession.getRootKey());
                            workspaceRootNode.linkChild(workspaceSession, RepositoryCache.this.systemKey, JcrLexicon.SYSTEM);
                            workspaceSession.save();
                        }
                        return workspaceCache;
                    }
                });
                this.workspaceCachesByName.put(name, initializedWsCache);
            }
        }
        return this.workspaceCachesByName.get(name);
    }

    protected Cache<NodeKey, CachedNode> cacheForWorkspace(String name) {
        TransactionManager txManager;
        Cache cache = this.workspaceCacheManager.getCache(this.cacheNameForWorkspace(name));
        if (cache instanceof AdvancedCache && (txManager = ((AdvancedCache)cache).getTransactionManager()) != null) {
            throw new ConfigurationException(JcrI18n.workspaceCacheShouldNotBeTransactional.text(new Object[]{name}));
        }
        return cache;
    }

    protected final String cacheNameForWorkspace(String workspaceName) {
        return this.name + "/" + workspaceName;
    }

    public final DocumentTranslator getDocumentTranslator() {
        return this.translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWorkspaceCaches(String name) {
        assert (name != null);
        assert (!this.workspaceNames.contains(name));
        WorkspaceCache removed = this.workspaceCachesByName.remove(name);
        if (removed != null) {
            try {
                removed.signalDeleted();
                this.sessionContext.getTransactionalWorkspaceCacheFactory().remove(name);
            }
            finally {
                if (this.workspaceCacheManager instanceof EmbeddedCacheManager) {
                    ((EmbeddedCacheManager)this.workspaceCacheManager).removeCache(this.cacheNameForWorkspace(name));
                }
            }
        }
    }

    void refreshWorkspace(String name) {
        assert (name != null);
        this.workspaceCachesByName.remove(name);
    }

    Iterable<WorkspaceCache> workspaces() {
        return this.workspaceCachesByName.values();
    }

    public WorkspaceCache createWorkspace(String name) {
        if (!this.workspaceNames.contains(name)) {
            if (!this.configuration.isCreatingWorkspacesAllowed()) {
                throw new UnsupportedOperationException(JcrI18n.creatingWorkspacesIsNotAllowedInRepository.text(new Object[]{this.getName()}));
            }
            this.workspaceNames.add(name);
            this.refreshRepositoryMetadata(true);
            SessionCache session = this.createSession(this.context, name, false);
            MutableCachedNode root = session.mutable(session.getRootKey());
            ChildReference ref = root.getChildReferences(session).getChild(JcrLexicon.SYSTEM);
            if (ref == null) {
                root.linkChild(session, this.systemKey, JcrLexicon.SYSTEM);
                session.save();
            }
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.context.getProcessId(), this.getKey(), null, this.sessionContext.journalId());
            changes.workspaceAdded(name);
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
        }
        return this.workspace(name);
    }

    public boolean destroyWorkspace(final String name, final WritableSessionCache removeSession) {
        if (this.workspaceNames.contains(name)) {
            if (this.configuration.getPredefinedWorkspaceNames().contains(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroyPredefinedWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (this.configuration.getDefaultWorkspaceName().equals(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroyDefaultWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (this.systemWorkspaceName.equals(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroySystemWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (!this.configuration.isCreatingWorkspacesAllowed()) {
                throw new UnsupportedOperationException(JcrI18n.creatingWorkspacesIsNotAllowedInRepository.text(new Object[]{this.getName()}));
            }
            this.runInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    removeSession.mutable(removeSession.getRootKey()).removeChild(removeSession, RepositoryCache.this.getSystemKey());
                    RepositoryCache.this.workspaceNames.remove(name);
                    RepositoryCache.this.refreshRepositoryMetadata(true);
                    removeSession.save();
                    return null;
                }
            });
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.context.getProcessId(), this.getKey(), null, this.sessionContext.journalId());
            changes.workspaceRemoved(name);
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
            return true;
        }
        return false;
    }

    public WorkspaceCache getWorkspaceCache(String workspaceName) {
        return this.workspace(workspaceName);
    }

    public SessionCache createSession(ExecutionContext context, String workspaceName, boolean readOnly) {
        if (readOnly) {
            return new ReadOnlySessionCache(context, this.workspace(workspaceName), this.sessionContext);
        }
        return new WritableSessionCache(context, this.workspace(workspaceName), this.sessionContext);
    }

    public LocalDocumentStore.DocumentOperationResults optimizeChildren(final int targetCountPerBlock, final int tolerance) {
        Stopwatch sw = new Stopwatch();
        this.logger.info((I18nResource)JcrI18n.beginChildrenOptimization, new Object[]{this.getName()});
        sw.start();
        try {
            LocalDocumentStore.DocumentOperationResults results = this.documentStore().localStore().performOnEachDocument(new LocalDocumentStore.DocumentOperation(){
                private static final long serialVersionUID = 1L;
                private DocumentOptimizer optimizer;

                @Override
                public void setEnvironment(Cache<String, SchematicEntry> cache) {
                    super.setEnvironment(cache);
                    this.optimizer = new DocumentOptimizer(cache);
                }

                @Override
                public boolean execute(String key, EditableDocument document) {
                    return this.optimizer.optimizeChildrenBlocks(new NodeKey(key), document, targetCountPerBlock, tolerance);
                }
            });
            sw.stop();
            this.logger.info((I18nResource)JcrI18n.completeChildrenOptimization, new Object[]{this.getName(), sw.getTotalDuration().toSimpleString(), results});
            return results;
        }
        catch (Throwable e) {
            this.logger.info((I18nResource)JcrI18n.errorDuringChildrenOptimization, new Object[]{this.getName(), sw.getTotalDuration().toSimpleString(), e});
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public static interface ContentInitializer {
        public void initialize(SessionCache var1, MutableCachedNode var2);
    }

    protected class ChangesToWorkspacesListener
    implements ChangeSetListener {
        protected ChangesToWorkspacesListener() {
        }

        @Override
        public void notify(ChangeSet changeSet) {
            if (changeSet == null || !RepositoryCache.this.getKey().equals(changeSet.getRepositoryKey())) {
                return;
            }
            if (changeSet.getWorkspaceName() == null) {
                HashSet<String> removedNames = new HashSet<String>();
                boolean changed = false;
                for (Change change : changeSet) {
                    if (change instanceof WorkspaceAdded) {
                        String addedName = ((WorkspaceAdded)change).getWorkspaceName();
                        if (RepositoryCache.this.getWorkspaceNames().contains(addedName)) continue;
                        changed = true;
                        continue;
                    }
                    if (change instanceof WorkspaceRemoved) {
                        String removedName = ((WorkspaceRemoved)change).getWorkspaceName();
                        removedNames.add(removedName);
                        if (!RepositoryCache.this.getWorkspaceNames().contains(removedName)) continue;
                        changed = true;
                        continue;
                    }
                    if (!(change instanceof RepositoryMetadataChanged)) continue;
                    changed = true;
                }
                if (changed) {
                    RepositoryCache.this.refreshRepositoryMetadata(false);
                    for (String removedName : removedNames) {
                        RepositoryCache.this.removeWorkspaceCaches(removedName);
                    }
                }
            }
        }
    }

    protected class RepositoryFeaturesDetector
    implements ChangeSetListener {
        private final AtomicBoolean versioningUsed;
        private final NodeKey versionStorageKey;
        private final AtomicBoolean lockingUsed;
        private final NodeKey locksContainerKey;

        protected RepositoryFeaturesDetector(SessionCache systemSession, NodeKey systemNodeKey) {
            CachedNode systemNode = systemSession.getNode(systemNodeKey);
            this.versionStorageKey = systemNode.getChildReferences(systemSession).getChild(JcrLexicon.VERSION_STORAGE).getKey();
            CachedNode versionStorage = systemSession.getNode(this.versionStorageKey);
            boolean versioningUsed = !versionStorage.getChildReferences(systemSession).isEmpty();
            this.versioningUsed = new AtomicBoolean(versioningUsed);
            this.locksContainerKey = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.LOCKS).getKey();
            CachedNode locksContainer = systemSession.getNode(this.locksContainerKey);
            boolean lockingUsed = !locksContainer.getChildReferences(systemSession).isEmpty();
            this.lockingUsed = new AtomicBoolean(lockingUsed);
            if (!versioningUsed || !lockingUsed) {
                RepositoryCache.this.changeBus.registerInThread(this);
            }
        }

        protected boolean lockingUsed() {
            return this.lockingUsed.get();
        }

        protected boolean versioningUsed() {
            return this.versioningUsed.get();
        }

        @Override
        public void notify(ChangeSet changeSet) {
            if (!RepositoryCache.this.systemWorkspaceName.equals(changeSet.getWorkspaceName())) {
                return;
            }
            Set<NodeKey> nodeKeys = changeSet.changedNodes();
            if (!this.versioningUsed() && nodeKeys.contains(this.versionStorageKey)) {
                this.versioningUsed.set(true);
            }
            if (!this.lockingUsed() && nodeKeys.contains(this.locksContainerKey)) {
                this.lockingUsed.set(true);
            }
            if (this.versioningUsed() && this.lockingUsed()) {
                RepositoryCache.this.changeBus.unregister(this);
            }
        }
    }
}

