/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.query.qom.Constraint;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalIndex;
import org.modeshape.jcr.index.local.MapDB;
import org.modeshape.jcr.index.local.Operations;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.value.ValueComparators;

abstract class LocalMapIndex<T, V>
implements LocalIndex<V> {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final String name;
    protected final String workspace;
    protected final BTreeMap<T, String> keysByValue;
    protected final NavigableSet<Fun.Tuple2<String, T>> valuesByKey;
    protected final ConcurrentMap<String, Object> options;
    private final IndexValues.Converter<T> converter;
    private final DB db;
    protected final Comparator<T> comparator;

    LocalMapIndex(String name, String workspaceName, DB db, IndexValues.Converter<T> converter, BTreeKeySerializer<T> valueSerializer, Serializer<T> valueRawSerializer) {
        assert (name != null);
        assert (workspaceName != null);
        assert (db != null);
        assert (converter != null);
        assert (valueSerializer != null);
        this.name = name;
        this.workspace = workspaceName;
        this.converter = converter;
        this.db = db;
        if (db.exists(name)) {
            this.logger.debug("Reopening storage for '{0}' index in workspace '{1}'", new Object[]{name, workspaceName});
            this.options = db.getHashMap(name + "/options");
            this.keysByValue = db.getTreeMap(name);
            this.valuesByKey = db.getTreeSet(name + "/inverse");
        } else {
            this.logger.debug("Creating storage for '{0}' index in workspace '{1}'", new Object[]{name, workspaceName});
            this.options = db.createHashMap(name + "/options").make();
            this.keysByValue = db.createTreeMap(name).counterEnable().comparator(valueSerializer.getComparator()).keySerializer(valueSerializer).make();
            Comparator<String> strComparator = ValueComparators.STRING_COMPARATOR;
            Serializer strSerializer = Serializer.STRING;
            Comparator valueComparator = valueSerializer.getComparator();
            Comparator revComparator = MapDB.tupleComparator(strComparator, valueComparator);
            BTreeKeySerializer<Fun.Tuple2<String, T>> revSerializer = MapDB.tupleBTreeSerializer(strComparator, strSerializer, valueRawSerializer, revComparator);
            this.valuesByKey = db.createTreeSet(name + "/inverse").comparator(revComparator).serializer(revSerializer).make();
        }
        this.comparator = valueSerializer.getComparator();
        Bind.mapInverse(this.keysByValue, this.valuesByKey);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getWorkspaceName() {
        return this.workspace;
    }

    @Override
    public long estimateTotalCount() {
        return this.keysByValue.sizeLong();
    }

    protected final IndexValues.Converter<T> converter() {
        return this.converter;
    }

    @Override
    public Filter.Results filter(IndexConstraints filter) {
        return Operations.createFilter(this.keysByValue, this.converter, filter.getConstraints(), filter.getVariables()).getResults();
    }

    @Override
    public long estimateCardinality(Constraint constraint, Map<String, Object> variables) {
        return Operations.createFilter(this.keysByValue, this.converter, Collections.singleton(constraint), variables).estimateCount();
    }

    @Override
    public void removeAll() {
        this.keysByValue.clear();
    }

    @Override
    public void commit() {
        this.db.commit();
    }

    @Override
    public void shutdown(boolean destroyed) {
        if (destroyed) {
            this.db.delete(this.name);
        }
    }
}

