/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.value.PropertyType;

@Immutable
class RepositoryIndexColumnDefinition
implements IndexColumnDefinition {
    private final String propertyName;
    private final int columnType;

    public static IndexColumnDefinition createFrom(IndexColumnDefinition other) {
        return new RepositoryIndexColumnDefinition(other.getPropertyName(), other.getColumnType());
    }

    RepositoryIndexColumnDefinition(String propertyName, int columnType) {
        this.propertyName = propertyName;
        this.columnType = columnType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return this.propertyName + '(' + (Object)((Object)PropertyType.valueFor(this.columnType)) + ')';
    }
}

