/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.infinispan.commons.util.ReflectionUtil;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.ExtensionLogger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.CompositeIndexWriter;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryEngine;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.engine.IndexPlan;
import org.modeshape.jcr.query.engine.NoOpQueryIndexWriter;
import org.modeshape.jcr.query.engine.QuerySources;
import org.modeshape.jcr.query.engine.ScanningQueryEngine;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.optimize.AddIndexes;
import org.modeshape.jcr.query.optimize.Optimizer;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.optimize.RuleBasedOptimizer;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.plan.Planner;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.spi.query.QueryIndex;
import org.modeshape.jcr.spi.query.QueryIndexPlanner;
import org.modeshape.jcr.spi.query.QueryIndexProvider;
import org.modeshape.jcr.spi.query.QueryIndexWriter;

public class IndexQueryEngine
extends ScanningQueryEngine {
    protected static final Logger LOGGER = Logger.getLogger((String)"org.modeshape.jcr.query");
    protected static final boolean TRACE = LOGGER.isTraceEnabled();
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final Map<String, QueryIndexProvider> indexProvidersByName;
    private final QueryIndexWriter indexWriter;

    public static Builder builder() {
        return new Builder();
    }

    protected IndexQueryEngine(ExecutionContext context, String repositoryName, Planner planner, Optimizer optimizer, Map<String, QueryIndexProvider> indexProvidersByName) {
        super(context, repositoryName, planner, optimizer);
        this.indexProvidersByName = Collections.unmodifiableMap(indexProvidersByName);
        this.indexWriter = this.indexProvidersByName.isEmpty() ? NoOpQueryIndexWriter.INSTANCE : (this.indexProvidersByName.size() == 1 ? this.indexProvidersByName.values().iterator().next().getQueryIndexWriter() : new CompositeIndexWriter(this.indexProvidersByName.values()));
    }

    @Override
    public void shutdown() {
        for (QueryIndexProvider provider : this.indexProvidersByName.values()) {
            try {
                provider.shutdown();
            }
            catch (RepositoryException e) {
                LOGGER.error((Throwable)e, (I18nResource)JcrI18n.errorShuttingDownIndexProvider, new Object[]{this.repositoryName, provider.getName(), e.getMessage()});
            }
        }
    }

    @Override
    public QueryContext createQueryContext(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, Schemata schemata, NodeTypes nodeTypes, BufferManager bufferManager, PlanHints hints, Map<String, Object> variables) {
        return new IndexQueryContext(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, schemata, nodeTypes, bufferManager, hints, null, variables, new HashMap<PlanNode, QueryResults.Columns>(), this.indexProvidersByName);
    }

    @Override
    public QueryIndexWriter getQueryIndexWriter() {
        return this.indexWriter;
    }

    @Override
    protected NodeSequence createNodeSequenceForSource(QueryCommand originalQuery, QueryContext context, PlanNode sourceNode, IndexPlan indexPlan, QueryResults.Columns columns, QuerySources sources) {
        QueryIndex index;
        NodeSequence sequence = super.createNodeSequenceForSource(originalQuery, context, sourceNode, indexPlan, columns, sources);
        if (sequence != null) {
            return sequence;
        }
        String providerName = indexPlan.getProviderName();
        QueryIndexProvider provider = this.indexProvidersByName.get(providerName);
        if (provider != null && (index = provider.getQueryIndex(indexPlan.getName())) != null) {
            return sources.fromIndex(index, indexPlan.getConstraints(), indexPlan.getParameters(), 100);
        }
        return null;
    }

    @ThreadSafe
    static class IndexQueryContext
    extends ScanningQueryEngine.ScanQueryContext {
        private final Map<String, QueryIndexProvider> providersByName;

        protected IndexQueryContext(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, Schemata schemata, NodeTypes nodeTypes, BufferManager bufferManager, PlanHints hints, Problems problems, Map<String, Object> variables, Map<PlanNode, QueryResults.Columns> columnsByPlanNode, Map<String, QueryIndexProvider> indexProvidersByName) {
            super(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, schemata, nodeTypes, bufferManager, hints, problems, variables, columnsByPlanNode);
            this.providersByName = indexProvidersByName;
        }

        public Collection<QueryIndexProvider> getQueryIndexProviders() {
            return this.providersByName.values();
        }

        public QueryIndexProvider getQueryIndexProvider(String name) {
            return this.providersByName.get(name);
        }

        @Override
        public IndexQueryContext with(Map<String, Object> variables) {
            return new IndexQueryContext(this.context, this.repositoryCache, this.workspaceNames, this.overriddenNodeCachesByWorkspaceName, this.schemata, this.nodeTypes, this.bufferManager, this.hints, this.problems, variables, this.columnsByPlanNode, this.providersByName);
        }

        @Override
        public IndexQueryContext with(PlanHints hints) {
            return new IndexQueryContext(this.context, this.repositoryCache, this.workspaceNames, this.overriddenNodeCachesByWorkspaceName, this.schemata, this.nodeTypes, this.bufferManager, hints, this.problems, this.variables, this.columnsByPlanNode, this.providersByName);
        }

        @Override
        public IndexQueryContext with(Problems problems) {
            return new IndexQueryContext(this.context, this.repositoryCache, this.workspaceNames, this.overriddenNodeCachesByWorkspaceName, this.schemata, this.nodeTypes, this.bufferManager, this.hints, problems, this.variables, this.columnsByPlanNode, this.providersByName);
        }

        @Override
        public IndexQueryContext with(Schemata schemata) {
            return new IndexQueryContext(this.context, this.repositoryCache, this.workspaceNames, this.overriddenNodeCachesByWorkspaceName, schemata, this.nodeTypes, this.bufferManager, this.hints, this.problems, this.variables, this.columnsByPlanNode, this.providersByName);
        }
    }

    public static class Builder
    extends ScanningQueryEngine.Builder {
        @Override
        public QueryEngine build() {
            HashMap<String, QueryIndexProvider> providersByName = new HashMap<String, QueryIndexProvider>();
            List<RepositoryConfiguration.Component> components = this.config().getIndexes().getProviders();
            QueryIndexPlanner indexPlanner = IndexPlan.StandardIndexPlanner.INSTANCE;
            for (RepositoryConfiguration.Component component : components) {
                try {
                    QueryIndexProvider provider = (QueryIndexProvider)component.createInstance(ScanningQueryEngine.class.getClassLoader());
                    ReflectionUtil.setValue((Object)provider, (String)"repositoryName", (Object)this.repositoryName());
                    ReflectionUtil.setValue((Object)provider, (String)"logger", (Object)ExtensionLogger.getLogger(provider.getClass()));
                    provider.initialize();
                    Method postInitialize = ReflectionUtil.findMethod(QueryIndexProvider.class, (String)"postInitialize");
                    ReflectionUtil.invokeAccessibly((Object)provider, (Method)postInitialize, (Object[])new Object[0]);
                    if (DEBUG) {
                        LOGGER.debug("Successfully initialized index provider '{0}' in repository '{1}'", new Object[]{provider.getName(), this.repositoryName()});
                    }
                    providersByName.put(provider.getName(), provider);
                    QueryIndexPlanner providerPlanner = provider.getIndexPlanner();
                    if (providerPlanner == null) {
                        throw new IllegalStateException(JcrI18n.indexProviderMissingPlanner.text(new Object[]{provider.getName(), this.repositoryName()}));
                    }
                    indexPlanner = QueryIndexPlanner.both(indexPlanner, providerPlanner);
                }
                catch (Throwable t) {
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                    LOGGER.error(t, (I18nResource)JcrI18n.unableToInitializeIndexProvider, new Object[]{component, this.repositoryName(), t.getMessage()});
                }
            }
            if (providersByName.isEmpty()) {
                return super.build();
            }
            Optimizer optimizer = this.optimizer();
            if (optimizer == null) {
                final AddIndexes indexingRule = AddIndexes.with(indexPlanner);
                optimizer = new RuleBasedOptimizer(){

                    @Override
                    protected void populateIndexingRules(LinkedList<OptimizerRule> ruleStack, PlanHints hints) {
                        super.populateIndexingRules(ruleStack, hints);
                        ruleStack.addLast(indexingRule);
                    }
                };
            }
            return new IndexQueryEngine(this.context(), this.repositoryName(), this.planner(), optimizer, providersByName);
        }

        @Override
        protected Optimizer defaultOptimizer() {
            return null;
        }
    }
}

