/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.basic.BasicPathSegment;

@Immutable
public class ChildReference
implements Comparable<ChildReference> {
    private final NodeKey key;
    private final Path.Segment segment;

    public ChildReference(NodeKey key, Name name, int snsIndex) {
        this.key = key;
        this.segment = new BasicPathSegment(name, snsIndex);
    }

    public ChildReference(NodeKey key, Path.Segment segment) {
        this.key = key;
        this.segment = segment;
    }

    public NodeKey getKey() {
        return this.key;
    }

    public Name getName() {
        return this.segment.getName();
    }

    public int getSnsIndex() {
        return this.segment.getIndex();
    }

    public Path.Segment getSegment() {
        return this.segment;
    }

    @Override
    public int compareTo(ChildReference that) {
        if (that == this) {
            return 0;
        }
        int diff = this.segment.compareTo(that.segment);
        if (diff != 0) {
            return diff;
        }
        return this.key.compareTo(that.key);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChildReference) {
            ChildReference that = (ChildReference)obj;
            return this.segment.equals(that.segment) && this.key.equals(that.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.segment.getString() + " (key=" + this.key + ")";
    }

    public String getSegmentAsString(NamespaceRegistry registry) {
        return this.segment.getString(registry);
    }

    public String toString(NamespaceRegistry registry) {
        return "\"" + this.segment.getString(registry) + "\"=" + this.key;
    }

    public ChildReference with(int snsIndex) {
        return snsIndex == this.segment.getIndex() ? this : new ChildReference(this.key, this.segment.getName(), snsIndex);
    }

    public ChildReference with(Name name, int snsIndex) {
        if (snsIndex == this.segment.getIndex() && this.segment.getName().equals(name)) {
            return this;
        }
        return new ChildReference(this.key, name, snsIndex);
    }
}

