/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.process.ProcessingComponent;
import org.modeshape.jcr.query.process.SortLocationsComponent;

public abstract class SetOperationComponent
extends ProcessingComponent {
    private final Iterable<ProcessingComponent> sources;
    protected final List<QueryResults.TupleReformatter> sourceReformatters;
    protected final Comparator<Object[]> removeDuplicatesComparator;
    private final QueryResults.Columns columns;

    protected SetOperationComponent(QueryContext context, QueryResults.Columns columns, Iterable<ProcessingComponent> sources, boolean alreadySorted, boolean all) {
        super(context, columns);
        assert (SetOperationComponent.unionCompatible(columns, sources));
        this.sources = SetOperationComponent.wrapWithLocationOrdering(sources, alreadySorted);
        ArrayList<QueryResults.TupleReformatter> reformatters = new ArrayList<QueryResults.TupleReformatter>();
        QueryResults.Columns reformattedColumns = null;
        for (ProcessingComponent component : sources) {
            QueryResults.TupleReformatter reformatter = component.getColumns().getTupleReformatter();
            reformatters.add(reformatter);
            if (reformattedColumns != null || reformatter == null) continue;
            reformattedColumns = reformatter.getColumns();
        }
        QueryResults.Columns newColumns = this.sources.iterator().next().getColumns();
        if (Collections.frequency(reformatters, reformatters.get(0)) == reformatters.size()) {
            this.sourceReformatters = Collections.nCopies(reformatters.size(), null);
        } else {
            this.sourceReformatters = reformatters;
            if (reformattedColumns != null) {
                newColumns = reformattedColumns;
            }
        }
        this.columns = newColumns;
        this.removeDuplicatesComparator = all ? null : this.createSortComparator(context, this.columns);
    }

    protected static boolean unionCompatible(QueryResults.Columns columns, Iterable<ProcessingComponent> sources) {
        for (ProcessingComponent source : sources) {
            if (columns.isUnionCompatible(source.getColumns())) continue;
            return false;
        }
        return true;
    }

    @Override
    public QueryResults.Columns getColumns() {
        return this.columns;
    }

    protected Iterable<ProcessingComponent> sources() {
        return this.sources;
    }

    protected static Iterable<ProcessingComponent> wrapWithLocationOrdering(Iterable<ProcessingComponent> sources, boolean alreadySorted) {
        assert (sources != null);
        if (alreadySorted) {
            return sources;
        }
        LinkedList<ProcessingComponent> wrapped = new LinkedList<ProcessingComponent>();
        for (ProcessingComponent source : sources) {
            wrapped.add(new SortLocationsComponent(source));
        }
        return wrapped;
    }

    protected void removeDuplicatesIfRequested(List<Object[]> tuples) {
        if (this.removeDuplicatesComparator != null) {
            Iterator<Object[]> iter = tuples.iterator();
            Object[] previous = null;
            while (iter.hasNext()) {
                Object[] current = iter.next();
                if (previous != null && this.removeDuplicatesComparator.compare(previous, current) == 0) {
                    iter.remove();
                    continue;
                }
                previous = current;
            }
        }
    }
}

