/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.LinkedList;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;

@Immutable
public class RightOuterToLeftOuterJoins
implements OptimizerRule {
    public static final RightOuterToLeftOuterJoins INSTANCE = new RightOuterToLeftOuterJoins();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode joinNode : plan.findAllAtOrBelow(PlanNode.Type.JOIN)) {
            if (JoinType.RIGHT_OUTER != joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class)) continue;
            PlanNode left = joinNode.getFirstChild();
            left.removeFromParent();
            left.setParent(joinNode);
            joinNode.setProperty(PlanNode.Property.JOIN_TYPE, JoinType.LEFT_OUTER);
        }
        return plan;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

