/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.AbstractBinary;

public class UrlBinaryValue
extends AbstractBinary {
    private static final long serialVersionUID = 1L;
    private transient MimeTypeDetector mimeTypeDetector;
    private transient String nameHint;
    private String mimeType;
    private URL url;
    private long size;
    private boolean detectedMimeType = false;

    public UrlBinaryValue(BinaryKey binaryKey, URL content, long size, String nameHint, MimeTypeDetector mimeTypeDetector) {
        super(binaryKey);
        this.url = content;
        this.size = size;
        this.nameHint = nameHint;
        this.mimeTypeDetector = mimeTypeDetector;
    }

    protected URL toUrl() {
        return this.url;
    }

    protected void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    protected boolean hasMimeType() {
        return this.mimeType != null;
    }

    public String getMimeType() {
        if (!this.detectedMimeType && this.mimeTypeDetector != null) {
            try {
                this.mimeType = this.mimeTypeDetector.mimeTypeOf(this.nameHint, (Binary)this);
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).debug("Unable to compute MIME Type for file at {0}", new Object[]{this.toUrl()});
                throw new RuntimeException(t);
            }
            finally {
                this.detectedMimeType = true;
            }
        }
        return this.mimeType;
    }

    public String getMimeType(String name) {
        return this.getMimeType();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public InputStream getStream() throws RepositoryException {
        try {
            return new BufferedInputStream(this.url.openStream());
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

