/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ClassUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.JaasCredentials;
import org.modeshape.jcr.security.AuthenticationProvider;
import org.modeshape.jcr.security.JaasSecurityContext;
import org.modeshape.jcr.security.JaccSubjectResolver;

public class JaasProvider
implements AuthenticationProvider {
    private final String policyName;
    private final SubjectResolver subjectResolver;

    public JaasProvider(String policyName) throws LoginException {
        CheckArg.isNotNull((Object)policyName, (String)"policyName");
        this.policyName = policyName;
        new LoginContext(policyName);
        JaccSubjectResolver subjectResolver = null;
        try {
            ClassUtil.loadClassStrict((String)"javax.security.jacc.PolicyContext");
            subjectResolver = new JaccSubjectResolver();
            Logger.getLogger(this.getClass()).debug("Enabling optional JACC approach for resolving the JAAS Subject (typically in J2EE containers)", new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            Logger.getLogger(this.getClass()).debug("Failed to find 'javax.security.jacc.PolicyContext', so assuming not in a J2EE container.", new Object[0]);
        }
        this.subjectResolver = subjectResolver;
    }

    @Override
    public ExecutionContext authenticate(final Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        try {
            if (credentials == null) {
                Subject subject = Subject.getSubject(AccessController.getContext());
                if (subject != null) {
                    return repositoryContext.with(new JaasSecurityContext(subject));
                }
                if (this.subjectResolver != null && (subject = this.subjectResolver.resolveSubject()) != null) {
                    return repositoryContext.with(new JaasSecurityContext(subject));
                }
                return null;
            }
            if (credentials instanceof SimpleCredentials) {
                SimpleCredentials simple = (SimpleCredentials)credentials;
                String[] attributeNames = simple.getAttributeNames();
                if (attributeNames != null && attributeNames.length != 0) {
                    sessionAttributes = new HashMap<String, Object>();
                    for (String attributeName : simple.getAttributeNames()) {
                        Object attributeValue = simple.getAttribute(attributeName);
                        sessionAttributes.put(attributeName, attributeValue);
                    }
                }
                return repositoryContext.with(new JaasSecurityContext(this.policyName, simple.getUserID(), simple.getPassword()));
            }
            LoginContext loginContext = null;
            if (credentials instanceof JaasCredentials) {
                loginContext = ((JaasCredentials)credentials).getLoginContext();
            } else {
                try {
                    final Method method = credentials.getClass().getMethod("getLoginContext", new Class[0]);
                    Object result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return method.invoke((Object)credentials, new Object[0]);
                        }
                    });
                    if (result instanceof LoginContext) {
                        loginContext = (LoginContext)result;
                    } else {
                        Logger.getLogger(JaasProvider.class).error((I18nResource)JcrI18n.credentialsMustReturnLoginContext, new Object[]{credentials.getClass().getName()});
                    }
                }
                catch (NoClassDefFoundError error) {
                }
                catch (NoSuchMethodException error) {
                }
                catch (PrivilegedActionException e) {
                    Logger.getLogger(JaasProvider.class).warn((I18nResource)JcrI18n.noPrivilegeToGetLoginContextFromCredentials, new Object[]{credentials.getClass().getName()});
                }
            }
            if (loginContext != null) {
                Subject subject = loginContext.getSubject();
                if (subject == null) {
                    loginContext.login();
                    subject = loginContext.getSubject();
                    if (subject == null && this.subjectResolver != null && (subject = this.subjectResolver.resolveSubject()) != null) {
                        return repositoryContext.with(new JaasSecurityContext(subject));
                    }
                    if (subject == null) {
                        return null;
                    }
                }
                return repositoryContext.with(new JaasSecurityContext(loginContext));
            }
        }
        catch (LoginException error) {
            // empty catch block
        }
        return null;
    }

    public static interface SubjectResolver {
        public Subject resolveSubject();
    }
}

