/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.Limit;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.process.ProcessingComponent;
import org.modeshape.jcr.query.validate.Schemata;

public abstract class AbstractAccessComponent
extends ProcessingComponent {
    protected final PlanNode accessNode;
    protected final SelectorName sourceName;
    protected final List<Column> projectedColumns;
    protected final List<Constraint> andedConstraints;
    protected final Limit limit;

    protected AbstractAccessComponent(QueryContext context, QueryResults.Columns columns, PlanNode accessNode) {
        super(context, columns);
        this.accessNode = accessNode;
        PlanNode source = accessNode.findAtOrBelow(PlanNode.Type.SOURCE);
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.sourceName = source.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
        PlanNode project = accessNode.findAtOrBelow(PlanNode.Type.PROJECT);
        if (project != null) {
            List<Column> projectedColumns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
            if (projectedColumns != null) {
                this.projectedColumns = projectedColumns;
            } else {
                List<Schemata.Column> schemataColumns = source.getPropertyAsList(PlanNode.Property.SOURCE_COLUMNS, Schemata.Column.class);
                this.projectedColumns = new ArrayList<Column>(schemataColumns.size());
                for (Schemata.Column schemataColumn : schemataColumns) {
                    String columnName;
                    String propertyName = columnName = schemataColumn.getName();
                    Column column = new Column(this.sourceName, propertyName, columnName);
                    this.projectedColumns.add(column);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        List andedConstraints = null;
        for (PlanNode select : accessNode.findAllAtOrBelow(PlanNode.Type.SELECT)) {
            Constraint selectConstraint = select.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
            if (andedConstraints == null) {
                andedConstraints = new ArrayList();
            }
            andedConstraints.add(selectConstraint);
        }
        this.andedConstraints = andedConstraints != null ? andedConstraints : Collections.emptyList();
        Limit limit = Limit.NONE;
        PlanNode limitNode = accessNode.findAtOrBelow(PlanNode.Type.LIMIT);
        if (limitNode != null) {
            Integer offset;
            Integer count = limitNode.getProperty(PlanNode.Property.LIMIT_COUNT, Integer.class);
            if (count != null) {
                limit = limit.withRowLimit(count);
            }
            if ((offset = limitNode.getProperty(PlanNode.Property.LIMIT_OFFSET, Integer.class)) != null) {
                limit = limit.withOffset(offset);
            }
        }
        this.limit = limit;
    }
}

