/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeIterator;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.nodetype.InvalidNodeTypeDefinitionException;
import org.modeshape.jcr.nodetype.NodeDefinitionTemplate;
import org.modeshape.jcr.nodetype.NodeTypeExistsException;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;
import org.modeshape.jcr.nodetype.PropertyDefinitionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class JcrNodeTypeManager
implements NodeTypeManager {
    private final JcrSession session;
    private final RepositoryNodeTypeManager repositoryTypeManager;
    private Schemata schemata;

    JcrNodeTypeManager(JcrSession session, RepositoryNodeTypeManager repositoryTypeManager) {
        this.session = session;
        this.repositoryTypeManager = repositoryTypeManager;
    }

    private final ExecutionContext context() {
        return this.session.getExecutionContext();
    }

    Schemata schemata() {
        if (this.schemata == null) {
            this.schemata = this.repositoryTypeManager.getRepositorySchemata().getSchemataForSession(this.session);
            assert (this.schemata != null);
        }
        return this.schemata;
    }

    void signalNamespaceChanges() {
        this.schemata = null;
    }

    void signalExternalNodeTypeChanges() {
        this.schemata = null;
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        this.session.checkLive();
        return new JcrNodeTypeIterator(this.repositoryTypeManager.getAllNodeTypes());
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        this.session.checkLive();
        Collection<JcrNodeType> rawTypes = this.repositoryTypeManager.getMixinNodeTypes();
        ArrayList<JcrNodeType> types = new ArrayList<JcrNodeType>(rawTypes.size());
        for (JcrNodeType type : rawTypes) {
            types.add(type.with(this.context()));
        }
        return new JcrNodeTypeIterator(types);
    }

    public JcrNodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        this.session.checkLive();
        Name ntName = (Name)this.context().getValueFactories().getNameFactory().create(nodeTypeName);
        JcrNodeType type = this.repositoryTypeManager.getNodeType(ntName);
        if (type != null) {
            type = type.with(this.context());
            return type;
        }
        throw new NoSuchNodeTypeException(JcrI18n.typeNotFound.text(new Object[]{nodeTypeName}));
    }

    JcrNodeType getNodeType(Name nodeTypeName) {
        JcrNodeType nodeType = this.repositoryTypeManager.getNodeType(nodeTypeName);
        if (nodeType != null) {
            nodeType = nodeType.with(this.context());
        }
        return nodeType;
    }

    public boolean hasNodeType(String nodeTypeName) {
        Name ntName = (Name)this.context().getValueFactories().getNameFactory().create(nodeTypeName);
        return this.repositoryTypeManager.hasNodeType(ntName);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        this.session.checkLive();
        Collection<JcrNodeType> rawTypes = this.repositoryTypeManager.getPrimaryNodeTypes();
        ArrayList<JcrNodeType> types = new ArrayList<JcrNodeType>(rawTypes.size());
        for (JcrNodeType type : rawTypes) {
            types.add(type.with(this.context()));
        }
        return new JcrNodeTypeIterator(types);
    }

    JcrNodeDefinition getRootNodeDefinition() throws NoSuchNodeTypeException, RepositoryException {
        for (JcrNodeDefinition definition : this.repositoryTypeManager.getNodeType(ModeShapeLexicon.ROOT).getChildNodeDefinitions()) {
            if (!definition.getName().equals("*")) continue;
            return definition;
        }
        assert (false);
        return null;
    }

    JcrNodeDefinition getNodeDefinition(NodeDefinitionId definitionId) {
        if (definitionId == null) {
            return null;
        }
        return this.repositoryTypeManager.getChildNodeDefinition(definitionId);
    }

    JcrPropertyDefinition getPropertyDefinition(PropertyDefinitionId definitionId) {
        if (definitionId == null) {
            return null;
        }
        return this.repositoryTypeManager.getPropertyDefinition(definitionId);
    }

    final JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, List<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected) {
        return this.repositoryTypeManager.findPropertyDefinition(primaryTypeName, mixinTypeNames, propertyName, value, checkMultiValuedDefinitions, skipProtected);
    }

    final JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, List<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected, boolean checkTypesAndConstraints) {
        return this.repositoryTypeManager.findPropertyDefinition(primaryTypeName, mixinTypeNames, propertyName, value, checkMultiValuedDefinitions, skipProtected, checkTypesAndConstraints);
    }

    final JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, List<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected) {
        return this.repositoryTypeManager.findPropertyDefinition(primaryTypeName, mixinTypeNames, propertyName, values, skipProtected);
    }

    final JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, List<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected, boolean checkTypeAndConstraints) {
        return this.repositoryTypeManager.findPropertyDefinition(primaryTypeName, mixinTypeNames, propertyName, values, skipProtected, checkTypeAndConstraints);
    }

    boolean canRemoveProperty(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name propertyName, boolean skipProtected) {
        return this.repositoryTypeManager.canRemoveProperty(primaryTypeNameOfParent, mixinTypeNamesOfParent, propertyName, skipProtected);
    }

    final JcrNodeDefinition findChildNodeDefinition(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name childName, Name childPrimaryNodeType, int numberOfExistingChildrenWithSameName, boolean skipProtected) {
        return this.repositoryTypeManager.findChildNodeDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, childName, childPrimaryNodeType, numberOfExistingChildrenWithSameName, skipProtected);
    }

    final boolean canRemoveAllChildren(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name childName, boolean skipProtected) {
        return this.repositoryTypeManager.canRemoveAllChildren(primaryTypeNameOfParent, mixinTypeNamesOfParent, childName, skipProtected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeType registerNodeType(NodeTypeDefinition template, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.session.checkLive();
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        try {
            JcrNodeType jcrNodeType = this.repositoryTypeManager.registerNodeType(template, !allowUpdate);
            return jcrNodeType;
        }
        finally {
            this.schemata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeIterator registerNodeTypes(Collection<NodeTypeDefinition> templates, boolean allowUpdates) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.session.checkLive();
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        try {
            JcrNodeTypeIterator jcrNodeTypeIterator = new JcrNodeTypeIterator(this.repositoryTypeManager.registerNodeTypes(templates, !allowUpdates, false));
            return jcrNodeTypeIterator;
        }
        finally {
            this.schemata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeIterator registerNodeTypes(Iterable<NodeTypeDefinition> nodeTypes) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        try {
            JcrNodeTypeIterator jcrNodeTypeIterator = new JcrNodeTypeIterator(this.repositoryTypeManager.registerNodeTypes(nodeTypes));
            return jcrNodeTypeIterator;
        }
        finally {
            this.schemata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        try {
            JcrNodeTypeIterator jcrNodeTypeIterator = new JcrNodeTypeIterator(this.repositoryTypeManager.registerNodeTypes(Arrays.asList(ntds), !allowUpdate, false));
            return jcrNodeTypeIterator;
        }
        finally {
            this.schemata = null;
        }
    }

    public void unregisterNodeType(String nodeTypeName) throws NoSuchNodeTypeException, InvalidNodeTypeDefinitionException, RepositoryException {
        this.unregisterNodeTypes(Collections.singleton(nodeTypeName));
    }

    public void unregisterNodeTypes(Collection<String> nodeTypeNames) throws NoSuchNodeTypeException, InvalidNodeTypeDefinitionException, RepositoryException {
        NameFactory nameFactory = this.context().getValueFactories().getNameFactory();
        try {
            this.session.checkPermission((Path)null, "register_type");
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        ArrayList<Name> names = new ArrayList<Name>(nodeTypeNames.size());
        for (String name : nodeTypeNames) {
            names.add((Name)nameFactory.create(name));
        }
        this.repositoryTypeManager.unregisterNodeType(names);
        this.schemata = null;
    }

    public void unregisterNodeTypes(String[] names) throws NoSuchNodeTypeException, RepositoryException {
        this.unregisterNodeTypes(Arrays.asList(names));
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws RepositoryException {
        return new JcrNodeTypeTemplate(this.context());
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws RepositoryException {
        JcrNodeTypeTemplate ntt = new JcrNodeTypeTemplate(this.context(), true);
        if (ntd != null) {
            ntt.setName(ntd.getName());
            ntt.setAbstract(ntd.isAbstract());
            ntt.setDeclaredSuperTypeNames(ntd.getDeclaredSupertypeNames());
            ntt.setMixin(ntd.isMixin());
            ntt.setOrderableChildNodes(ntd.hasOrderableChildNodes());
            ntt.setPrimaryItemName(ntd.getPrimaryItemName());
            ntt.setQueryable(ntd.isQueryable());
            for (NodeDefinition nodeDefinition : ntd.getDeclaredChildNodeDefinitions()) {
                JcrNodeDefinitionTemplate ndt = new JcrNodeDefinitionTemplate(this.context());
                ndt.setAutoCreated(nodeDefinition.isAutoCreated());
                ndt.setDefaultPrimaryType(nodeDefinition.getDefaultPrimaryTypeName());
                ndt.setMandatory(nodeDefinition.isMandatory());
                if (nodeDefinition.getName() != null) {
                    ndt.setName(nodeDefinition.getName());
                }
                ndt.setOnParentVersion(nodeDefinition.getOnParentVersion());
                ndt.setProtected(nodeDefinition.isProtected());
                ndt.setRequiredPrimaryTypeNames(nodeDefinition.getRequiredPrimaryTypeNames());
                ndt.setSameNameSiblings(nodeDefinition.allowsSameNameSiblings());
                ntt.getNodeDefinitionTemplates().add(ndt);
            }
            for (NodeDefinition nodeDefinition : ntd.getDeclaredPropertyDefinitions()) {
                JcrPropertyDefinitionTemplate pdt = new JcrPropertyDefinitionTemplate(this.context());
                pdt.setAutoCreated(nodeDefinition.isAutoCreated());
                pdt.setAvailableQueryOperators(nodeDefinition.getAvailableQueryOperators());
                pdt.setDefaultValues(nodeDefinition.getDefaultValues());
                pdt.setFullTextSearchable(nodeDefinition.isFullTextSearchable());
                pdt.setMandatory(nodeDefinition.isMandatory());
                pdt.setMultiple(nodeDefinition.isMultiple());
                if (nodeDefinition.getName() != null) {
                    pdt.setName(nodeDefinition.getName());
                }
                pdt.setOnParentVersion(nodeDefinition.getOnParentVersion());
                pdt.setProtected(nodeDefinition.isProtected());
                pdt.setQueryOrderable(nodeDefinition.isQueryOrderable());
                pdt.setRequiredType(nodeDefinition.getRequiredType());
                pdt.setValueConstraints(nodeDefinition.getValueConstraints());
                ntt.getPropertyDefinitionTemplates().add(pdt);
            }
        }
        return ntt;
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws RepositoryException {
        return new JcrNodeDefinitionTemplate(this.context());
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws RepositoryException {
        return new JcrPropertyDefinitionTemplate(this.context());
    }

    public boolean isDerivedFrom(String[] testTypeNames, String primaryTypeName, String[] mixinNames) throws RepositoryException {
        Name[] typeNames;
        CheckArg.isNotEmpty((Object[])testTypeNames, (String)"testTypeNames");
        CheckArg.isNotEmpty((String)primaryTypeName, (String)"primaryTypeName");
        NameFactory nameFactory = this.context().getValueFactories().getNameFactory();
        for (Name name : typeNames = (Name[])nameFactory.create(testTypeNames)) {
            JcrNodeType nodeType = this.getNodeType(name);
            if (nodeType == null || !nodeType.isNodeType(primaryTypeName)) continue;
            return true;
        }
        if (mixinNames != null) {
            for (String string : mixinNames) {
                for (Name typeName : typeNames) {
                    JcrNodeType nodeType = this.getNodeType(typeName);
                    if (nodeType == null || !nodeType.isNodeType(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

