/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.AccessControlException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.VersionException;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ReferenceFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.query.QueryBuilder;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrBinary;
import org.modeshape.jcr.JcrContentHandler;
import org.modeshape.jcr.JcrDocumentViewExporter;
import org.modeshape.jcr.JcrGraph;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrQueryManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSystemViewExporter;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.SessionCache;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@NotThreadSafe
class JcrSession
implements Session {
    private static final String[] NO_ATTRIBUTES_NAMES = new String[0];
    private final JcrRepository repository;
    private final JcrWorkspace workspace;
    private final JcrNamespaceRegistry sessionRegistry;
    private ExecutionContext executionContext;
    private final Map<String, Object> sessionAttributes;
    private final JcrGraph graph;
    private final SessionCache cache;
    private final Path rootPath;
    private boolean isLive;
    private final boolean performReferentialIntegrityChecks;
    private Set<Location> removedNodes = null;
    private Set<String> removedReferenceableNodeUuids = null;

    JcrSession(JcrRepository repository, JcrWorkspace workspace, ExecutionContext sessionContext, NamespaceRegistry globalNamespaceRegistry, Map<String, Object> sessionAttributes) {
        assert (repository != null);
        assert (workspace != null);
        assert (sessionAttributes != null);
        assert (sessionContext != null);
        this.repository = repository;
        this.sessionAttributes = sessionAttributes;
        this.workspace = workspace;
        this.executionContext = sessionContext;
        NamespaceRegistry local = sessionContext.getNamespaceRegistry();
        this.sessionRegistry = new JcrNamespaceRegistry(JcrNamespaceRegistry.Behavior.SESSION, local, globalNamespaceRegistry, this);
        this.rootPath = this.executionContext.getValueFactories().getPathFactory().createRootPath();
        this.graph = workspace.graph();
        this.cache = new SessionCache(this);
        this.isLive = true;
        this.performReferentialIntegrityChecks = Boolean.valueOf(repository.getOptions().get((Object)JcrRepository.Option.PERFORM_REFERENTIAL_INTEGRITY_CHECKS));
        assert (this.sessionAttributes != null);
        assert (this.workspace != null);
        assert (this.repository != null);
        assert (this.executionContext != null);
        assert (this.sessionRegistry != null);
        assert (this.graph != null);
        assert (this.executionContext.getSecurityContext() != null);
    }

    final SessionCache cache() {
        return this.cache;
    }

    public boolean isLive() {
        return this.isLive;
    }

    final void checkLive() throws RepositoryException {
        if (!this.isLive()) {
            throw new RepositoryException(JcrI18n.sessionIsNotActive.text(new Object[]{this.sessionId()}));
        }
    }

    ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    void setSessionData(String key, String value) {
        this.executionContext = this.executionContext.with(key, value);
        this.graph.setContext(this.executionContext);
    }

    String sessionId() {
        return this.executionContext.getId();
    }

    JcrLockManager lockManager() {
        return this.workspace.lockManager();
    }

    JcrNodeTypeManager nodeTypeManager() {
        return this.workspace.nodeTypeManager();
    }

    NamespaceRegistry namespaces() {
        return this.executionContext.getNamespaceRegistry();
    }

    void signalNamespaceChanges(boolean global) {
        this.nodeTypeManager().signalNamespaceChanges();
        if (global) {
            this.repository.getRepositoryTypeManager().signalNamespaceChanges();
        }
    }

    JcrWorkspace workspace() {
        return this.workspace;
    }

    JcrRepository repository() {
        return this.repository;
    }

    Graph.Batch createBatch() {
        return this.graph.batch();
    }

    Graph graph() {
        return this.graph;
    }

    String sourceName() {
        return this.repository.getRepositorySourceName();
    }

    Path pathFor(String path, String parameterName) throws RepositoryException {
        try {
            return (Path)this.executionContext.getValueFactories().getPathFactory().create(path);
        }
        catch (ValueFormatException vfe) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{path, parameterName}), (Throwable)vfe);
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Object getAttribute(String name) {
        return this.sessionAttributes.get(name);
    }

    public String[] getAttributeNames() {
        Set<String> names = this.sessionAttributes.keySet();
        if (names.isEmpty()) {
            return NO_ATTRIBUTES_NAMES;
        }
        return names.toArray(new String[names.size()]);
    }

    Map<String, Object> sessionAttributes() {
        return new HashMap<String, Object>(this.sessionAttributes);
    }

    public String getNamespacePrefix(String uri) throws RepositoryException {
        return this.sessionRegistry.getPrefix(uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.sessionRegistry.getPrefixes();
    }

    public String getNamespaceURI(String prefix) throws RepositoryException {
        return this.sessionRegistry.getURI(prefix);
    }

    public void setNamespacePrefix(String newPrefix, String existingUri) throws NamespaceException, RepositoryException {
        this.sessionRegistry.registerNamespace(newPrefix, existingUri);
    }

    public void addLockToken(String lt) {
        CheckArg.isNotNull((Object)lt, (String)"lock token");
        try {
            this.lockManager().addLockToken(lt);
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    final boolean hasRole(String roleName, String workspaceName) {
        SecurityContext context = this.getExecutionContext().getSecurityContext();
        if (context.hasRole(roleName)) {
            return true;
        }
        if (context.hasRole(roleName = roleName + "." + this.repository.getRepositorySourceName())) {
            return true;
        }
        roleName = roleName + "." + workspaceName;
        return context.hasRole(roleName);
    }

    public void checkPermission(String path, String actions) {
        CheckArg.isNotEmpty((String)path, (String)"path");
        this.checkPermission((Path)this.executionContext.getValueFactories().getPathFactory().create(path), actions);
    }

    void checkPermission(Path path, String actions) {
        this.checkPermission(this.workspace().getName(), path, actions);
    }

    void checkPermission(String workspaceName, Path path, String actions) {
        if (this.hasPermission(workspaceName, path, actions)) {
            return;
        }
        String pathAsString = path != null ? path.getString(this.namespaces()) : "<unknown>";
        throw new AccessControlException(JcrI18n.permissionDenied.text(new Object[]{pathAsString, actions}));
    }

    public boolean hasPermission(String path, String actions) {
        CheckArg.isNotEmpty((String)path, (String)"path");
        return this.hasPermission(this.workspace().getName(), (Path)this.executionContext.getValueFactories().getPathFactory().create(path), actions);
    }

    private boolean hasPermission(String workspaceName, Path path, String actions) {
        CheckArg.isNotEmpty((String)actions, (String)"actions");
        boolean hasPermission = true;
        for (String action : actions.split(",")) {
            if ("read".equals(action)) {
                hasPermission &= this.hasRole("readonly", workspaceName) || this.hasRole("readwrite", workspaceName) || this.hasRole("admin", workspaceName);
                continue;
            }
            if ("register_namespace".equals(action) || "register_type".equals(action) || "unlock_any".equals(action) || "create_workspace".equals(action) || "delete_workspace".equals(action)) {
                hasPermission &= this.hasRole("admin", workspaceName);
                continue;
            }
            hasPermission &= this.hasRole("admin", workspaceName) || this.hasRole("readwrite", workspaceName);
        }
        return hasPermission;
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws IllegalArgumentException, RepositoryException {
        CheckArg.isNotEmpty((String)methodName, (String)"methodName");
        CheckArg.isNotNull((Object)target, (String)"target");
        if (target instanceof AbstractJcrNode) {
            AbstractJcrNode node = (AbstractJcrNode)target;
            if ("addNode".equals(methodName)) {
                CheckArg.hasSizeOfAtLeast((Object[])arguments, (int)1, (String)"arguments");
                CheckArg.hasSizeOfAtMost((Object[])arguments, (int)2, (String)"arguments");
                CheckArg.isInstanceOf((Object)arguments[0], String.class, (String)"arguments[0]");
                String relPath = (String)arguments[0];
                String primaryNodeTypeName = null;
                if (arguments.length > 1) {
                    CheckArg.isInstanceOf((Object)arguments[1], String.class, (String)"arguments[1]");
                    primaryNodeTypeName = (String)arguments[1];
                }
                return node.canAddNode(relPath, primaryNodeTypeName);
            }
        }
        return true;
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        CheckArg.isNotNull((Object)absPath, (String)"absPath");
        CheckArg.isNotNull((Object)contentHandler, (String)"contentHandler");
        Path exportRootPath = (Path)this.executionContext.getValueFactories().getPathFactory().create(absPath);
        AbstractJcrNode exportRootNode = this.getNode(exportRootPath);
        JcrDocumentViewExporter exporter = new JcrDocumentViewExporter(this);
        exporter.exportView((Node)exportRootNode, contentHandler, skipBinary, noRecurse);
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        CheckArg.isNotNull((Object)absPath, (String)"absPath");
        CheckArg.isNotNull((Object)out, (String)"out");
        Path exportRootPath = (Path)this.executionContext.getValueFactories().getPathFactory().create(absPath);
        AbstractJcrNode exportRootNode = this.getNode(exportRootPath);
        JcrDocumentViewExporter exporter = new JcrDocumentViewExporter(this);
        exporter.exportView((Node)exportRootNode, out, skipBinary, noRecurse);
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        CheckArg.isNotNull((Object)absPath, (String)"absPath");
        CheckArg.isNotNull((Object)contentHandler, (String)"contentHandler");
        Path exportRootPath = (Path)this.executionContext.getValueFactories().getPathFactory().create(absPath);
        AbstractJcrNode exportRootNode = this.getNode(exportRootPath);
        JcrSystemViewExporter exporter = new JcrSystemViewExporter(this);
        exporter.exportView((Node)exportRootNode, contentHandler, skipBinary, noRecurse);
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        CheckArg.isNotNull((Object)absPath, (String)"absPath");
        CheckArg.isNotNull((Object)out, (String)"out");
        Path exportRootPath = (Path)this.executionContext.getValueFactories().getPathFactory().create(absPath);
        AbstractJcrNode exportRootNode = this.getNode(exportRootPath);
        JcrSystemViewExporter exporter = new JcrSystemViewExporter(this);
        exporter.exportView((Node)exportRootNode, out, skipBinary, noRecurse);
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, RepositoryException {
        Path parentPath = (Path)this.executionContext.getValueFactories().getPathFactory().create(parentAbsPath);
        return new JcrContentHandler(this, parentPath, uuidBehavior, JcrContentHandler.SaveMode.SESSION);
    }

    public Item getItem(String absolutePath) throws RepositoryException {
        CheckArg.isNotEmpty((String)absolutePath, (String)"absolutePath");
        Path path = (Path)this.executionContext.getValueFactories().getPathFactory().create(absolutePath);
        if (path.isRoot()) {
            return this.getRootNode();
        }
        if (path.isIdentifier() || path.getLastSegment().hasIndex()) {
            return this.getNode(path);
        }
        try {
            return this.cache.findJcrItem(null, this.rootPath, path.relativeTo(this.rootPath));
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractJcrNode getNode(String absolutePath) throws PathNotFoundException, RepositoryException {
        CheckArg.isNotEmpty((String)absolutePath, (String)"absolutePath");
        Path path = (Path)this.executionContext.getValueFactories().getPathFactory().create(absolutePath);
        if (path.isRoot()) {
            return this.getRootNode();
        }
        return this.getNode(path);
    }

    public boolean nodeExists(String absolutePath) throws PathNotFoundException, RepositoryException {
        CheckArg.isNotEmpty((String)absolutePath, (String)"absolutePath");
        Path path = (Path)this.executionContext.getValueFactories().getPathFactory().create(absolutePath);
        if (path.isRoot()) {
            return true;
        }
        try {
            this.cache.findJcrNode(null, path);
            return true;
        }
        catch (ItemNotFoundException e) {
            return false;
        }
    }

    public AbstractJcrProperty getProperty(String absolutePath) throws PathNotFoundException, RepositoryException {
        CheckArg.isNotEmpty((String)absolutePath, (String)"absolutePath");
        Path path = this.pathFor(absolutePath, "absolutePath");
        if (path.isRoot()) {
            throw new PathNotFoundException(JcrI18n.rootNodeIsNotProperty.text(new Object[0]));
        }
        if (path.isIdentifier()) {
            throw new PathNotFoundException(JcrI18n.identifierPathNeverReferencesProperty.text(new Object[0]));
        }
        Path.Segment lastSegment = path.getLastSegment();
        if (lastSegment.hasIndex()) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{absolutePath}));
        }
        AbstractJcrNode parentNode = this.getNode(path.getParent());
        AbstractJcrProperty property = parentNode.getProperty(lastSegment.getName());
        if (property == null) {
            throw new PathNotFoundException(GraphI18n.pathNotFoundExceptionLowestExistingLocationFound.text(new Object[]{absolutePath, parentNode.getPath()}));
        }
        return property;
    }

    public boolean propertyExists(String absolutePath) throws RepositoryException {
        CheckArg.isNotEmpty((String)absolutePath, (String)"absolutePath");
        Path path = this.pathFor(absolutePath, "absolutePath");
        if (path.isRoot() || path.isIdentifier()) {
            return false;
        }
        Path.Segment lastSegment = path.getLastSegment();
        if (lastSegment.hasIndex()) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{absolutePath}));
        }
        try {
            AbstractJcrNode parentNode = this.getNode(path.getParent());
            return parentNode.hasProperty(lastSegment.getName());
        }
        catch (PathNotFoundException pnfe) {
            return false;
        }
    }

    public void removeItem(String absolutePath) throws RepositoryException {
        Item item = this.getItem(absolutePath);
        item.remove();
    }

    public String[] getLockTokens() {
        return this.lockManager().getLockTokens();
    }

    AbstractJcrNode getNode(Path path) throws RepositoryException, PathNotFoundException {
        if (path.isRoot()) {
            return this.cache.findJcrRootNode();
        }
        try {
            if (path.isIdentifier()) {
                try {
                    UUID uuid = (UUID)this.executionContext.getValueFactories().getUuidFactory().create(path);
                    return this.cache.findJcrNode(Location.create((UUID)uuid));
                }
                catch (ValueFormatException e) {
                    String pathStr = (String)this.executionContext.getValueFactories().getStringFactory().create(path);
                    throw new PathNotFoundException(JcrI18n.identifierPathContainedUnsupportedIdentifierFormat.text(new Object[]{pathStr}));
                }
            }
            return this.cache.findJcrNode(null, path);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getMessage());
        }
    }

    public AbstractJcrNode getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        return this.cache.findJcrNode(Location.create((UUID)UUID.fromString(uuid)));
    }

    public AbstractJcrNode getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        try {
            return this.cache.findJcrNode(Location.create((UUID)UUID.fromString(id)));
        }
        catch (IllegalArgumentException e) {
            try {
                PathFactory pathFactory = this.executionContext.getValueFactories().getPathFactory();
                Path path = (Path)pathFactory.create(id);
                return this.getNode(path);
            }
            catch (ValueFormatException e2) {
                throw new RepositoryException(JcrI18n.identifierPathContainedUnsupportedIdentifierFormat.text(new Object[]{id}));
            }
        }
    }

    public AbstractJcrNode getRootNode() throws RepositoryException {
        return this.cache.findJcrRootNode();
    }

    public String getUserID() {
        return this.executionContext.getSecurityContext().getUserName();
    }

    public javax.jcr.ValueFactory getValueFactory() {
        final ValueFactories valueFactories = this.executionContext.getValueFactories();
        final SessionCache sessionCache = this.cache;
        return new javax.jcr.ValueFactory(){

            public Value createValue(String value, int propertyType) throws javax.jcr.ValueFormatException {
                return new JcrValue(valueFactories, sessionCache, propertyType, this.convertValueToType(value, propertyType));
            }

            public Value createValue(Node value) throws RepositoryException {
                if (!value.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(JcrSession.this.namespaces()))) {
                    throw new RepositoryException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
                }
                Reference ref = (Reference)valueFactories.getReferenceFactory().create(value.getIdentifier());
                return new JcrValue(valueFactories, sessionCache, 9, ref);
            }

            public Value createValue(Node value, boolean weak) throws RepositoryException {
                if (!value.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(JcrSession.this.namespaces()))) {
                    throw new RepositoryException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
                }
                ReferenceFactory factory = weak ? valueFactories.getWeakReferenceFactory() : valueFactories.getReferenceFactory();
                int refType = weak ? 10 : 9;
                Reference ref = (Reference)factory.create(value.getIdentifier());
                return new JcrValue(valueFactories, sessionCache, refType, ref);
            }

            public Value createValue(Binary value) {
                return new JcrValue(valueFactories, sessionCache, 2, value);
            }

            public Value createValue(InputStream value) {
                org.modeshape.graph.property.Binary binary = (org.modeshape.graph.property.Binary)valueFactories.getBinaryFactory().create((Object)value);
                return new JcrValue(valueFactories, sessionCache, 2, binary);
            }

            public Binary createBinary(InputStream value) {
                org.modeshape.graph.property.Binary binary = (org.modeshape.graph.property.Binary)valueFactories.getBinaryFactory().create((Object)value);
                return new JcrBinary(binary);
            }

            public Value createValue(Calendar value) {
                DateTime dateTime = (DateTime)valueFactories.getDateFactory().create(value);
                return new JcrValue(valueFactories, sessionCache, 5, dateTime);
            }

            public Value createValue(boolean value) {
                return new JcrValue(valueFactories, sessionCache, 6, value);
            }

            public Value createValue(double value) {
                return new JcrValue(valueFactories, sessionCache, 4, value);
            }

            public Value createValue(long value) {
                return new JcrValue(valueFactories, sessionCache, 3, value);
            }

            public Value createValue(String value) {
                return new JcrValue(valueFactories, sessionCache, 1, value);
            }

            public Value createValue(BigDecimal value) {
                return new JcrValue(valueFactories, sessionCache, 12, value);
            }

            Object convertValueToType(Object value, int toType) throws javax.jcr.ValueFormatException {
                switch (toType) {
                    case 6: {
                        try {
                            return valueFactories.getBooleanFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 5: {
                        try {
                            return valueFactories.getDateFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 7: {
                        try {
                            return valueFactories.getNameFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 8: {
                        try {
                            return valueFactories.getPathFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 9: 
                    case 10: {
                        try {
                            return valueFactories.getReferenceFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 4: {
                        try {
                            return valueFactories.getDoubleFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 3: {
                        try {
                            return valueFactories.getLongFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 12: {
                        try {
                            return valueFactories.getDecimalFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 11: {
                        try {
                            return valueFactories.getUriFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 2: {
                        try {
                            return valueFactories.getBinaryFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 1: {
                        try {
                            return valueFactories.getStringFactory().create(value);
                        }
                        catch (ValueFormatException vfe) {
                            throw new javax.jcr.ValueFormatException((Throwable)vfe);
                        }
                    }
                    case 0: {
                        return value;
                    }
                }
                assert (false) : "Unexpected JCR property type " + toType;
                throw new IllegalStateException("Invalid property type " + toType);
            }
        };
    }

    public boolean hasPendingChanges() {
        return this.cache.hasPendingChanges();
    }

    public Session impersonate(Credentials credentials) throws RepositoryException {
        return this.repository.login(credentials, this.workspace.getName());
    }

    JcrSession with(String workspaceName) throws RepositoryException {
        return this.repository.sessionForContext(this.executionContext, workspaceName, this.sessionAttributes);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, InvalidSerializedDataException, RepositoryException {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(this.getImportContentHandler(parentAbsPath, uuidBehavior));
            parser.parse(new InputSource(in));
        }
        catch (JcrContentHandler.EnclosingSAXException ese) {
            Exception cause = ese.getException();
            if (cause instanceof ItemExistsException) {
                throw (ItemExistsException)cause;
            }
            if (cause instanceof ConstraintViolationException) {
                throw (ConstraintViolationException)((Object)cause);
            }
            if (cause instanceof VersionException) {
                throw (VersionException)cause;
            }
            throw new RepositoryException((Throwable)cause);
        }
        catch (SAXParseException se) {
            throw new InvalidSerializedDataException((Throwable)se);
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
    }

    public boolean itemExists(String absolutePath) throws RepositoryException {
        try {
            return this.getItem(absolutePath) != null;
        }
        catch (PathNotFoundException error) {
            return false;
        }
    }

    public void logout() {
        this.terminate(true);
    }

    void terminate(boolean removeFromActiveSession) {
        if (!this.isLive()) {
            return;
        }
        this.isLive = false;
        this.workspace().observationManager().removeAllEventListeners();
        this.lockManager().cleanLocks();
        if (removeFromActiveSession) {
            this.repository.sessionLoggedOut(this);
        }
        this.executionContext.getSecurityContext().logout();
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, RepositoryException {
        Lock newParentLock;
        Lock sourceLock;
        CheckArg.isNotNull((Object)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotNull((Object)destAbsPath, (String)"destAbsPath");
        PathFactory pathFactory = this.executionContext.getValueFactories().getPathFactory();
        Path destPath = (Path)pathFactory.create(destAbsPath);
        if (destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
        }
        Path.Segment newNodeName = null;
        AbstractJcrNode sourceNode = this.getNode((Path)pathFactory.create(srcAbsPath));
        AbstractJcrNode newParentNode = null;
        if (destPath.isIdentifier()) {
            AbstractJcrNode existingDestNode = this.getNode(destPath);
            newParentNode = existingDestNode.getParent();
            newNodeName = existingDestNode.segment();
        } else {
            newParentNode = this.getNode(destPath.getParent());
            newNodeName = destPath.getSegment(destPath.size() - 1);
        }
        if (sourceNode.isLocked() && !sourceNode.getLock().isLockOwningSession() && (sourceLock = sourceNode.getLock()) != null && sourceLock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{srcAbsPath}));
        }
        if (newParentNode.isLocked() && !newParentNode.getLock().isLockOwningSession() && (newParentLock = newParentNode.getLock()) != null && newParentLock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{destAbsPath}));
        }
        if (!sourceNode.getParent().isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{sourceNode.getPath()}));
        }
        if (!newParentNode.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{newParentNode.getPath()}));
        }
        newParentNode.editor().moveToBeChild(sourceNode, newNodeName.getName());
    }

    public void refresh(boolean keepChanges) {
        this.cache.refresh(keepChanges);
    }

    public void removeLockToken(String lockToken) {
        CheckArg.isNotNull((Object)lockToken, (String)"lock token");
        try {
            this.lockManager().removeLockToken(lockToken);
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    void recordRemoval(Location location) throws RepositoryException {
        if (!this.performReferentialIntegrityChecks) {
            return;
        }
        if (this.removedNodes == null) {
            this.removedNodes = new HashSet<Location>();
            this.removedReferenceableNodeUuids = new HashSet<String>();
        }
        Path path = location.getPath();
        ValueFactory stringFactory = this.executionContext.getValueFactories().getStringFactory();
        String pathStr = (String)stringFactory.create(path);
        int sns = path.getLastSegment().getIndex();
        if (sns == 1) {
            pathStr = pathStr + "[1]";
        }
        TypeSystem typeSystem = this.executionContext.getValueFactories().getTypeSystem();
        QueryBuilder builder = new QueryBuilder(typeSystem);
        QueryCommand query = builder.select(new String[]{"jcr:uuid"}).from("mix:referenceable AS referenceable").where().path("referenceable").isLike((Object)(pathStr + "%")).end().query();
        JcrQueryManager queryManager = this.workspace().queryManager();
        Query jcrQuery = queryManager.createQuery(query);
        QueryResult result = jcrQuery.execute();
        RowIterator rows = result.getRows();
        while (rows.hasNext()) {
            Row row = rows.nextRow();
            String uuid = row.getValue("jcr:uuid").getString();
            if (uuid == null) continue;
            this.removedReferenceableNodeUuids.add(uuid);
        }
        HashSet<Location> extras = null;
        for (Location alreadyDeleted : this.removedNodes) {
            Path alreadyDeletedPath = alreadyDeleted.getPath();
            if (alreadyDeletedPath.isAtOrAbove(path)) {
                return;
            }
            if (!alreadyDeletedPath.isDecendantOf(path)) continue;
            if (extras == null) {
                extras = new HashSet<Location>();
            }
            extras.add(alreadyDeleted);
        }
        this.removedNodes.add(location);
        if (extras != null) {
            this.removedNodes.removeAll(extras);
        }
    }

    boolean wasRemovedInSession(Location location) {
        if (this.removedNodes == null) {
            return false;
        }
        if (this.removedNodes.contains(location)) {
            return true;
        }
        Path path = location.getPath();
        for (Location removed : this.removedNodes) {
            if (!removed.getPath().isAtOrAbove(path)) continue;
            return true;
        }
        return false;
    }

    boolean wasRemovedInSession(UUID uuid) {
        if (this.removedReferenceableNodeUuids == null) {
            return false;
        }
        return this.removedReferenceableNodeUuids.contains(uuid);
    }

    void checkReferentialIntegrityOfChanges(AbstractJcrNode subgraphRoot) throws ReferentialIntegrityException, RepositoryException {
        if (this.removedNodes == null) {
            return;
        }
        if (this.removedReferenceableNodeUuids.isEmpty()) {
            return;
        }
        if (this.removedNodes.size() == 1 && this.removedNodes.iterator().next().getPath().isRoot()) {
            return;
        }
        String subgraphPath = null;
        if (subgraphRoot != null) {
            subgraphPath = subgraphRoot.getPath();
            if (subgraphRoot.getIndex() == 1) {
                subgraphPath = subgraphPath + "[1]";
            }
        }
        int maxBatchSize = 100;
        HashSet<String> someUuidsInBranch = new HashSet<String>();
        Iterator<String> uuidIter = this.removedReferenceableNodeUuids.iterator();
        while (uuidIter.hasNext()) {
            while (uuidIter.hasNext() && someUuidsInBranch.size() <= maxBatchSize) {
                String uuid = uuidIter.next();
                someUuidsInBranch.add(uuid);
            }
            assert (!someUuidsInBranch.isEmpty());
            TypeSystem typeSystem = this.executionContext.getValueFactories().getTypeSystem();
            QueryBuilder builder = new QueryBuilder(typeSystem);
            QueryCommand query = null;
            query = subgraphPath != null ? builder.select(new String[]{"jcr:primaryType"}).fromAllNodesAs("allNodes").where().strongReferenceValue("allNodes").isIn(someUuidsInBranch).and().path("allNodes").isLike((Object)(subgraphPath + "%")).end().query() : builder.select(new String[]{"jcr:primaryType"}).fromAllNodesAs("allNodes").where().strongReferenceValue("allNodes").isIn(someUuidsInBranch).end().query();
            Query jcrQuery = this.workspace().queryManager().createQuery(query);
            QueryResult result = jcrQuery.execute();
            NodeIterator referencingNodes = result.getNodes();
            while (referencingNodes.hasNext()) {
                AbstractJcrNode referencingNode = (AbstractJcrNode)referencingNodes.nextNode();
                if (!referencingNode.nodeInfo().isChanged(false)) {
                    throw new ReferentialIntegrityException();
                }
                PropertyIterator propIter = referencingNode.getProperties();
                while (propIter.hasNext()) {
                    Property property = propIter.nextProperty();
                    if (property.getType() != 9) {
                        return;
                    }
                    if (property.isMultiple()) {
                        for (Value value : property.getValues()) {
                            String referencedUuid = value.getString();
                            if (!this.removedReferenceableNodeUuids.contains(referencedUuid)) continue;
                            throw new ReferentialIntegrityException();
                        }
                        continue;
                    }
                    String referencedUuid = property.getValue().getString();
                    if (!this.removedReferenceableNodeUuids.contains(referencedUuid)) continue;
                    throw new ReferentialIntegrityException();
                }
            }
            someUuidsInBranch.clear();
        }
    }

    public void save() throws RepositoryException {
        this.checkReferentialIntegrityOfChanges(null);
        this.removedNodes = null;
        this.cache.save();
    }

    public void reindexContent() {
        this.repository().queryManager().reindexContent(this.workspace());
    }

    public void reindexContent(String path, int depth) {
        this.repository().queryManager().reindexContent(this.workspace(), path, depth);
    }

    public Snapshot getSnapshot() {
        return new Snapshot((GraphSession.StructureSnapshot<SessionCache.JcrPropertyPayload>)this.cache.graphSession().getRoot().getSnapshot(false));
    }

    public String toString() {
        return this.getSnapshot().toString();
    }

    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Immutable
    public class Snapshot {
        private final GraphSession.StructureSnapshot<SessionCache.JcrPropertyPayload> rootSnapshot;

        protected Snapshot(GraphSession.StructureSnapshot<SessionCache.JcrPropertyPayload> snapshot) {
            this.rootSnapshot = snapshot;
        }

        public String toString() {
            return this.rootSnapshot.toString();
        }
    }
}

