/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.lang.ref.SoftReference;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.graph.session.InvalidStateException;
import org.modeshape.graph.session.ValidationException;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrMultiValueProperty;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSingleValueProperty;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.ModeShapeIntLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.PropertyTypeUtil;

@ThreadSafe
class SessionCache {
    protected static final boolean INCLUDE_PROPERTIES_NOT_ALLOWED_BY_NODE_TYPE_OR_MIXINS = true;
    protected static final Set<Name> EMPTY_NAMES = Collections.emptySet();
    private final JcrSession session;
    private final String workspaceName;
    protected final ExecutionContext context;
    protected final ValueFactories factories;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final ValueFactory<String> stringFactory;
    protected final NamespaceRegistry namespaces;
    protected final PropertyFactory propertyFactory;
    private final Graph store;
    protected final Name defaultPrimaryTypeName;
    protected final Property defaultPrimaryTypeProperty;
    protected final Path rootPath;
    protected final Name residualName;
    private final GraphSession<JcrNodePayload, JcrPropertyPayload> graphSession;

    public SessionCache(JcrSession session) {
        this(session, session.workspace().getName(), session.getExecutionContext(), session.nodeTypeManager(), session.graph());
    }

    public SessionCache(JcrSession session, String workspaceName, ExecutionContext context, JcrNodeTypeManager nodeTypes, Graph store) {
        assert (session != null);
        assert (workspaceName != null);
        assert (context != null);
        assert (store != null);
        this.session = session;
        this.workspaceName = workspaceName;
        this.store = store;
        this.context = context;
        this.factories = context.getValueFactories();
        this.pathFactory = this.factories.getPathFactory();
        this.nameFactory = this.factories.getNameFactory();
        this.stringFactory = context.getValueFactories().getStringFactory();
        this.namespaces = context.getNamespaceRegistry();
        this.propertyFactory = context.getPropertyFactory();
        this.defaultPrimaryTypeName = JcrNtLexicon.UNSTRUCTURED;
        this.defaultPrimaryTypeProperty = this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{this.defaultPrimaryTypeName});
        this.rootPath = this.pathFactory.createRootPath();
        this.residualName = (Name)this.nameFactory.create("*");
        this.graphSession = new GraphSession(this.store, this.workspaceName, (GraphSession.Operations)new JcrNodeOperations(), (GraphSession.Authorizer)new JcrAuthorizer());
        try {
            int depth = Integer.parseInt(session.repository().getOptions().get((Object)JcrRepository.Option.READ_DEPTH));
            if (depth > 0) {
                this.graphSession.setDepthForLoadingNodes(depth);
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    final GraphSession<JcrNodePayload, JcrPropertyPayload> graphSession() {
        return this.graphSession;
    }

    JcrSession session() {
        return this.session;
    }

    String workspaceName() {
        return this.workspaceName;
    }

    String sourceName() {
        return this.store.getSourceName();
    }

    ExecutionContext context() {
        return this.context;
    }

    ValueFactories factories() {
        return this.factories;
    }

    PathFactory pathFactory() {
        return this.pathFactory;
    }

    NameFactory nameFactory() {
        return this.nameFactory;
    }

    ValueFactory<String> stringFactory() {
        return this.factories.getStringFactory();
    }

    JcrNodeTypeManager nodeTypes() {
        return this.session.nodeTypeManager();
    }

    final String readable(Name name) {
        return name.getString(this.namespaces);
    }

    final String readable(Path.Segment segment) {
        return segment.getString(this.namespaces);
    }

    final String readable(Path path) {
        return path.getString(this.namespaces);
    }

    final String readable(Location location) {
        return location.getString(this.namespaces);
    }

    final String readable(Iterable<Name> names) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (Name name : names) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(name.getString(this.namespaces));
        }
        sb.append(']');
        return sb.toString();
    }

    boolean hasPendingChanges() {
        return this.graphSession.hasPendingChanges();
    }

    public void refresh(boolean keepChanges) {
        this.graphSession.refresh(keepChanges);
    }

    public void refresh(GraphSession.NodeId nodeId, Path absolutePath, boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        assert (nodeId != null);
        try {
            GraphSession.Node node = this.graphSession.findNodeWith(nodeId, absolutePath);
            this.graphSession.refresh(node, keepChanges);
        }
        catch (InvalidStateException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage());
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage());
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage());
        }
    }

    protected JcrNodeDefinition findBestNodeDefinition(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> parent, Name newNodeName, Name newNodePrimaryTypeName) throws ItemExistsException, ConstraintViolationException, RepositoryException {
        assert (parent != null);
        assert (newNodeName != null);
        Name primaryTypeName = ((JcrNodePayload)parent.getPayload()).getPrimaryTypeName();
        List<Name> mixinTypeNames = ((JcrNodePayload)parent.getPayload()).getMixinTypeNames();
        int snsCount = parent.getChildrenCount(newNodeName) + 1;
        JcrNodeDefinition definition = this.nodeTypes().findChildNodeDefinition(primaryTypeName, mixinTypeNames, newNodeName, newNodePrimaryTypeName, snsCount, true);
        if (definition == null) {
            if (snsCount > 1 && (definition = this.nodeTypes().findChildNodeDefinition(primaryTypeName, mixinTypeNames, newNodeName, newNodePrimaryTypeName, 1, true)) != null) {
                throw new ItemExistsException(JcrI18n.noSnsDefinition.text(new Object[]{this.readable(newNodeName), this.readable(parent.getPath()), this.readable(primaryTypeName), this.readable(mixinTypeNames)}));
            }
            throw new ConstraintViolationException(JcrI18n.noDefinition.text(new Object[]{"child node", this.readable(newNodeName), this.readable(parent.getPath()), this.readable(primaryTypeName), this.readable(mixinTypeNames)}));
        }
        return definition;
    }

    public void save() throws ItemNotFoundException, AccessDeniedException, ConstraintViolationException, RepositoryException {
        try {
            this.graphSession.save();
        }
        catch (ValidationException e) {
            throw new ConstraintViolationException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidStateException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public void save(GraphSession.NodeId nodeId, Path absolutePath) throws ItemNotFoundException, AccessDeniedException, ConstraintViolationException, RepositoryException {
        assert (nodeId != null);
        try {
            GraphSession.Node node = this.graphSession.findNodeWith(nodeId, absolutePath);
            assert (node != null);
            this.graphSession.save(node);
        }
        catch (ValidationException e) {
            throw new ConstraintViolationException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvalidStateException e) {
            throw new InvalidItemStateException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public GraphSession.Node<JcrNodePayload, JcrPropertyPayload> findNode(GraphSession.NodeId id, Path absolutePath) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        try {
            return this.graphSession.findNodeWith(id, absolutePath);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public GraphSession.Node<JcrNodePayload, JcrPropertyPayload> findNode(GraphSession.NodeId from, Path fromAbsolutePath, Path relativePath) throws PathNotFoundException, ItemNotFoundException, AccessDeniedException, RepositoryException {
        GraphSession.Node<JcrNodePayload, JcrPropertyPayload> referenceNode = this.findNode(from, fromAbsolutePath);
        try {
            return this.graphSession.findNodeRelativeTo(referenceNode, relativePath);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrRootNode findJcrRootNode() throws RepositoryException {
        return (JcrRootNode)((JcrNodePayload)this.graphSession.getRoot().getPayload()).getJcrNode();
    }

    public AbstractJcrNode findJcrNode(Location location) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        try {
            return ((JcrNodePayload)this.graphSession.findNodeWith(location).getPayload()).getJcrNode();
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractJcrNode findJcrNode(GraphSession.NodeId id, Path absolutePath) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return ((JcrNodePayload)this.findNode(id, absolutePath).getPayload()).getJcrNode();
    }

    public AbstractJcrNode findJcrNode(GraphSession.NodeId from, Path fromAbsolutePath, Path relativePath) throws ItemNotFoundException, PathNotFoundException, InvalidItemStateException, AccessDeniedException, RepositoryException {
        GraphSession.Node<JcrNodePayload, JcrPropertyPayload> referenceNode = this.findNode(from, fromAbsolutePath);
        try {
            return ((JcrNodePayload)this.graphSession.findNodeRelativeTo(referenceNode, relativePath).getPayload()).getJcrNode();
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractJcrProperty findJcrProperty(GraphSession.NodeId id, Path absolutePath, Name propertyName) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node = this.findNode(id, absolutePath);
        GraphSession.PropertyInfo propertyInfo = node.getProperty(propertyName);
        if (propertyInfo != null) {
            if (propertyName.equals(JcrLexicon.UUID) && !this.isReferenceable(node)) {
                return null;
            }
            return ((JcrPropertyPayload)propertyInfo.getPayload()).getJcrProperty();
        }
        return null;
    }

    public Collection<AbstractJcrProperty> findJcrPropertiesFor(GraphSession.NodeId id, Path absolutePath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        try {
            GraphSession.Node node = this.graphSession.findNodeWith(id, absolutePath);
            ArrayList<AbstractJcrProperty> result = new ArrayList<AbstractJcrProperty>(node.getPropertyCount());
            for (GraphSession.PropertyInfo property : node.getProperties()) {
                AbstractJcrProperty prop;
                Name propertyName = property.getName();
                if (propertyName.equals(JcrLexicon.UUID) && !this.isReferenceable((GraphSession.Node<JcrNodePayload, JcrPropertyPayload>)node) || propertyName.getNamespaceUri().equals("http://www.modeshape.org/internal/1.0") || (prop = ((JcrPropertyPayload)property.getPayload()).getJcrProperty()) == null) continue;
                result.add(prop);
            }
            return result;
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractJcrItem findJcrItem(GraphSession.NodeId from, Path fromAbsolutePath, Path relativePath) throws ItemNotFoundException, InvalidItemStateException, RepositoryException {
        Path.Segment lastSegment;
        if (from == null && fromAbsolutePath == null) {
            from = this.graphSession.getRoot().getNodeId();
        }
        if (relativePath.size() == 0) {
            return this.findJcrNode(from, fromAbsolutePath);
        }
        if (relativePath.size() == 1) {
            Path.Segment segment = relativePath.getLastSegment();
            if (segment.isSelfReference()) {
                return this.findJcrNode(from, fromAbsolutePath);
            }
            if (segment.isParentReference()) {
                return this.findJcrNode(from, fromAbsolutePath, relativePath);
            }
        }
        if ((lastSegment = relativePath.getLastSegment()).getIndex() > 1) {
            return this.findJcrNode(from, fromAbsolutePath);
        }
        GraphSession.Node fromNode = null;
        GraphSession.Node parent = null;
        try {
            fromNode = this.graphSession.findNodeWith(from, fromAbsolutePath);
            if (from == null) {
                from = fromNode.getNodeId();
            }
            assert (from != null);
            parent = relativePath.size() == 1 ? fromNode : this.graphSession.findNodeRelativeTo(fromNode, relativePath.getParent());
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
        if (parent.hasChild(lastSegment)) {
            GraphSession.Node child = parent.getChild(lastSegment);
            return ((JcrNodePayload)child.getPayload()).getJcrNode();
        }
        GraphSession.PropertyInfo propertyInfo = parent.getProperty(lastSegment.getName());
        if (propertyInfo != null) {
            return ((JcrPropertyPayload)propertyInfo.getPayload()).getJcrProperty();
        }
        String msg = null;
        if (from.equals((Object)this.graphSession.getRoot().getNodeId())) {
            Path absolutePath = this.rootPath.resolve(relativePath);
            msg = JcrI18n.itemNotFoundAtPath.text(new Object[]{this.readable(absolutePath), this.workspaceName});
        } else {
            Path referenceNodePath = fromNode.getPath();
            msg = JcrI18n.itemNotFoundAtPathRelativeToReferenceNode.text(new Object[]{this.readable(relativePath), this.readable(referenceNodePath), this.workspaceName});
        }
        throw new ItemNotFoundException(msg);
    }

    public final boolean isNodeType(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name nodeType) throws RepositoryException {
        Name primaryTypeName = ((JcrNodePayload)node.getPayload()).getPrimaryTypeName();
        JcrNodeType primaryType = this.nodeTypes().getNodeType(primaryTypeName);
        if (primaryType.isNodeType(nodeType)) {
            return true;
        }
        JcrNodeTypeManager nodeTypes = this.session().nodeTypeManager();
        for (Name mixinTypeName : ((JcrNodePayload)node.getPayload()).getMixinTypeNames()) {
            JcrNodeType mixinType = nodeTypes.getNodeType(mixinTypeName);
            if (mixinType == null || !mixinType.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    public boolean isReferenceable(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) throws RepositoryException {
        return this.isNodeType(node, JcrMixLexicon.REFERENCEABLE);
    }

    public boolean isVersionable(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) throws RepositoryException {
        return this.isNodeType(node, JcrMixLexicon.VERSIONABLE);
    }

    public NodeEditor getEditorFor(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
        return new NodeEditor(node);
    }

    public NodeEditor getEditorFor(GraphSession.NodeId id, Path absolutePath) throws ItemNotFoundException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        GraphSession.Node node = this.graphSession.findNodeWith(id, absolutePath);
        return new NodeEditor((GraphSession.Node<JcrNodePayload, JcrPropertyPayload>)node);
    }

    Path getPathForCorrespondingNode(String workspaceName, UUID uuid, Path relativePath) throws NoSuchWorkspaceException, AccessDeniedException, ItemNotFoundException, RepositoryException {
        assert (workspaceName != null);
        assert (uuid != null || relativePath != null);
        try {
            Node node;
            try {
                this.store.useWorkspace(workspaceName);
            }
            catch (InvalidWorkspaceException iwe) {
                throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.store.getSourceName(), workspaceName}));
            }
            if (uuid != null) {
                node = this.store.getNodeAt(uuid);
                if (relativePath != null) {
                    Path nodePath = node.getLocation().getPath();
                    Path absolutePath = relativePath.resolveAgainst(nodePath);
                    node = this.store.getNodeAt(absolutePath);
                }
            } else {
                Path absolutePath = this.pathFactory.createAbsolutePath((Iterable)relativePath.getSegmentsList());
                node = this.store.getNodeAt(absolutePath);
            }
            assert (node != null);
            Path path = node.getLocation().getPath();
            try {
                this.session().checkPermission(workspaceName, path, "read");
            }
            catch (AccessControlException ace) {
                throw new AccessDeniedException((Throwable)ace);
            }
            Path path2 = path;
            return path2;
        }
        catch (org.modeshape.graph.property.PathNotFoundException pnfe) {
            throw new ItemNotFoundException((Throwable)pnfe);
        }
        finally {
            this.store.useWorkspace(this.workspaceName);
        }
    }

    protected JcrPropertyDefinition findBestPropertyDefintion(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Property dnaProperty, int propertyType, boolean isSingle, boolean skipProtected) {
        JcrPropertyDefinition definition = null;
        if (propertyType == 0) {
            propertyType = PropertyTypeUtil.jcrPropertyTypeFor(dnaProperty);
        }
        if (isSingle) {
            Object value = dnaProperty.getFirstValue();
            JcrValue jcrValue = new JcrValue(this.factories(), this, propertyType, value);
            definition = this.nodeTypes().findPropertyDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, dnaProperty.getName(), jcrValue, true, skipProtected);
        } else {
            Value[] jcrValues = new Value[dnaProperty.size()];
            int index = 0;
            for (Object value : dnaProperty) {
                jcrValues[index++] = new JcrValue(this.factories(), this, propertyType, value);
            }
            definition = this.nodeTypes().findPropertyDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, dnaProperty.getName(), jcrValues, skipProtected);
        }
        if (definition != null) {
            return definition;
        }
        return null;
    }

    protected final void updateSingleMultipleProperty(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name singleMultiPropertyName, boolean add) {
        GraphSession.PropertyInfo existing = node.getProperty(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES);
        Set<Object> singleMultiPropertyNames = null;
        if (existing != null) {
            singleMultiPropertyNames = new HashSet();
            for (Object value : existing.getProperty()) {
                singleMultiPropertyNames.add(this.nameFactory().create(value));
            }
            if (add) {
                singleMultiPropertyNames.add(singleMultiPropertyName);
            } else {
                singleMultiPropertyNames.remove(singleMultiPropertyName);
            }
        } else if (add) {
            singleMultiPropertyNames = Collections.singleton(singleMultiPropertyName);
        } else {
            return;
        }
        if (singleMultiPropertyNames.isEmpty()) {
            assert (existing != null);
            node.removeProperty(existing.getName());
            return;
        }
        GraphSession.PropertyInfo<JcrPropertyPayload> property = this.createSingleMultipleProperty((JcrNodePayload)node.getPayload(), (GraphSession.PropertyInfo<JcrPropertyPayload>)existing, singleMultiPropertyNames);
        node.setProperty(property.getProperty(), property.isMultiValued(), property.getPayload());
    }

    protected GraphSession.PropertyInfo<JcrPropertyPayload> createSingleMultipleProperty(JcrNodePayload nodePayload, GraphSession.PropertyInfo<JcrPropertyPayload> existing, Set<Name> singleMultiPropertyNames) {
        int number = singleMultiPropertyNames.size();
        String[] names = new String[number];
        Value[] values = new JcrValue[number];
        if (number == 1) {
            String str;
            names[0] = str = singleMultiPropertyNames.iterator().next().getString(this.namespaces);
            values[0] = new JcrValue(this.factories(), this, 1, str);
        } else {
            int index = 0;
            for (Name name : singleMultiPropertyNames) {
                String str;
                names[index] = str = name.getString(this.namespaces);
                values[index] = new JcrValue(this.factories(), this, 1, str);
                ++index;
            }
        }
        JcrPropertyDefinition definition = this.nodeTypes().findPropertyDefinition(nodePayload.getPrimaryTypeName(), nodePayload.getMixinTypeNames(), ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES, values, false);
        Property dnaProp = this.propertyFactory.create(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES, singleMultiPropertyNames.iterator());
        return this.createPropertyInfo(nodePayload, dnaProp, definition, 1, existing);
    }

    protected final GraphSession.PropertyInfo<JcrPropertyPayload> createPropertyInfo(JcrNodePayload nodePayload, Property dnaProp, JcrPropertyDefinition definition, int propertyType, GraphSession.PropertyInfo<JcrPropertyPayload> existing) {
        AbstractJcrProperty jcrProp = null;
        if (existing != null && existing.getPayload() != null) {
            jcrProp = ((JcrPropertyPayload)existing.getPayload()).getJcrProperty();
        } else {
            AbstractJcrNode jcrNode = nodePayload.getJcrNode();
            jcrProp = definition.isMultiple() ? new JcrMultiValueProperty(this, jcrNode, dnaProp.getName()) : new JcrSingleValueProperty(this, jcrNode, dnaProp.getName());
        }
        assert (jcrProp != null);
        JcrPropertyPayload propPayload = new JcrPropertyPayload(definition.getId(), propertyType, jcrProp);
        GraphSession.Status status = existing != null ? GraphSession.Status.CHANGED : GraphSession.Status.NEW;
        return new GraphSession.PropertyInfo(dnaProp, definition.isMultiple(), status, (Object)propPayload);
    }

    @Immutable
    static final class JcrNodePayload {
        private final SessionCache cache;
        private final GraphSession.Node<JcrNodePayload, JcrPropertyPayload> owner;
        private final Name primaryTypeName;
        private final List<Name> mixinTypeNames;
        private final NodeDefinitionId nodeDefinitionId;
        private SoftReference<AbstractJcrNode> jcrNode;

        JcrNodePayload(SessionCache cache, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> owner, Name primaryTypeName, List<Name> mixinTypeNames, NodeDefinitionId nodeDefinitionId) {
            assert (owner != null);
            assert (cache != null);
            this.cache = cache;
            this.owner = owner;
            this.primaryTypeName = primaryTypeName;
            this.mixinTypeNames = mixinTypeNames;
            this.nodeDefinitionId = nodeDefinitionId;
            this.jcrNode = new SoftReference<Object>(null);
        }

        JcrNodePayload(SessionCache cache, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> owner, Name primaryTypeName, List<Name> mixinTypeNames, NodeDefinitionId nodeDefinitionId, SoftReference<AbstractJcrNode> jcrNode) {
            assert (jcrNode != null);
            assert (owner != null);
            assert (cache != null);
            this.cache = cache;
            this.owner = owner;
            this.primaryTypeName = primaryTypeName;
            this.mixinTypeNames = mixinTypeNames;
            this.nodeDefinitionId = nodeDefinitionId;
            this.jcrNode = jcrNode;
        }

        public Name getPrimaryTypeName() {
            return this.primaryTypeName;
        }

        public List<Name> getMixinTypeNames() {
            return this.mixinTypeNames != null ? this.mixinTypeNames : Collections.emptyList();
        }

        public NodeDefinitionId getDefinitionId() {
            return this.nodeDefinitionId;
        }

        public AbstractJcrNode getJcrNode() {
            AbstractJcrNode node = this.jcrNode.get();
            if (node == null) {
                node = this.owner.isRoot() ? new JcrRootNode(this.cache, this.owner.getNodeId(), this.owner.getLocation()) : new JcrNode(this.cache, this.owner.getNodeId(), this.owner.getLocation());
                this.jcrNode = new SoftReference<AbstractJcrNode>(node);
            }
            if (JcrNtLexicon.VERSION.equals(this.primaryTypeName)) {
                return new JcrVersionNode(this.jcrNode.get());
            }
            if (JcrNtLexicon.VERSION_HISTORY.equals(this.primaryTypeName)) {
                return new JcrVersionHistoryNode(this.jcrNode.get());
            }
            return this.jcrNode.get();
        }

        public JcrNodePayload with(Name primaryTypeName) {
            return new JcrNodePayload(this.cache, this.owner, primaryTypeName, this.mixinTypeNames, this.nodeDefinitionId, this.jcrNode);
        }

        public JcrNodePayload with(List<Name> mixinTypeNames) {
            return new JcrNodePayload(this.cache, this.owner, this.primaryTypeName, mixinTypeNames, this.nodeDefinitionId, this.jcrNode);
        }

        public JcrNodePayload with(NodeDefinitionId nodeDefinitionId) {
            return new JcrNodePayload(this.cache, this.owner, this.primaryTypeName, this.mixinTypeNames, nodeDefinitionId, this.jcrNode);
        }

        public JcrNodePayload with(AbstractJcrNode jcrNode) {
            return new JcrNodePayload(this.cache, this.owner, this.primaryTypeName, this.mixinTypeNames, this.nodeDefinitionId, new SoftReference<AbstractJcrNode>(jcrNode));
        }
    }

    @Immutable
    static final class JcrPropertyPayload {
        private final PropertyDefinitionId propertyDefinitionId;
        private final int jcrPropertyType;
        private final AbstractJcrProperty jcrProperty;

        JcrPropertyPayload(PropertyDefinitionId propertyDefinitionId, int jcrPropertyType, AbstractJcrProperty jcrProperty) {
            assert (jcrProperty != null);
            this.propertyDefinitionId = propertyDefinitionId;
            this.jcrPropertyType = jcrPropertyType;
            this.jcrProperty = jcrProperty;
        }

        public AbstractJcrProperty getJcrProperty() {
            return this.jcrProperty;
        }

        public int getPropertyType() {
            return this.jcrPropertyType;
        }

        public PropertyDefinitionId getPropertyDefinitionId() {
            return this.propertyDefinitionId;
        }

        public JcrPropertyPayload with(PropertyDefinitionId propertyDefinitionId) {
            return new JcrPropertyPayload(propertyDefinitionId, this.jcrPropertyType, this.jcrProperty);
        }

        public JcrPropertyPayload with(int jcrPropertyType) {
            return new JcrPropertyPayload(this.propertyDefinitionId, jcrPropertyType, this.jcrProperty);
        }

        public JcrPropertyPayload with(AbstractJcrProperty jcrProperty) {
            return new JcrPropertyPayload(this.propertyDefinitionId, this.jcrPropertyType, jcrProperty);
        }
    }

    @Immutable
    final class JcrAuthorizer
    implements GraphSession.Authorizer {
        JcrAuthorizer() {
        }

        public void checkPermissions(Path path, GraphSession.Authorizer.Action action) throws AccessControlException {
            String jcrAction = null;
            switch (action) {
                case ADD_NODE: {
                    jcrAction = "add_node";
                    break;
                }
                case READ: {
                    jcrAction = "read";
                    break;
                }
                case REMOVE: {
                    jcrAction = "remove";
                    break;
                }
                case SET_PROPERTY: {
                    jcrAction = "set_property";
                }
            }
            SessionCache.this.session().checkPermission(path, jcrAction);
        }
    }

    @Immutable
    final class JcrNodeOperations
    extends GraphSession.NodeOperations<JcrNodePayload, JcrPropertyPayload> {
        private final Logger LOGGER = Logger.getLogger(JcrNodeOperations.class);

        JcrNodeOperations() {
        }

        public void materialize(Node persistentNode, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
            Location location = node.getLocation();
            UUID uuid = location.getUuid();
            Property uuidProperty = null;
            if (uuid != null && (uuidProperty = location.getIdProperty(JcrLexicon.UUID)) == null) {
                uuidProperty = SessionCache.this.propertyFactory.create(JcrLexicon.UUID, new Object[]{uuid});
            }
            if (uuid != null && uuidProperty == null) {
                uuidProperty = SessionCache.this.propertyFactory.create(JcrLexicon.UUID, new Object[]{uuid});
            }
            HashMap<Name, Property> graphProperties = persistentNode.getPropertiesByName();
            boolean isRoot = location.getPath().isRoot();
            Name primaryTypeName = null;
            Property primaryTypeProperty = (Property)graphProperties.get(JcrLexicon.PRIMARY_TYPE);
            if (primaryTypeProperty != null && !primaryTypeProperty.isEmpty()) {
                try {
                    primaryTypeName = (Name)SessionCache.this.factories.getNameFactory().create(primaryTypeProperty.getFirstValue());
                }
                catch (ValueFormatException e) {
                    // empty catch block
                }
            }
            if (primaryTypeName == null) {
                if (isRoot) {
                    primaryTypeName = ModeShapeLexicon.ROOT;
                    primaryTypeProperty = SessionCache.this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{primaryTypeName});
                } else {
                    primaryTypeName = SessionCache.this.defaultPrimaryTypeName;
                    primaryTypeProperty = SessionCache.this.defaultPrimaryTypeProperty;
                }
                graphProperties = new HashMap<Name, Property>(graphProperties);
                graphProperties.put(primaryTypeProperty.getName(), primaryTypeProperty);
            }
            assert (primaryTypeProperty != null);
            assert (!primaryTypeProperty.isEmpty());
            JcrNodeDefinition definition = null;
            Property nodeDefnProperty = (Property)graphProperties.get(ModeShapeIntLexicon.NODE_DEFINITON);
            if (nodeDefnProperty != null && !nodeDefnProperty.isEmpty()) {
                String nodeDefinitionString = (String)SessionCache.this.stringFactory.create(nodeDefnProperty.getFirstValue());
                NodeDefinitionId id = NodeDefinitionId.fromString(nodeDefinitionString, SessionCache.this.nameFactory);
                definition = SessionCache.this.nodeTypes().getNodeDefinition(id);
            }
            if (definition == null) {
                if (isRoot) {
                    try {
                        definition = SessionCache.this.nodeTypes().getRootNodeDefinition();
                    }
                    catch (RepositoryException e) {
                        throw new ValidationException(e.getMessage(), (Throwable)e);
                    }
                } else {
                    Name childName = node.getName();
                    GraphSession.Node parent = node.getParent();
                    JcrNodePayload parentInfo = (JcrNodePayload)parent.getPayload();
                    int numExistingChildrenWithSameName = parent.getChildrenCount(childName);
                    definition = SessionCache.this.nodeTypes().findChildNodeDefinition(parentInfo.getPrimaryTypeName(), parentInfo.getMixinTypeNames(), childName, primaryTypeName, --numExistingChildrenWithSameName, false);
                }
            }
            if (definition == null) {
                String msg = JcrI18n.nodeDefinitionCouldNotBeDeterminedForNode.text(new Object[]{SessionCache.this.readable(node.getPath()), SessionCache.this.workspaceName(), SessionCache.this.sourceName()});
                throw new ValidationException(msg);
            }
            boolean referenceable = false;
            JcrNodeType primaryType = SessionCache.this.nodeTypes().getNodeType(primaryTypeName);
            if (primaryType == null) {
                Path path = location.getPath();
                String msg = JcrI18n.missingNodeTypeForExistingNode.text(new Object[]{SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(path), SessionCache.this.workspaceName(), SessionCache.this.sourceName()});
                throw new ValidationException(msg);
            }
            if (primaryType.isNodeType(JcrMixLexicon.REFERENCEABLE)) {
                referenceable = true;
            }
            Property mixinTypesProperty = (Property)graphProperties.get(JcrLexicon.MIXIN_TYPES);
            LinkedList<Name> mixinTypeNames = null;
            if (mixinTypesProperty != null && !mixinTypesProperty.isEmpty()) {
                for (Object mixinTypeValue : mixinTypesProperty) {
                    Name mixinTypeName = (Name)SessionCache.this.nameFactory.create(mixinTypeValue);
                    if (mixinTypeNames == null) {
                        mixinTypeNames = new LinkedList<Name>();
                    }
                    mixinTypeNames.add(mixinTypeName);
                    JcrNodeType mixinType = SessionCache.this.nodeTypes().getNodeType(mixinTypeName);
                    if (mixinType == null || referenceable || !mixinType.isNodeType(JcrMixLexicon.REFERENCEABLE)) continue;
                    referenceable = true;
                }
            }
            Set<Name> multiValuedPropertyNames = EMPTY_NAMES;
            HashSet<Name> newSingleMultiPropertyNames = null;
            Property multiValuedPropNamesProp = (Property)graphProperties.get(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES);
            if (multiValuedPropNamesProp != null && !multiValuedPropNamesProp.isEmpty()) {
                multiValuedPropertyNames = this.getSingleMultiPropertyNames(multiValuedPropNamesProp, location);
            }
            JcrNodePayload nodePayload = new JcrNodePayload(SessionCache.this, node, primaryTypeName, mixinTypeNames, definition.getId());
            AbstractJcrNode jcrNode = nodePayload.getJcrNode();
            HashMap<Name, Object> props = new HashMap<Name, Object>();
            for (Property dnaProp : graphProperties.values()) {
                int definitionType;
                boolean isMultiple;
                int propertyType;
                JcrPropertyDefinition propertyDefinition;
                Name name = dnaProp.getName();
                if (ModeShapeLexicon.UUID.equals(name)) continue;
                boolean isSingle = dnaProp.isSingle();
                if (isSingle && multiValuedPropertyNames.contains(name)) {
                    isSingle = false;
                }
                if ((propertyDefinition = SessionCache.this.findBestPropertyDefintion(primaryTypeName, mixinTypeNames, dnaProp, propertyType = PropertyTypeUtil.jcrPropertyTypeFor(dnaProp), isSingle, false)) == null) {
                    JcrNodeType unstructured = SessionCache.this.nodeTypes().getNodeType(JcrNtLexicon.UNSTRUCTURED);
                    for (PropertyDefinition anyDefinition : unstructured.getDeclaredPropertyDefinitions()) {
                        if (!anyDefinition.isMultiple()) continue;
                        propertyDefinition = anyDefinition;
                        break;
                    }
                }
                if (propertyDefinition == null || !(isMultiple = propertyDefinition.isMultiple()) && dnaProp.isEmpty()) continue;
                if (isMultiple && isSingle) {
                    if (newSingleMultiPropertyNames == null) {
                        newSingleMultiPropertyNames = new HashSet<Name>();
                    }
                    newSingleMultiPropertyNames.add(name);
                }
                if ((definitionType = propertyDefinition.getRequiredType()) != 0) {
                    propertyType = definitionType;
                }
                JcrPropertyDefinition defn = propertyDefinition;
                AbstractJcrProperty jcrProp = null;
                jcrProp = isMultiple ? new JcrMultiValueProperty(SessionCache.this, jcrNode, dnaProp.getName()) : new JcrSingleValueProperty(SessionCache.this, jcrNode, dnaProp.getName());
                JcrPropertyPayload payload = new JcrPropertyPayload(defn.getId(), propertyType, jcrProp);
                GraphSession.PropertyInfo propInfo = new GraphSession.PropertyInfo(dnaProp, defn.isMultiple(), GraphSession.Status.UNCHANGED, (Object)payload);
                props.put(name, propInfo);
            }
            if (referenceable) {
                JcrValue value = new JcrValue(SessionCache.this.factories(), SessionCache.this, 1, uuid);
                JcrPropertyDefinition propDefn = SessionCache.this.nodeTypes().findPropertyDefinition(primaryTypeName, mixinTypeNames, JcrLexicon.UUID, value, false, false);
                GraphSession.PropertyInfo<JcrPropertyPayload> propInfo = SessionCache.this.createPropertyInfo(nodePayload, uuidProperty, propDefn, 1, null);
                props.put(JcrLexicon.UUID, propInfo);
            } else {
                props.remove(JcrLexicon.UUID);
            }
            props.remove(ModeShapeLexicon.UUID);
            if (newSingleMultiPropertyNames != null) {
                GraphSession.PropertyInfo<JcrPropertyPayload> info = SessionCache.this.createSingleMultipleProperty(nodePayload, null, newSingleMultiPropertyNames);
                props.put(info.getName(), info);
            }
            node.loadedWith(persistentNode.getChildren(), props, persistentNode.getExpirationTime());
            node.setPayload((Object)nodePayload);
        }

        public void postSetProperty(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node, Name propertyName, GraphSession.PropertyInfo<JcrPropertyPayload> oldProperty) {
            GraphSession.PropertyInfo changedProperty;
            super.postSetProperty(node, propertyName, oldProperty);
            if (propertyName.equals(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES)) {
                return;
            }
            if (propertyName.equals(JcrLexicon.MIXIN_TYPES)) {
                HashSet<Object> mixinTypeNames = new HashSet<Object>();
                NameFactory nameFactory = SessionCache.this.context().getValueFactories().getNameFactory();
                for (Object value : node.getProperty(propertyName).getProperty()) {
                    mixinTypeNames.add(nameFactory.create(value));
                }
                node.setPayload((Object)((JcrNodePayload)node.getPayload()).with(new ArrayList<Name>(mixinTypeNames)));
            }
            if ((changedProperty = node.getProperty(propertyName)).isMultiValued()) {
                if (changedProperty.getProperty().isSingle()) {
                    SessionCache.this.updateSingleMultipleProperty(node, propertyName, true);
                } else {
                    SessionCache.this.updateSingleMultipleProperty(node, propertyName, false);
                }
            }
        }

        public void preSave(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) throws ValidationException {
            JcrItemDefinition definition;
            JcrNodePayload payload = (JcrNodePayload)node.getPayload();
            Name primaryTypeName = payload.getPrimaryTypeName();
            List<Name> mixinTypeNames = payload.getMixinTypeNames();
            HashSet<JcrPropertyDefinition> satisfiedChildNodes = new HashSet<JcrPropertyDefinition>();
            HashSet<JcrPropertyDefinition> satisfiedProperties = new HashSet<JcrPropertyDefinition>();
            boolean referenceable = false;
            try {
                referenceable = SessionCache.this.isReferenceable(node);
            }
            catch (RepositoryException e) {
                throw new ValidationException(e.getLocalizedMessage());
            }
            for (GraphSession.PropertyInfo property : node.getProperties()) {
                if (property.getName().equals(JcrLexicon.UUID) && !referenceable) continue;
                JcrPropertyPayload propPayload = (JcrPropertyPayload)property.getPayload();
                definition = SessionCache.this.findBestPropertyDefintion(primaryTypeName, mixinTypeNames, property.getProperty(), propPayload.getPropertyType(), property.getProperty().isSingle(), false);
                if (definition == null) {
                    throw new ValidationException(JcrI18n.noDefinition.text(new Object[]{"property", SessionCache.this.readable(property.getName()), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)}));
                }
                satisfiedProperties.add((JcrPropertyDefinition)definition);
            }
            for (GraphSession.Node child : node.getChildren()) {
                int snsCount = node.getChildrenCount(child.getName());
                definition = SessionCache.this.nodeTypes().findChildNodeDefinition(primaryTypeName, mixinTypeNames, child.getName(), ((JcrNodePayload)child.getPayload()).getPrimaryTypeName(), snsCount, false);
                if (definition == null) {
                    throw new ValidationException(JcrI18n.noDefinition.text(new Object[]{"child node", SessionCache.this.readable(child.getName()), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)}));
                }
                satisfiedChildNodes.add((JcrPropertyDefinition)definition);
            }
            JcrNodeType primaryType = SessionCache.this.nodeTypes().getNodeType(primaryTypeName);
            for (JcrPropertyDefinition jcrPropertyDefinition : primaryType.getPropertyDefinitions()) {
                if (!jcrPropertyDefinition.isMandatory() || jcrPropertyDefinition.isProtected() || satisfiedProperties.contains(jcrPropertyDefinition)) continue;
                throw new ValidationException(JcrI18n.noDefinition.text(new Object[]{"property", jcrPropertyDefinition.getName(), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)}));
            }
            for (JcrItemDefinition jcrItemDefinition : primaryType.getChildNodeDefinitions()) {
                if (!jcrItemDefinition.isMandatory() || jcrItemDefinition.isProtected() || satisfiedChildNodes.contains(jcrItemDefinition)) continue;
                throw new ValidationException(JcrI18n.noDefinition.text(new Object[]{"child node", jcrItemDefinition.getName(), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)}));
            }
            if (mixinTypeNames != null) {
                for (Name mixinTypeName : mixinTypeNames) {
                    JcrNodeType mixinType = SessionCache.this.nodeTypes().getNodeType(mixinTypeName);
                    for (JcrPropertyDefinition jcrPropertyDefinition : mixinType.getPropertyDefinitions()) {
                        if (!jcrPropertyDefinition.isMandatory() || jcrPropertyDefinition.isProtected() || satisfiedProperties.contains(jcrPropertyDefinition)) continue;
                        throw new ValidationException(JcrI18n.noDefinition.text(new Object[]{"child node", jcrPropertyDefinition.getName(), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)}));
                    }
                    for (JcrNodeDefinition jcrNodeDefinition : mixinType.getChildNodeDefinitions()) {
                        if (!jcrNodeDefinition.isMandatory() || jcrNodeDefinition.isProtected() || satisfiedChildNodes.contains(jcrNodeDefinition)) continue;
                        throw new ValidationException(JcrI18n.noDefinition.text(new Object[]{"child node", jcrNodeDefinition.getName(), SessionCache.this.readable(node.getPath()), SessionCache.this.readable(primaryTypeName), SessionCache.this.readable(mixinTypeNames)}));
                    }
                }
            }
        }

        public void compute(Graph.Batch batch, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
            try {
                this.initializeVersionHistoryFor(batch, node);
            }
            catch (RepositoryException re) {
                throw new IllegalStateException(re);
            }
        }

        private void initializeVersionHistoryFor(Graph.Batch batch, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) throws RepositoryException {
            boolean initialized;
            boolean bl = initialized = node.getProperty(JcrLexicon.IS_CHECKED_OUT) != null;
            if (!SessionCache.this.isVersionable(node) || initialized) {
                return;
            }
            Graph systemGraph = SessionCache.this.session().repository().createSystemGraph(SessionCache.this.context());
            JcrNodePayload payload = (JcrNodePayload)node.getPayload();
            GraphSession.PropertyInfo jcrUuidProp = node.getProperty(JcrLexicon.UUID);
            UUID jcrUuid = (UUID)SessionCache.this.factories().getUuidFactory().create(jcrUuidProp.getProperty().getFirstValue());
            Name nameSegment = (Name)SessionCache.this.factories().getNameFactory().create(jcrUuid.toString());
            Path historyPath = SessionCache.this.pathFactory().createAbsolutePath(new Name[]{JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE, nameSegment});
            Graph.Batch systemBatch = systemGraph.batch();
            Name primaryTypeName = payload.getPrimaryTypeName();
            List<Name> mixinTypeNames = payload.getMixinTypeNames();
            UUID historyUuid = UUID.randomUUID();
            UUID versionUuid = UUID.randomUUID();
            systemBatch.create(historyPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION_HISTORY}).and(JcrLexicon.VERSIONABLE_UUID, new Object[]{jcrUuid}).and(JcrLexicon.UUID, new Object[]{historyUuid}).and();
            Path versionLabelsPath = SessionCache.this.pathFactory().create(historyPath, new Name[]{JcrLexicon.VERSION_LABELS});
            systemBatch.create(versionLabelsPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION_LABELS}).and();
            Path rootVersionPath = SessionCache.this.pathFactory().create(historyPath, new Name[]{JcrLexicon.ROOT_VERSION});
            DateTime now = SessionCache.this.context().getValueFactories().getDateFactory().create();
            systemBatch.create(rootVersionPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION}).and(JcrLexicon.CREATED, new Object[]{now}).and(JcrLexicon.UUID, new Object[]{versionUuid}).and();
            Path frozenVersionPath = SessionCache.this.pathFactory().create(rootVersionPath, new Name[]{JcrLexicon.FROZEN_NODE});
            systemBatch.create(frozenVersionPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FROZEN_NODE}).and(JcrLexicon.FROZEN_UUID, new Object[]{jcrUuid}).and(JcrLexicon.FROZEN_PRIMARY_TYPE, new Object[]{primaryTypeName}).and(JcrLexicon.FROZEN_MIXIN_TYPES, new Object[]{mixinTypeNames}).and();
            systemBatch.execute();
            PropertyFactory propFactory = SessionCache.this.context().getPropertyFactory();
            ValueFactory refFactory = SessionCache.this.context().getValueFactories().getReferenceFactory();
            Property isCheckedOut = propFactory.create(JcrLexicon.IS_CHECKED_OUT, new Object[]{true});
            Property versionHistory = propFactory.create(JcrLexicon.VERSION_HISTORY, new Object[]{refFactory.create(historyUuid)});
            Property baseVersion = propFactory.create(JcrLexicon.BASE_VERSION, new Object[]{refFactory.create(versionUuid)});
            Property predecessors = propFactory.create(JcrLexicon.PREDECESSORS, new Object[]{refFactory.create(versionUuid)});
            ((Graph.BatchConjunction)batch.set(new Property[]{isCheckedOut, versionHistory, baseVersion, predecessors}).on(node.getPath())).and();
            Path storagePath = historyPath.getParent();
            GraphSession.Node<JcrNodePayload, JcrPropertyPayload> storageNode = SessionCache.this.findNode(null, storagePath);
            SessionCache.this.refresh(storageNode.getNodeId(), storagePath, false);
        }

        public void postCreateChild(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> parent, GraphSession.Node<JcrNodePayload, JcrPropertyPayload> child, Map<Name, GraphSession.PropertyInfo<JcrPropertyPayload>> properties) throws ValidationException {
            super.postCreateChild(parent, child, properties);
            GraphSession.PropertyInfo<JcrPropertyPayload> primaryTypeInfo = properties.get(JcrLexicon.PRIMARY_TYPE);
            GraphSession.PropertyInfo<JcrPropertyPayload> nodeDefnInfo = properties.get(ModeShapeIntLexicon.NODE_DEFINITON);
            Name primaryTypeName = (Name)SessionCache.this.nameFactory().create(primaryTypeInfo.getProperty().getFirstValue());
            String nodeDefnIdStr = (String)SessionCache.this.stringFactory().create(nodeDefnInfo.getProperty().getFirstValue());
            NodeDefinitionId nodeDefnId = NodeDefinitionId.fromString(nodeDefnIdStr, SessionCache.this.nameFactory);
            JcrNodePayload nodePayload = new JcrNodePayload(SessionCache.this, child, primaryTypeName, null, nodeDefnId);
            child.setPayload((Object)nodePayload);
            JcrNodeType ntBase = SessionCache.this.nodeTypes().getNodeType(JcrNtLexicon.BASE);
            assert (ntBase != null);
            primaryTypeInfo = SessionCache.this.createPropertyInfo((JcrNodePayload)child.getPayload(), primaryTypeInfo.getProperty(), ntBase.allPropertyDefinitions(JcrLexicon.PRIMARY_TYPE).iterator().next(), 7, primaryTypeInfo);
            properties.put(primaryTypeInfo.getName(), primaryTypeInfo);
            nodeDefnInfo = SessionCache.this.createPropertyInfo((JcrNodePayload)child.getPayload(), nodeDefnInfo.getProperty(), ntBase.allPropertyDefinitions(ModeShapeIntLexicon.NODE_DEFINITON).iterator().next(), 1, nodeDefnInfo);
            properties.put(nodeDefnInfo.getName(), nodeDefnInfo);
            GraphSession.PropertyInfo<JcrPropertyPayload> uuidInfo = properties.get(JcrLexicon.UUID);
            if (uuidInfo != null) {
                JcrNodeType mixRef = SessionCache.this.nodeTypes().getNodeType(JcrMixLexicon.REFERENCEABLE);
                assert (mixRef != null);
                uuidInfo = SessionCache.this.createPropertyInfo((JcrNodePayload)child.getPayload(), uuidInfo.getProperty(), mixRef.allPropertyDefinitions(JcrLexicon.UUID).iterator().next(), 1, uuidInfo);
                properties.put(uuidInfo.getName(), uuidInfo);
            }
        }

        protected final Set<Name> getSingleMultiPropertyNames(Property dnaProperty, Location location) {
            HashSet<Name> multiValuedPropertyNames = new HashSet<Name>();
            for (Object value : dnaProperty) {
                try {
                    multiValuedPropertyNames.add((Name)SessionCache.this.nameFactory.create(value));
                }
                catch (ValueFormatException e) {
                    String msg = "{0} value \"{1}\" on {2} in \"{3}\" workspace is not a valid name and is being ignored";
                    this.LOGGER.trace((Throwable)e, msg, new Object[]{SessionCache.this.readable(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES), value, SessionCache.this.readable(location), SessionCache.this.workspaceName()});
                }
            }
            return multiValuedPropertyNames;
        }
    }

    public final class NodeEditor {
        private final GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node;

        protected NodeEditor(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> node) {
            this.node = node;
        }

        private void checkCardinalityOfExistingProperty(Name propertyName, boolean isMultiple) throws javax.jcr.ValueFormatException, RepositoryException {
            GraphSession.PropertyInfo propInfo = this.node.getProperty(propertyName);
            if (propInfo != null && propInfo.isMultiValued() != isMultiple) {
                String workspaceName = SessionCache.this.workspaceName();
                String propName = SessionCache.this.readable(propertyName);
                String path = SessionCache.this.readable(this.node.getPath());
                if (isMultiple) {
                    I18n msg = JcrI18n.unableToSetSingleValuedPropertyUsingMultipleValues;
                    throw new javax.jcr.ValueFormatException(msg.text(new Object[]{propName, path, workspaceName}));
                }
                I18n msg = JcrI18n.unableToSetMultiValuedPropertyUsingSingleValue;
                throw new javax.jcr.ValueFormatException(msg.text(new Object[]{propName, path, workspaceName}));
            }
        }

        boolean isCheckedOut() throws RepositoryException {
            GraphSession.Node curr = this.node;
            while (curr.getParent() != null) {
                if (SessionCache.this.isNodeType(curr, JcrMixLexicon.VERSIONABLE)) {
                    GraphSession.PropertyInfo prop = curr.getProperty(JcrLexicon.IS_CHECKED_OUT);
                    return prop == null || ((JcrPropertyPayload)prop.getPayload()).getJcrProperty().getBoolean();
                }
                curr = curr.getParent();
            }
            return true;
        }

        public AbstractJcrProperty setProperty(Name name, JcrValue value) throws AccessDeniedException, ConstraintViolationException, RepositoryException {
            return this.setProperty(name, value, true);
        }

        public AbstractJcrProperty setProperty(Name name, JcrValue value, boolean skipProtected) throws AccessDeniedException, ConstraintViolationException, VersionException, RepositoryException {
            assert (name != null);
            assert (value != null);
            if (!this.isCheckedOut() && skipProtected) {
                String path = this.node.getLocation().getPath().getString(SessionCache.this.context().getNamespaceRegistry());
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{path}));
            }
            this.checkCardinalityOfExistingProperty(name, false);
            JcrPropertyDefinition definition = null;
            GraphSession.PropertyInfo existing = this.node.getProperty(name);
            if (existing != null && (definition = SessionCache.this.nodeTypes().getPropertyDefinition(((JcrPropertyPayload)existing.getPayload()).getPropertyDefinitionId())) != null) {
                if (definition.getRequiredType() != 0 && definition.getRequiredType() != value.getType()) {
                    definition = null;
                } else if (!definition.satisfiesConstraints(value)) {
                    definition = null;
                }
            }
            JcrNodePayload payload = (JcrNodePayload)this.node.getPayload();
            if (definition == null) {
                boolean referencePropMissedConstraints;
                definition = SessionCache.this.nodeTypes().findPropertyDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, value, true, skipProtected);
                boolean bl = referencePropMissedConstraints = definition != null && definition.getRequiredType() == 9 && !definition.canCastToTypeAndSatisfyConstraints(value);
                if (definition == null || referencePropMissedConstraints) {
                    throw new ConstraintViolationException(JcrI18n.noDefinition.text(new Object[]{"property", SessionCache.this.readable(name), SessionCache.this.readable(this.node.getPath()), SessionCache.this.readable(payload.getPrimaryTypeName()), SessionCache.this.readable(payload.getMixinTypeNames())}));
                }
            } else if (skipProtected && definition.isProtected()) {
                throw new ConstraintViolationException(JcrI18n.noDefinition.text(new Object[]{"property", SessionCache.this.readable(name), SessionCache.this.readable(this.node.getPath()), SessionCache.this.readable(payload.getPrimaryTypeName()), SessionCache.this.readable(payload.getMixinTypeNames())}));
            }
            Object objValue = value.value();
            int propertyType = definition.getRequiredType();
            if (propertyType == 0 || propertyType == value.getType()) {
                propertyType = value.getType();
            } else {
                org.modeshape.graph.property.PropertyType dnaPropertyType = PropertyTypeUtil.dnaPropertyTypeFor(propertyType);
                ValueFactory factory = SessionCache.this.factories().getValueFactory(dnaPropertyType);
                objValue = factory.create(objValue);
            }
            Property dnaProp = SessionCache.this.propertyFactory.create(name, new Object[]{objValue});
            try {
                AbstractJcrProperty jcrProp = null;
                if (existing != null) {
                    jcrProp = ((JcrPropertyPayload)existing.getPayload()).getJcrProperty();
                } else {
                    AbstractJcrNode jcrNode = payload.getJcrNode();
                    jcrProp = definition.isMultiple() ? new JcrMultiValueProperty(SessionCache.this, jcrNode, dnaProp.getName()) : new JcrSingleValueProperty(SessionCache.this, jcrNode, dnaProp.getName());
                }
                assert (jcrProp != null);
                JcrPropertyPayload propPayload = new JcrPropertyPayload(definition.getId(), propertyType, jcrProp);
                this.node.setProperty(dnaProp, definition.isMultiple(), (Object)propPayload);
                return jcrProp;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public AbstractJcrProperty setProperty(Name name, Value[] values, int valueType) throws AccessDeniedException, ConstraintViolationException, RepositoryException, javax.jcr.ValueFormatException {
            return this.setProperty(name, values, valueType, true);
        }

        public AbstractJcrProperty setProperty(Name name, Value[] values, int valueType, boolean skipProtected) throws AccessDeniedException, ConstraintViolationException, RepositoryException, javax.jcr.ValueFormatException, VersionException {
            assert (name != null);
            assert (values != null);
            if (!this.isCheckedOut() && skipProtected) {
                String path = this.node.getLocation().getPath().getString(SessionCache.this.context().getNamespaceRegistry());
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{path}));
            }
            this.checkCardinalityOfExistingProperty(name, true);
            int len = values.length;
            Value[] newValues = null;
            if (len == 0) {
                newValues = JcrMultiValueProperty.EMPTY_VALUES;
            } else {
                ArrayList<Value> valuesWithDesiredType = new ArrayList<Value>(len);
                int expectedType = -1;
                for (int i = 0; i != len; ++i) {
                    Value value = values[i];
                    if (value == null) continue;
                    if (expectedType == -1) {
                        expectedType = value.getType();
                    } else if (value.getType() != expectedType) {
                        StringBuilder sb = new StringBuilder();
                        sb.append('[');
                        for (int j = 0; j != values.length; ++j) {
                            if (j != 0) {
                                sb.append(",");
                            }
                            sb.append(values[j].toString());
                        }
                        sb.append(']');
                        String propType = PropertyType.nameFromValue((int)expectedType);
                        I18n msg = JcrI18n.allPropertyValuesMustHaveSameType;
                        String path = SessionCache.this.readable(this.node.getPath());
                        String workspaceName = SessionCache.this.workspaceName();
                        throw new javax.jcr.ValueFormatException(msg.text(new Object[]{SessionCache.this.readable(name), values, propType, path, workspaceName}));
                    }
                    if (value.getType() != valueType && valueType != 0) {
                        value = ((JcrValue)value).asType(valueType);
                    }
                    valuesWithDesiredType.add(value);
                }
                newValues = valuesWithDesiredType.isEmpty() ? JcrMultiValueProperty.EMPTY_VALUES : valuesWithDesiredType.toArray(new Value[valuesWithDesiredType.size()]);
            }
            int numValues = newValues.length;
            JcrPropertyDefinition definition = null;
            GraphSession.PropertyInfo existing = this.node.getProperty(name);
            if (existing != null && (definition = SessionCache.this.nodeTypes().getPropertyDefinition(((JcrPropertyPayload)existing.getPayload()).getPropertyDefinitionId())) != null && numValues != 0) {
                int type = newValues[0].getType();
                if (definition.getRequiredType() != 0 && definition.getRequiredType() != type) {
                    definition = null;
                } else if (!definition.satisfiesConstraints(newValues)) {
                    definition = null;
                }
            }
            JcrNodePayload payload = (JcrNodePayload)this.node.getPayload();
            if (definition == null) {
                boolean referencePropMissedConstraints;
                definition = SessionCache.this.nodeTypes().findPropertyDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, newValues, skipProtected);
                boolean bl = referencePropMissedConstraints = definition != null && definition.getRequiredType() == 9 && !definition.canCastToTypeAndSatisfyConstraints(newValues);
                if (definition == null || referencePropMissedConstraints) {
                    throw new ConstraintViolationException(JcrI18n.noDefinition.text(new Object[]{"property", SessionCache.this.readable(name), SessionCache.this.readable(this.node.getPath()), SessionCache.this.readable(payload.getPrimaryTypeName()), SessionCache.this.readable(payload.getMixinTypeNames())}));
                }
            } else if (skipProtected && definition.isProtected()) {
                throw new ConstraintViolationException(JcrI18n.noDefinition.text(new Object[]{"property", SessionCache.this.readable(name), SessionCache.this.readable(this.node.getPath()), SessionCache.this.readable(payload.getPrimaryTypeName()), SessionCache.this.readable(payload.getMixinTypeNames())}));
            }
            int type = numValues != 0 ? newValues[0].getType() : definition.getRequiredType();
            Object[] objValues = new Object[numValues];
            int propertyType = definition.getRequiredType();
            if (propertyType == 0 || propertyType == type) {
                propertyType = type;
                for (int i = 0; i != numValues; ++i) {
                    objValues[i] = ((JcrValue)newValues[i]).value();
                }
            } else {
                assert (propertyType != type);
                org.modeshape.graph.property.PropertyType dnaPropertyType = PropertyTypeUtil.dnaPropertyTypeFor(propertyType);
                ValueFactory factory = SessionCache.this.factories().getValueFactory(dnaPropertyType);
                for (int i = 0; i != numValues; ++i) {
                    objValues[i] = factory.create(((JcrValue)newValues[i]).value());
                }
            }
            Property dnaProp = SessionCache.this.propertyFactory.create(name, objValues);
            try {
                AbstractJcrProperty jcrProp = null;
                if (existing != null) {
                    jcrProp = ((JcrPropertyPayload)existing.getPayload()).getJcrProperty();
                } else {
                    AbstractJcrNode jcrNode = payload.getJcrNode();
                    jcrProp = definition.isMultiple() ? new JcrMultiValueProperty(SessionCache.this, jcrNode, dnaProp.getName()) : new JcrSingleValueProperty(SessionCache.this, jcrNode, dnaProp.getName());
                }
                assert (jcrProp != null);
                JcrPropertyPayload propPayload = new JcrPropertyPayload(definition.getId(), propertyType, jcrProp);
                this.node.setProperty(dnaProp, definition.isMultiple(), (Object)propPayload);
                return jcrProp;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public boolean removeProperty(Name name) throws AccessDeniedException, RepositoryException {
            try {
                return this.node.removeProperty(name) != null;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public void orderChildBefore(Path.Segment childToBeMoved, Path.Segment before) throws AccessDeniedException, RepositoryException {
            try {
                this.node.orderChildBefore(childToBeMoved, before);
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public GraphSession.Node<JcrNodePayload, JcrPropertyPayload> moveToBeChild(AbstractJcrNode child, Name newNodeName) throws ItemNotFoundException, InvalidItemStateException, ConstraintViolationException, RepositoryException {
            GraphSession.Node<JcrNodePayload, JcrPropertyPayload> existingChild = SessionCache.this.findNode(child.nodeId, child.location.getPath());
            if (existingChild.equals(this.node) || this.node.isAtOrBelow(existingChild)) {
                String pathOfChild = SessionCache.this.readable(existingChild.getPath());
                String thisPath = SessionCache.this.readable(this.node.getPath());
                String msg = JcrI18n.unableToMoveNodeToBeChildOfDecendent.text(new Object[]{pathOfChild, thisPath, SessionCache.this.workspaceName()});
                throw new RepositoryException(msg);
            }
            JcrNodeDefinition defn = SessionCache.this.findBestNodeDefinition(this.node, newNodeName, child.getPrimaryTypeName());
            try {
                existingChild.moveTo(this.node, newNodeName);
                NodeDefinitionId existingChildDefinitionId = ((JcrNodePayload)existingChild.getPayload()).getDefinitionId();
                if (!defn.getId().equals(existingChildDefinitionId)) {
                    NodeEditor newChildEditor = SessionCache.this.getEditorFor(existingChild);
                    try {
                        JcrValue value = new JcrValue(SessionCache.this.factories(), SessionCache.this, 1, defn.getId().getString());
                        newChildEditor.setProperty(ModeShapeIntLexicon.NODE_DEFINITON, value);
                    }
                    catch (ConstraintViolationException e) {
                        existingChild.setPayload((Object)((JcrNodePayload)existingChild.getPayload()).with(defn.getId()));
                        newChildEditor.removeProperty(ModeShapeIntLexicon.NODE_DEFINITON);
                    }
                }
                return existingChild;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public void addMixin(JcrNodeType mixinCandidateType) throws javax.jcr.ValueFormatException, RepositoryException {
            try {
                GraphSession.PropertyInfo existingMixinProperty = this.node.getProperty(JcrLexicon.MIXIN_TYPES);
                Value[] existingMixinValues = existingMixinProperty != null ? ((JcrPropertyPayload)existingMixinProperty.getPayload()).getJcrProperty().getValues() : new Value[]{};
                Value[] newMixinValues = new Value[existingMixinValues.length + 1];
                System.arraycopy(existingMixinValues, 0, newMixinValues, 0, existingMixinValues.length);
                newMixinValues[newMixinValues.length - 1] = new JcrValue(SessionCache.this.factories(), SessionCache.this, 7, mixinCandidateType.getInternalName());
                this.setProperty(JcrLexicon.MIXIN_TYPES, newMixinValues, 7, false);
                this.addAutoCreatedItems(this, mixinCandidateType);
                if (mixinCandidateType.isNodeType(JcrMixLexicon.REFERENCEABLE)) {
                    UUID uuid = this.node.getLocation().getUuid();
                    if (uuid == null) {
                        uuid = (UUID)this.node.getLocation().getIdProperty(JcrLexicon.UUID).getFirstValue();
                    }
                    if (uuid == null) {
                        uuid = UUID.randomUUID();
                    }
                    JcrValue value = new JcrValue(SessionCache.this.factories(), SessionCache.this, 1, uuid);
                    this.setProperty(JcrLexicon.UUID, value, false);
                }
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        private void addAutoCreatedItems(NodeEditor editor, JcrNodeType nodeType) throws InvalidItemStateException, ConstraintViolationException, AccessDeniedException, RepositoryException {
            for (JcrPropertyDefinition propertyDefinition : nodeType.propertyDefinitions()) {
                GraphSession.PropertyInfo autoCreatedProp;
                if (!propertyDefinition.isAutoCreated() || propertyDefinition.isProtected() || (autoCreatedProp = this.node.getProperty(propertyDefinition.getInternalName())) != null) continue;
                assert (propertyDefinition.getDefaultValues() != null);
                if (propertyDefinition.isMultiple()) {
                    editor.setProperty(propertyDefinition.getInternalName(), propertyDefinition.getDefaultValues(), propertyDefinition.getRequiredType());
                    continue;
                }
                assert (propertyDefinition.getDefaultValues().length == 1);
                editor.setProperty(propertyDefinition.getInternalName(), (JcrValue)propertyDefinition.getDefaultValues()[0]);
            }
            for (JcrNodeDefinition nodeDefinition : nodeType.childNodeDefinitions()) {
                Name nodeName;
                if (!nodeDefinition.isAutoCreated() || nodeDefinition.isProtected() || this.node.getChildrenCount(nodeName = nodeDefinition.getInternalName()) != 0) continue;
                assert (nodeDefinition.getDefaultPrimaryType() != null);
                editor.createChild(nodeName, null, ((JcrNodeType)nodeDefinition.getDefaultPrimaryType()).getInternalName());
            }
        }

        public JcrNode createChild(Name name, UUID desiredUuid, Name primaryTypeName) throws InvalidItemStateException, ConstraintViolationException, AccessDeniedException, RepositoryException {
            if (desiredUuid == null) {
                desiredUuid = UUID.randomUUID();
            }
            try {
                int numSns = this.node.getChildrenCount(name) + 1;
                JcrNodePayload payload = (JcrNodePayload)this.node.getPayload();
                JcrNodeDefinition definition = SessionCache.this.nodeTypes().findChildNodeDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, primaryTypeName, numSns, true);
                if (definition == null) {
                    definition = SessionCache.this.nodeTypes().findChildNodeDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, primaryTypeName, numSns - 1, true);
                    if (definition != null) {
                        Path pathForChild = SessionCache.this.pathFactory.create(this.node.getPath(), name, numSns);
                        String msg = JcrI18n.noSnsDefinitionForNode.text(new Object[]{pathForChild, SessionCache.this.workspaceName()});
                        throw new ItemExistsException(msg);
                    }
                    Path pathForChild = SessionCache.this.pathFactory.create(this.node.getPath(), name, numSns);
                    String msg = JcrI18n.nodeDefinitionCouldNotBeDeterminedForNode.text(new Object[]{pathForChild, SessionCache.this.workspaceName(), SessionCache.this.sourceName()});
                    SessionCache.this.nodeTypes().findChildNodeDefinition(payload.getPrimaryTypeName(), payload.getMixinTypeNames(), name, primaryTypeName, numSns, true);
                    throw new ConstraintViolationException(msg);
                }
                JcrNodeType primaryType = null;
                if (primaryTypeName != null) {
                    primaryType = SessionCache.this.nodeTypes().getNodeType(primaryTypeName);
                    if (primaryType == null) {
                        Path pathForChild = SessionCache.this.pathFactory.create(this.node.getPath(), name, numSns);
                        I18n msg = JcrI18n.unableToCreateNodeWithPrimaryTypeThatDoesNotExist;
                        throw new NoSuchNodeTypeException(msg.text(new Object[]{primaryTypeName, pathForChild, SessionCache.this.workspaceName()}));
                    }
                } else {
                    primaryType = (JcrNodeType)definition.getDefaultPrimaryType();
                    if (primaryType == null) {
                        Path pathForChild = SessionCache.this.pathFactory.create(this.node.getPath(), name, numSns);
                        I18n msg = JcrI18n.unableToCreateNodeWithNoDefaultPrimaryTypeOnChildNodeDefinition;
                        String nodeTypeName = definition.getDeclaringNodeType().getName();
                        throw new NoSuchNodeTypeException(msg.text(new Object[]{definition.getName(), nodeTypeName, pathForChild, SessionCache.this.workspaceName()}));
                    }
                }
                primaryTypeName = primaryType.getInternalName();
                Property primaryTypeProp = SessionCache.this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{primaryTypeName});
                Property nodeDefinitionProp = SessionCache.this.propertyFactory.create(ModeShapeIntLexicon.NODE_DEFINITON, new Object[]{definition.getId().getString()});
                GraphSession.Node result = null;
                boolean isReferenceable = primaryType.isNodeType(JcrMixLexicon.REFERENCEABLE);
                Property uuidProperty = null;
                if (desiredUuid != null || isReferenceable) {
                    if (desiredUuid == null) {
                        desiredUuid = UUID.randomUUID();
                    }
                    uuidProperty = SessionCache.this.propertyFactory.create(JcrLexicon.UUID, new Object[]{desiredUuid});
                }
                result = uuidProperty != null ? this.node.createChild(name, Collections.singleton(uuidProperty), new Property[]{primaryTypeProp, nodeDefinitionProp}) : this.node.createChild(name, new Property[]{primaryTypeProp, nodeDefinitionProp});
                JcrNode jcrNode = (JcrNode)((JcrNodePayload)result.getPayload()).getJcrNode();
                boolean isHierarchyNode = primaryType.isNodeType(JcrNtLexicon.HIERARCHY_NODE);
                if (isHierarchyNode) {
                    JcrValue value = jcrNode.valueFrom(Calendar.getInstance());
                    jcrNode.editor().setProperty(JcrLexicon.CREATED, value, false);
                }
                this.addAutoCreatedItems(jcrNode.editor(), primaryType);
                return jcrNode;
            }
            catch (ValidationException e) {
                throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
        }

        public boolean destroyChild(GraphSession.Node<JcrNodePayload, JcrPropertyPayload> child) throws AccessDeniedException, RepositoryException {
            if (!child.getParent().equals(this.node)) {
                return false;
            }
            try {
                child.destroy();
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
            return true;
        }

        public boolean destroy() throws AccessDeniedException, RepositoryException {
            try {
                this.node.destroy();
            }
            catch (AccessControlException e) {
                throw new AccessDeniedException(e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }
}

