/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.NetChangeObserver;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.session.InvalidStateException;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;

final class JcrObservationManager
implements ObservationManager {
    private final Observable repositoryObservable;
    private final Map<EventListener, JcrListenerAdapter> listeners;
    private final NamespaceRegistry namespaceRegistry;
    private final JcrSession session;
    private final ValueFactories valueFactories;

    public JcrObservationManager(JcrSession session, Observable repositoryObservable) {
        CheckArg.isNotNull((Object)session, (String)"session");
        CheckArg.isNotNull((Object)repositoryObservable, (String)"repositoryObservable");
        this.session = session;
        this.repositoryObservable = repositoryObservable;
        this.listeners = new ConcurrentHashMap<EventListener, JcrListenerAdapter>();
        this.namespaceRegistry = this.session.getExecutionContext().getNamespaceRegistry();
        this.valueFactories = this.session.getExecutionContext().getValueFactories();
    }

    public synchronized void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) {
        this.checkSession();
        CheckArg.isNotNull((Object)listener, (String)"listener");
        JcrListenerAdapter adapter = new JcrListenerAdapter(listener, eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal);
        this.repositoryObservable.unregister((Observer)adapter);
        this.repositoryObservable.register((Observer)adapter);
        this.listeners.put(listener, adapter);
    }

    void checkSession() throws InvalidStateException {
        if (!this.session.isLive()) {
            throw new InvalidStateException(JcrI18n.sessionIsNotActive.text(new Object[]{this.session.sessionId()}));
        }
    }

    NamespaceRegistry geNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    JcrNodeTypeManager getNodeTypeManager() throws RepositoryException {
        return (JcrNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
    }

    public EventListenerIterator getRegisteredEventListeners() {
        this.checkSession();
        return new JcrEventListenerIterator((Collection<EventListener>)this.listeners.keySet());
    }

    String getUserId() {
        return this.session.getUserID();
    }

    ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    Graph getGraph() {
        return ((JcrWorkspace)this.session.getWorkspace()).graph();
    }

    String getSessionId() {
        return this.session.sessionId();
    }

    synchronized void removeAllEventListeners() {
        for (JcrListenerAdapter listener : this.listeners.values()) {
            assert (listener != null);
            this.repositoryObservable.unregister((Observer)listener);
        }
        this.listeners.clear();
    }

    public synchronized void removeEventListener(EventListener listener) {
        this.checkSession();
        CheckArg.isNotNull((Object)listener, (String)"listener");
        JcrListenerAdapter jcrListener = this.listeners.remove(listener);
        if (jcrListener != null) {
            this.repositoryObservable.unregister((Observer)jcrListener);
        }
    }

    @NotThreadSafe
    class JcrListenerAdapter
    extends NetChangeObserver {
        private final String absPath;
        private Map<Location, Map<Name, Property>> propertiesByLocation;
        private final EventListener delegate;
        private final int eventTypes;
        private final boolean isDeep;
        private final String[] nodeTypeNames;
        private final boolean noLocal;
        private final String[] uuids;

        public JcrListenerAdapter(EventListener delegate, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) {
            assert (delegate != null);
            this.delegate = delegate;
            this.eventTypes = eventTypes;
            this.absPath = absPath;
            this.isDeep = isDeep;
            this.uuids = uuids;
            this.nodeTypeNames = nodeTypeNames;
            this.noLocal = noLocal;
        }

        private boolean acceptBasedOnEventSource(Changes changes) {
            if (this.noLocal) {
                return !JcrObservationManager.this.getSessionId().equals(changes.getContextId());
            }
            return true;
        }

        private boolean acceptBasedOnNodeTypeName(NetChangeObserver.NetChange change) {
            boolean accept = true;
            if (this.shouldCheckNodeType()) {
                ValueFactory stringFactory = JcrObservationManager.this.getValueFactories().getStringFactory();
                Location parentLocation = Location.create((Path)change.getLocation().getPath().getParent());
                Map<Name, Property> propMap = this.propertiesByLocation.get(parentLocation);
                assert (propMap != null);
                try {
                    String primaryTypeName = (String)stringFactory.create(propMap.get(JcrLexicon.PRIMARY_TYPE).getFirstValue());
                    String[] mixinNames = null;
                    if (propMap.get(JcrLexicon.MIXIN_TYPES) != null) {
                        mixinNames = (String[])stringFactory.create(propMap.get(JcrLexicon.MIXIN_TYPES).getValuesAsArray());
                    }
                    return JcrObservationManager.this.getNodeTypeManager().isDerivedFrom(this.nodeTypeNames, primaryTypeName, mixinNames);
                }
                catch (RepositoryException e) {
                    accept = false;
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Throwable)e, JcrI18n.cannotPerformNodeTypeCheck, new Object[]{propMap.get(JcrLexicon.PRIMARY_TYPE), propMap.get(JcrLexicon.MIXIN_TYPES), this.nodeTypeNames});
                }
            }
            return accept;
        }

        private boolean acceptBasedOnPath(NetChangeObserver.NetChange change) {
            if (this.absPath != null && this.absPath.length() != 0) {
                Path matchPath = (Path)JcrObservationManager.this.getValueFactories().getPathFactory().create(this.absPath);
                Path changePath = null;
                changePath = change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_ADDED, NetChangeObserver.ChangeType.NODE_REMOVED}) ? change.getPath().getParent() : change.getPath();
                if (this.isDeep) {
                    return matchPath.isAtOrAbove(changePath);
                }
                return matchPath.equals(changePath);
            }
            return true;
        }

        private boolean acceptBasedOnUuid(NetChangeObserver.NetChange change) {
            UUID matchUuid;
            boolean accept = true;
            if (this.uuids != null && this.uuids.length != 0 && (matchUuid = change.getLocation().getUuid()) != null) {
                accept = false;
                UuidFactory uuidFactory = JcrObservationManager.this.getValueFactories().getUuidFactory();
                for (String uuidText : this.uuids) {
                    if (uuidText == null || uuidText.length() == 0) continue;
                    try {
                        UUID testUuid = (UUID)uuidFactory.create(uuidText);
                        if (!matchUuid.equals(testUuid)) continue;
                        accept = true;
                        break;
                    }
                    catch (ValueFormatException e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error(JcrI18n.cannotCreateUuid, new Object[]{uuidText});
                    }
                }
            }
            return accept;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof JcrListenerAdapter) {
                return this.delegate == ((JcrListenerAdapter)((Object)obj)).delegate;
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(Changes changes) {
            if (!this.acceptBasedOnEventSource(changes)) {
                return;
            }
            try {
                if (this.shouldCheckNodeType()) {
                    ArrayList<Location> changedLocations = new ArrayList<Location>();
                    for (ChangeRequest request : changes.getChangeRequests()) {
                        Path changedPath = request.changedLocation().getPath();
                        Path parentPath = changedPath.getParent();
                        changedLocations.add(Location.create((Path)parentPath));
                    }
                    Graph graph = JcrObservationManager.this.getGraph();
                    this.propertiesByLocation = graph.getProperties(new Name[]{JcrLexicon.PRIMARY_TYPE, JcrLexicon.MIXIN_TYPES}).on(changedLocations);
                }
                super.notify(changes);
            }
            finally {
                this.propertiesByLocation = null;
            }
        }

        protected void notify(NetChangeObserver.NetChanges netChanges) {
            ArrayList<Event> events = new ArrayList<Event>();
            for (NetChangeObserver.NetChange change : netChanges.getNetChanges()) {
                Path propertyPath;
                if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_LOCKED}) || change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_UNLOCKED}) || !this.acceptBasedOnNodeTypeName(change) || !this.acceptBasedOnPath(change) || !this.acceptBasedOnUuid(change)) continue;
                Path path = change.getPath();
                PathFactory pathFactory = JcrObservationManager.this.getValueFactories().getPathFactory();
                String userId = JcrObservationManager.this.getUserId();
                if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_ADDED}) && (this.eventTypes & 1) == 1) {
                    events.add(new JcrEvent(1, path.getString(JcrObservationManager.this.geNamespaceRegistry()), userId));
                } else if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_REMOVED}) && (this.eventTypes & 2) == 2) {
                    events.add(new JcrEvent(2, path.getString(JcrObservationManager.this.geNamespaceRegistry()), userId));
                }
                if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.PROPERTY_CHANGED}) && (this.eventTypes & 0x10) == 16) {
                    for (Property property : change.getModifiedProperties()) {
                        propertyPath = pathFactory.create(path, property.getName().getString(JcrObservationManager.this.geNamespaceRegistry()));
                        events.add(new JcrEvent(16, propertyPath.getString(JcrObservationManager.this.geNamespaceRegistry()), userId));
                    }
                }
                if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.PROPERTY_ADDED}) && (this.eventTypes & 4) == 4) {
                    for (Property property : change.getAddedProperties()) {
                        propertyPath = pathFactory.create(path, property.getName().getString(JcrObservationManager.this.geNamespaceRegistry()));
                        events.add(new JcrEvent(4, propertyPath.getString(JcrObservationManager.this.geNamespaceRegistry()), userId));
                    }
                }
                if (!change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.PROPERTY_REMOVED}) || (this.eventTypes & 8) != 8) continue;
                for (Name name : change.getRemovedProperties()) {
                    propertyPath = pathFactory.create(path, new Name[]{name});
                    events.add(new JcrEvent(8, propertyPath.getString(JcrObservationManager.this.geNamespaceRegistry()), userId));
                }
            }
            if (!events.isEmpty()) {
                this.delegate.onEvent((EventIterator)new JcrEventIterator((Collection<Event>)events));
            }
        }

        private boolean shouldCheckNodeType() {
            return this.nodeTypeNames != null && this.nodeTypeNames.length != 0;
        }
    }

    class JcrEvent
    implements Event {
        private final String path;
        private final int type;
        private final String userId;

        public JcrEvent(int type, String path, String userId) {
            this.type = type;
            this.path = path;
            this.userId = userId;
        }

        public String getPath() {
            return this.path;
        }

        public int getType() {
            return this.type;
        }

        public String getUserID() {
            return this.userId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.type) {
                case 1: {
                    sb.append("Node added");
                    break;
                }
                case 2: {
                    sb.append("Node removed");
                    break;
                }
                case 4: {
                    sb.append("Property added");
                    break;
                }
                case 16: {
                    sb.append("Property changed");
                    break;
                }
                case 8: {
                    sb.append("Property removed");
                }
            }
            sb.append(" at ").append(this.path).append(" by ").append(this.userId);
            return sb.toString();
        }
    }

    class JcrEventIterator
    extends JcrRangeIterator<Event>
    implements EventIterator {
        public JcrEventIterator(Collection<Event> events) {
            super(events);
        }

        public Event nextEvent() {
            return (Event)this.next();
        }
    }

    class JcrEventListenerIterator
    extends JcrRangeIterator<EventListener>
    implements EventListenerIterator {
        public JcrEventListenerIterator(Collection<EventListener> listeners) {
            super(listeners);
        }

        public EventListener nextEventListener() {
            return (EventListener)this.next();
        }
    }

    class JcrRangeIterator<E>
    implements RangeIterator {
        private final List<? extends E> elements;
        private int position = 0;

        public JcrRangeIterator(Collection<? extends E> elements) {
            CheckArg.isNotNull(elements, (String)"elements");
            this.elements = new ArrayList<E>(elements);
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.elements.size();
        }

        public boolean hasNext() {
            return this.getPosition() < this.getSize();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E element = this.elements.get(this.position);
            ++this.position;
            return element;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void skip(long skipNum) {
            this.position = (int)((long)this.position + skipNum);
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
        }
    }
}

