/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.EditableDocument;

public class IndexStorage {
    private final EditableDocument queryConfig;
    private CacheContainer cacheContainer;

    IndexStorage(EditableDocument queryConfig) {
        this.queryConfig = queryConfig;
    }

    void setDefaultValuesForIndexStorage(String dataDirPath) {
        if (this.isEnabled()) {
            EditableDocument indexStorage = this.queryConfig.getOrCreateDocument("indexStorage");
            indexStorage.set("type", (Object)"filesystem");
            indexStorage.set("location", (Object)(dataDirPath + "/indexes"));
        }
    }

    boolean useDefaultValuesForIndexStorage() {
        return !this.queryConfig.containsField("indexStorage");
    }

    public boolean isEnabled() {
        return this.queryConfig.getBoolean("enabled", true);
    }

    public EditableDocument getQueryConfiguration() {
        return this.isEnabled() ? this.queryConfig : Schematic.newDocument((String)"enabled", (Object)false);
    }

    CacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    void setCacheContainer(CacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
    }
}

