/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RegexValidator
extends ModelTypeValidator {
    private final Pattern pattern;

    public RegexValidator(String regularExpression, boolean nullable) {
        super(ModelType.STRING, nullable, true, true);
        this.pattern = Pattern.compile(regularExpression);
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        String str = value.asString();
        Matcher matcher = this.pattern.matcher(str);
        if (!matcher.matches()) {
            throw new OperationFailedException("The value '" + str + "' must satisfy the regular expression: " + this.pattern);
        }
    }
}

