/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.modeshape.jboss.subsystem.MappedAttributeDefinition;
import org.modeshape.jboss.subsystem.MappedSimpleAttributeDefinition;

public class MappedListAttributeDefinition
extends ListAttributeDefinition
implements MappedAttributeDefinition {
    private final SimpleAttributeDefinition valueType;
    private SimpleListAttributeDefinition simpleList;
    private final List<String> pathToFieldInConfiguration;
    private final List<String> pathToContainerOfFieldInConfiguration;

    protected MappedListAttributeDefinition(SimpleListAttributeDefinition simpleList, SimpleAttributeDefinition valueType, List<String> pathToFieldInConfiguration) {
        super(simpleList.getName(), simpleList.isAllowNull(), simpleList.getElementValidator());
        this.simpleList = simpleList;
        this.valueType = valueType;
        assert (pathToFieldInConfiguration != null);
        assert (pathToFieldInConfiguration.size() > 0);
        this.pathToFieldInConfiguration = pathToFieldInConfiguration;
        this.pathToContainerOfFieldInConfiguration = this.pathToFieldInConfiguration.size() > 1 ? this.pathToFieldInConfiguration.subList(0, this.pathToFieldInConfiguration.size() - 1) : Collections.emptyList();
    }

    @Override
    public List<String> getPathToField() {
        return this.pathToFieldInConfiguration;
    }

    @Override
    public List<String> getPathToContainerOfField() {
        return this.pathToContainerOfFieldInConfiguration;
    }

    @Override
    public String getFieldName() {
        return this.pathToFieldInConfiguration.get(this.pathToFieldInConfiguration.size() - 1);
    }

    @Override
    public Object getTypedValue(ModelNode node) throws OperationFailedException {
        return MappedSimpleAttributeDefinition.getTypedValue(node, (AttributeDefinition)this);
    }

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        return this.simpleList.addResourceAttributeDescription(bundle, prefix, resourceDescription);
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        return this.simpleList.addOperationParameterDescription(bundle, prefix, operationDescription);
    }

    public ParameterValidator getElementValidator() {
        return this.simpleList.getElementValidator();
    }

    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        return this.simpleList.parse(value, reader);
    }

    @Deprecated
    public ModelNode parse(String value, Location location) throws XMLStreamException {
        return this.simpleList.parse(value, location);
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        this.simpleList.marshallAsElement(resourceModel, writer);
    }

    public String getName() {
        return this.simpleList.getName();
    }

    public String getXmlName() {
        return this.simpleList.getXmlName();
    }

    public ModelType getType() {
        return this.simpleList.getType();
    }

    public boolean isAllowNull() {
        return this.simpleList.isAllowNull();
    }

    public boolean isAllowExpression() {
        return this.simpleList.isAllowExpression();
    }

    public ModelNode getDefaultValue() {
        return this.simpleList.getDefaultValue();
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.simpleList.getMeasurementUnit();
    }

    public ParameterValidator getValidator() {
        return this.simpleList.getValidator();
    }

    public String[] getAlternatives() {
        return this.simpleList.getAlternatives();
    }

    public String[] getRequires() {
        return this.simpleList.getRequires();
    }

    public EnumSet<AttributeAccess.Flag> getFlags() {
        return this.simpleList.getFlags();
    }

    public boolean isMarshallable(ModelNode resourceModel) {
        return this.simpleList.isMarshallable(resourceModel);
    }

    public void parseAndAddParameterElement(String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        this.simpleList.parseAndAddParameterElement(value, operation, reader);
    }

    public boolean isMarshallable(ModelNode resourceModel, boolean marshallDefault) {
        return this.simpleList.isMarshallable(resourceModel, marshallDefault);
    }

    public ModelNode validateOperation(ModelNode operationObject) throws OperationFailedException {
        return this.simpleList.validateOperation(operationObject);
    }

    @Deprecated
    public void parseAndAddParameterElement(String value, ModelNode operation, Location location) throws XMLStreamException {
        this.simpleList.parseAndAddParameterElement(value, operation, location);
    }

    @Deprecated
    public ModelNode validateResolvedOperation(ModelNode operationObject) throws OperationFailedException {
        return this.simpleList.validateResolvedOperation(operationObject);
    }

    public ModelNode resolveModelAttribute(OperationContext context, ModelNode model) throws OperationFailedException {
        return this.simpleList.resolveModelAttribute(context, model);
    }

    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        return this.simpleList.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle);
    }

    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        return this.simpleList.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle);
    }

    public boolean isAllowed(ModelNode operationObject) {
        return this.simpleList.isAllowed(operationObject);
    }

    public boolean isRequired(ModelNode operationObject) {
        return this.simpleList.isRequired(operationObject);
    }

    public boolean hasAlternative(ModelNode operationObject) {
        return this.simpleList.hasAlternative(operationObject);
    }

    public String getAttributeTextDescription(ResourceBundle bundle, String prefix) {
        return this.simpleList.getAttributeTextDescription(bundle, prefix);
    }

    public ModelNode getNoTextDescription(boolean forOperation) {
        return this.simpleList.getNoTextDescription(forOperation);
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        node.get(new String[]{"value-type", this.valueType.getName()}).set(this.getValueTypeDescription(false));
    }

    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode valueTypeDesc = this.getValueTypeDescription(false);
        valueTypeDesc.get("description").set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle, new String[]{this.valueType.getName()}));
        node.get(new String[]{"value-type", this.valueType.getName()}).set(valueTypeDesc);
    }

    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        ModelNode valueTypeDesc = this.getValueTypeDescription(true);
        valueTypeDesc.get("description").set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle, new String[]{this.valueType.getName()}));
        node.get(new String[]{"value-type", this.valueType.getName()}).set(valueTypeDesc);
    }

    private ModelNode getValueTypeDescription(boolean forOperation) {
        AllowedValuesValidator avv;
        List allowed;
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        ModelNode result = new ModelNode();
        result.get("type").set(this.valueType.getType());
        result.get("description");
        result.get("expressions-allowed").set(this.valueType.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!this.valueType.isAllowNull());
        }
        result.get("nillable").set(this.isAllowNull());
        ModelNode defaultValue = this.valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            result.get("default").set(defaultValue);
        }
        if ((measurementUnit = this.valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = this.valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if ((requires = this.valueType.getRequires()) != null) {
            for (String required : requires) {
                result.get("requires").add(required);
            }
        }
        if ((validator = this.valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)validator;
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        if (validator instanceof AllowedValuesValidator && (allowed = (avv = (AllowedValuesValidator)validator).getAllowedValues()) != null) {
            for (ModelNode ok : allowed) {
                result.get("allowed").add(ok);
            }
        }
        return result;
    }

    public static class Builder {
        private final SimpleAttributeDefinition valueType;
        private final SimpleListAttributeDefinition.Builder builder;
        private List<String> configPath;

        public Builder(String name, SimpleAttributeDefinition valueType) {
            this.valueType = valueType;
            this.builder = new SimpleListAttributeDefinition.Builder(name, valueType);
        }

        public static Builder of(String name, SimpleAttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        public ListAttributeDefinition build() {
            SimpleListAttributeDefinition simpleList = this.builder.build();
            if (this.configPath == null) {
                return simpleList;
            }
            return new MappedListAttributeDefinition(simpleList, this.valueType, this.configPath);
        }

        public Builder setAllowNull(boolean allowNull) {
            this.builder.setAllowNull(allowNull);
            return this;
        }

        public Builder setFlags(AttributeAccess.Flag ... flags) {
            this.builder.setFlags(flags);
            return this;
        }

        public Builder setMaxSize(int maxSize) {
            this.builder.setMaxSize(maxSize);
            return this;
        }

        public Builder setMinSize(int minSize) {
            this.builder.setMinSize(minSize);
            return this;
        }

        public Builder setRequires(String ... requires) {
            this.builder.setRequires(requires);
            return this;
        }

        public Builder setXmlName(String xmlName) {
            this.builder.setXmlName(xmlName);
            return this;
        }

        public Builder setFieldPathInRepositoryConfiguration(String ... pathToField) {
            this.configPath = Collections.unmodifiableList(Arrays.asList(pathToField));
            return this;
        }
    }
}

