/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn.mgnt;

import java.io.ByteArrayInputStream;
import org.modeshape.connector.scm.ScmAction;
import org.modeshape.connector.svn.mgnt.ISVNEditorUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

public class AddFile
implements ScmAction {
    private String path;
    private String file;
    private byte[] content;

    public AddFile(String path, String file, byte[] content) {
        this.path = path;
        this.file = file;
        this.content = content;
    }

    @Override
    public void applyAction(Object context) throws Exception {
        ISVNEditor editor = (ISVNEditor)context;
        ISVNEditorUtil.openDirectories(editor, this.path);
        if (this.file.startsWith("/")) {
            this.file = this.file.substring(1);
        }
        editor.addFile(this.path + "/" + this.file, null, -1L);
        editor.applyTextDelta(this.path + "/" + this.file, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        String checksum = deltaGenerator.sendDelta(this.path + "/" + this.file, new ByteArrayInputStream(this.content), editor, true);
        editor.closeFile(this.path + "/" + this.file, checksum);
        ISVNEditorUtil.closeDirectories(editor, this.path);
    }

    public String toString() {
        return "AddFile {" + this.path + "/" + this.file + "}";
    }
}

