/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNDebugLogger
extends SVNDebugLogAdapter {
    private Map myLoggers = new SVNHashMap();

    public void log(SVNLogType logType, Throwable th, Level logLevel) {
        Logger logger = this.getLogger(logType);
        if (logger.isLoggable(logLevel) && th != null) {
            logger.log(logLevel, this.getMessage(logType, th.getMessage()), th);
        }
    }

    public void log(SVNLogType logType, String message, Level logLevel) {
        Logger logger = this.getLogger(logType);
        if (logger.isLoggable(logLevel) && message != null) {
            logger.log(logLevel, this.getMessage(logType, message));
        }
    }

    public void log(SVNLogType logType, String message, byte[] data) {
        Logger logger = this.getLogger(logType);
        if (logger.isLoggable(Level.FINEST)) {
            try {
                logger.log(Level.FINEST, message + "\n" + new String(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.FINEST, message + "\n" + new String(data));
            }
        }
    }

    public InputStream createLogStream(SVNLogType logType, InputStream is) {
        if (this.getLogger(logType).isLoggable(Level.FINEST)) {
            return super.createLogStream(logType, is);
        }
        return is;
    }

    public OutputStream createLogStream(SVNLogType logType, OutputStream os) {
        if (this.getLogger(logType).isLoggable(Level.FINEST)) {
            return super.createLogStream(logType, os);
        }
        return os;
    }

    private Logger getLogger(SVNLogType logType) {
        Logger logger = (Logger)this.myLoggers.get(logType);
        if (logger == null) {
            logger = Logger.getLogger(logType.getName());
            this.myLoggers.put(logType, logger);
        }
        return logger;
    }

    private String getMessage(SVNLogType logType, String originalMessage) {
        return logType.getShortName() + ": " + originalMessage;
    }
}

