/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.util.LinkedList;
import org.modeshape.common.i18n.I18n;
import org.modeshape.connector.svn.SvnRepositoryConnectorI18n;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.connector.svn.SvnRepositoryUtil;
import org.modeshape.connector.svn.SvnWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathTransaction;
import org.modeshape.graph.connector.base.Processor;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.MoveBranchRequest;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnRepository
extends Repository<PathNode, SvnWorkspace> {
    protected final SvnRepositorySource source;

    public SvnRepository(SvnRepositorySource source) {
        super((BaseRepositorySource)source);
        this.source = source;
        this.initialize();
    }

    final SvnRepositorySource source() {
        return this.source;
    }

    public SvnTransaction startTransaction(ExecutionContext context, boolean readonly) {
        return new SvnTransaction();
    }

    protected SVNRepository getWorkspaceDirectory(String workspaceName) {
        if (workspaceName == null) {
            workspaceName = this.source().getDefaultWorkspaceName();
        }
        workspaceName = this.source().getRepositoryRootUrl().endsWith("/") ? this.source().getRepositoryRootUrl() + workspaceName : this.source().getRepositoryRootUrl() + "/" + workspaceName;
        SVNRepository repository = null;
        SVNRepository repos = SvnRepositoryUtil.createRepository(workspaceName, this.source().getUsername(), this.source().getPassword());
        if (!SvnRepositoryUtil.isDirectory(repos, "")) {
            return null;
        }
        repository = repos;
        return repository;
    }

    static {
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
    }

    class SvnProcessor
    extends Processor<PathNode, SvnWorkspace> {
        public SvnProcessor(Transaction<PathNode, SvnWorkspace> txn, Repository<PathNode, SvnWorkspace> repository, Observer observer, boolean updatesAllowed) {
            super(txn, repository, observer, updatesAllowed);
        }

        public void process(MoveBranchRequest request) {
            if (request.before() != null) {
                I18n msg = SvnRepositoryConnectorI18n.nodeOrderingNotSupported;
                throw new InvalidRequestException(msg.text(new Object[]{SvnRepository.this.source.getName()}));
            }
            super.process(request);
        }

        protected int absoluteMaximumDepthForBranchReads() {
            return 1;
        }
    }

    class SvnTransaction
    extends PathTransaction<PathNode, SvnWorkspace> {
        public SvnTransaction() {
            super((Repository)SvnRepository.this, SvnRepository.this.source.getRootNodeUuidObject());
        }

        protected PathNode createNode(Path.Segment name, Path parentPath, Iterable<Property> properties) {
            return new PathNode(null, parentPath, name, properties, new LinkedList());
        }

        public boolean destroyWorkspace(SvnWorkspace workspace) throws InvalidWorkspaceException {
            return true;
        }

        public SvnWorkspace getWorkspace(String name, SvnWorkspace originalToClone) throws InvalidWorkspaceException {
            SvnRepository repository = SvnRepository.this;
            if (originalToClone != null) {
                return new SvnWorkspace(name, originalToClone, repository.getWorkspaceDirectory(name));
            }
            return new SvnWorkspace(repository, SvnRepository.this.getWorkspaceDirectory(name), name, SvnRepository.this.source.getRootNodeUuidObject());
        }

        protected void validateNode(SvnWorkspace workspace, PathNode node) {
            workspace.validate(node);
        }
    }
}

