/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.meta.jdbc.AbstractMetadataRetriever;
import org.modeshape.connector.meta.jdbc.CatalogRetriever;
import org.modeshape.connector.meta.jdbc.ColumnRetriever;
import org.modeshape.connector.meta.jdbc.DatabaseRetriever;
import org.modeshape.connector.meta.jdbc.ForeignKeyRetriever;
import org.modeshape.connector.meta.jdbc.JdbcMetadataCollector;
import org.modeshape.connector.meta.jdbc.JdbcMetadataException;
import org.modeshape.connector.meta.jdbc.JdbcMetadataI18n;
import org.modeshape.connector.meta.jdbc.MetadataCollector;
import org.modeshape.connector.meta.jdbc.ProcedureRetriever;
import org.modeshape.connector.meta.jdbc.SchemaRetriever;
import org.modeshape.connector.meta.jdbc.TableRetriever;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.spi.federation.DocumentWriter;
import org.modeshape.jcr.spi.federation.ReadOnlyConnector;
import org.modeshape.schematic.document.Document;

public class JdbcMetadataConnector
extends ReadOnlyConnector {
    protected static final String DELIMITER = "/";
    protected static final String DEFAULT_NAME_OF_DEFAULT_CATALOG = "default";
    protected static final String DEFAULT_NAME_OF_DEFAULT_SCHEMA = "default";
    private static final int DEFAULT_RETRY_LIMIT = 0;
    private static final int DEFAULT_MAXIMUM_CONNECTIONS_IN_POOL = 5;
    private static final int DEFAULT_MINIMUM_CONNECTIONS_IN_POOL = 0;
    private static final int DEFAULT_MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS = 600;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_STATEMENTS_TO_CACHE = 100;
    private static final int DEFAULT_NUMBER_OF_CONNECTIONS_TO_ACQUIRE_AS_NEEDED = 1;
    private static final int DEFAULT_IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS = 180;
    protected String dataSourceJndiName;
    protected String username;
    protected String password;
    protected String url;
    protected String driverClassName;
    protected int retryLimit = 0;
    protected int maximumConnectionsInPool = 5;
    protected int minimumConnectionsInPool = 0;
    protected int maximumConnectionIdleTimeInSeconds = 600;
    protected int maximumSizeOfStatementCache = 100;
    protected int numberOfConnectionsToAcquireAsNeeded = 1;
    protected int idleTimeInSecondsBeforeTestingConnections = 180;
    protected String defaultCatalogName = "default";
    protected String defaultSchemaName = "default";
    protected String metadataCollectorClassName = JdbcMetadataCollector.class.getName();
    protected boolean closeDataSourceOnShutdown = false;
    protected DataSource dataSource;
    protected MetadataCollector metadataCollector;
    protected List<? extends AbstractMetadataRetriever> metadataRetrievers;

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.initMetadataCollector();
        this.initDataSource();
        this.initNodeTypes(nodeTypeManager);
        this.initRetrievers();
    }

    protected void initRetrievers() {
        this.metadataRetrievers = Arrays.asList(new DatabaseRetriever(this), new CatalogRetriever(this), new SchemaRetriever(this), new TableRetriever(this), new ColumnRetriever(this), new ProcedureRetriever(this), new ForeignKeyRetriever(this));
    }

    protected void initNodeTypes(NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        InputStream cndStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/modeshape/connector/meta/jdbc/metajdbc.cnd");
        nodeTypeManager.registerNodeTypes(cndStream, true);
    }

    protected void initDataSource() {
        if (this.dataSource == null && this.dataSourceJndiName != null) {
            try {
                InitialContext context = new InitialContext();
                this.dataSource = (DataSource)context.lookup(this.dataSourceJndiName);
            }
            catch (Throwable t) {
                this.getLogger().error(t, (I18nResource)JdbcMetadataI18n.errorFindingDataSourceInJndi, new Object[]{this.getSourceName(), this.dataSourceJndiName});
            }
        }
        if (this.dataSource == null) {
            if (StringUtil.isBlank((String)this.url) || StringUtil.isBlank((String)this.driverClassName)) {
                throw new JdbcMetadataException(JdbcMetadataI18n.driverClassNameAndUrlAreRequired, "driverClassName", "url");
            }
            HikariDataSource dataSource = new HikariDataSource();
            dataSource.setDriverClassName(this.driverClassName);
            dataSource.setJdbcUrl(this.url);
            dataSource.setUsername(this.username);
            dataSource.setPassword(this.password);
            dataSource.setMaximumPoolSize(this.maximumConnectionsInPool);
            dataSource.setIdleTimeout((long)(this.maximumConnectionIdleTimeInSeconds * 1000));
            this.dataSource = dataSource;
        }
    }

    protected void initMetadataCollector() {
        try {
            Class<?> newCollectorClass = Class.forName(this.metadataCollectorClassName, true, this.getEnvironment().getClassLoader((Object)this, new String[0]));
            this.metadataCollector = (MetadataCollector)newCollectorClass.newInstance();
        }
        catch (Exception e) {
            throw new JdbcMetadataException(e);
        }
    }

    public Document getDocumentById(String id) {
        DocumentWriter writer = this.newDocument(id);
        for (AbstractMetadataRetriever abstractMetadataRetriever : this.metadataRetrievers) {
            if (!abstractMetadataRetriever.canHandle(id)) continue;
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                Document document = abstractMetadataRetriever.getDocumentById(id, writer, connection);
                return document;
            }
            catch (SQLException e) {
                throw new JdbcMetadataException(JdbcMetadataI18n.errorObtainingConnection, e, new Object[0]);
            }
            finally {
                this.tryToClose(connection);
            }
        }
        return null;
    }

    protected void tryToClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException closeException) {
                this.getLogger().debug("Cannot close JDBC connection", new Object[]{closeException});
            }
        }
    }

    public String getDocumentId(String externalPath) {
        externalPath = this.trimPath(externalPath);
        for (AbstractMetadataRetriever abstractMetadataRetriever : this.metadataRetrievers) {
            String documentId = abstractMetadataRetriever.idFrom(externalPath);
            if (documentId == null) continue;
            return documentId;
        }
        return null;
    }

    public Collection<String> getDocumentPathsById(String id) {
        return Collections.singletonList(id);
    }

    protected String trimPath(String externalPath) {
        if (externalPath.trim().equalsIgnoreCase(DELIMITER)) {
            return DELIMITER;
        }
        if (externalPath.endsWith(DELIMITER)) {
            return externalPath.substring(0, externalPath.length() - 1);
        }
        return externalPath;
    }

    public boolean hasDocument(String id) {
        for (AbstractMetadataRetriever abstractMetadataRetriever : this.metadataRetrievers) {
            if (!abstractMetadataRetriever.canHandle(id)) continue;
            return true;
        }
        return false;
    }

    public void shutdown() {
        if (this.closeDataSourceOnShutdown && this.dataSource instanceof HikariDataSource) {
            ((HikariDataSource)this.dataSource).close();
        }
    }

    protected MetadataCollector getMetadataCollector() {
        return this.metadataCollector;
    }

    protected String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    protected String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    protected void setRetryLimit(Integer retryLimit) {
        if (retryLimit != null) {
            this.retryLimit = retryLimit;
        }
    }

    protected void setMaximumConnectionsInPool(Integer maximumConnectionsInPool) {
        if (maximumConnectionsInPool != null) {
            this.maximumConnectionsInPool = maximumConnectionsInPool;
        }
    }

    protected void setMinimumConnectionsInPool(Integer minimumConnectionsInPool) {
        if (minimumConnectionsInPool != null) {
            this.minimumConnectionsInPool = minimumConnectionsInPool;
        }
    }

    protected void setMaximumConnectionIdleTimeInSeconds(Integer maximumConnectionIdleTimeInSeconds) {
        if (maximumConnectionIdleTimeInSeconds != null) {
            this.maximumConnectionIdleTimeInSeconds = maximumConnectionIdleTimeInSeconds;
        }
    }

    protected void setMaximumSizeOfStatementCache(Integer maximumSizeOfStatementCache) {
        if (maximumSizeOfStatementCache != null) {
            this.maximumSizeOfStatementCache = maximumSizeOfStatementCache;
        }
    }

    protected void setNumberOfConnectionsToAcquireAsNeeded(Integer numberOfConnectionsToAcquireAsNeeded) {
        if (numberOfConnectionsToAcquireAsNeeded != null) {
            this.numberOfConnectionsToAcquireAsNeeded = numberOfConnectionsToAcquireAsNeeded;
        }
    }

    protected void setIdleTimeInSecondsBeforeTestingConnections(Integer idleTimeInSecondsBeforeTestingConnections) {
        if (idleTimeInSecondsBeforeTestingConnections != null) {
            this.idleTimeInSecondsBeforeTestingConnections = idleTimeInSecondsBeforeTestingConnections;
        }
    }

    protected void setDefaultCatalogName(String defaultCatalogName) {
        if (defaultCatalogName != null) {
            this.defaultCatalogName = defaultCatalogName;
        }
    }

    protected void setDefaultSchemaName(String defaultSchemaName) {
        if (defaultSchemaName != null) {
            this.defaultSchemaName = defaultSchemaName;
        }
    }

    protected void setMetadataCollectorClassName(String metadataCollectorClassName) {
        if (metadataCollectorClassName != null) {
            this.metadataCollectorClassName = metadataCollectorClassName;
        }
    }
}

