/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.meta.jdbc.AbstractMetadataRetriever;
import org.modeshape.connector.meta.jdbc.CatalogRetriever;
import org.modeshape.connector.meta.jdbc.JdbcMetadataConnector;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.ProcedureMetadata;
import org.modeshape.connector.meta.jdbc.ProcedureRetriever;
import org.modeshape.connector.meta.jdbc.TableMetadata;
import org.modeshape.connector.meta.jdbc.TableRetriever;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.spi.federation.DocumentWriter;

public class SchemaRetriever
extends AbstractMetadataRetriever {
    private static final Pattern SCHEMA_PATH_PATTERN = Pattern.compile("/([^/]+)/([^/]+)/([^/]+)");
    private static final Pattern SCHEMA_ID_PATTERN = Pattern.compile("([^@]+)@([^@]+)@([^@]+)");
    static final Pattern TABLES_PATH_PATTERN = Pattern.compile(SCHEMA_PATH_PATTERN.pattern() + "/tables");
    static final String TABLES_CONTAINER = "tables";
    private static final Pattern TABLES_ID_PATTERN = Pattern.compile(SCHEMA_ID_PATTERN.pattern() + "@" + "tables");
    static final Pattern PROCEDURES_PATH_PATTERN = Pattern.compile(SCHEMA_PATH_PATTERN.pattern() + "/procedures");
    static final String PROCEDURES_CONTAINER = "procedures";
    private static final Pattern PROCEDURES_ID_PATTERN = Pattern.compile(SCHEMA_ID_PATTERN + "@" + "procedures");

    protected SchemaRetriever(JdbcMetadataConnector connector) {
        super(connector);
    }

    @Override
    protected Document getDocumentById(String id, DocumentWriter writer, Connection connection) {
        String schemaId = SchemaRetriever.schemaIdFrom(id, SCHEMA_ID_PATTERN);
        if (schemaId != null) {
            String catalogId = SchemaRetriever.catalogIdFrom(id, SCHEMA_ID_PATTERN);
            return this.createDocumentForSchema(writer, catalogId, schemaId);
        }
        String schemaIdFromTable = SchemaRetriever.schemaIdFrom(id, TABLES_ID_PATTERN);
        if (schemaIdFromTable != null) {
            String catalogId = SchemaRetriever.catalogIdFrom(id, TABLES_ID_PATTERN);
            return this.createDocumentForAllTables(writer, connection, catalogId, schemaIdFromTable);
        }
        String schemaIdFromProcedures = SchemaRetriever.schemaIdFrom(id, PROCEDURES_ID_PATTERN);
        if (schemaIdFromProcedures != null) {
            String catalogId = SchemaRetriever.catalogIdFrom(id, PROCEDURES_ID_PATTERN);
            return this.createDocumentForAllProcedures(writer, connection, catalogId, schemaIdFromProcedures);
        }
        return null;
    }

    private Document createDocumentForAllProcedures(DocumentWriter writer, Connection connection, String catalogId, String schemaId) {
        List<ProcedureMetadata> procedures;
        String schema;
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.PROCEDURES);
        writer.setParent(SchemaRetriever.documentId("databaseRoot", catalogId, schemaId, false, false));
        String catalog = catalogId;
        if (catalog.equalsIgnoreCase(this.connector.getDefaultCatalogName())) {
            catalog = null;
        }
        if ((schema = schemaId).equalsIgnoreCase(this.connector.getDefaultSchemaName())) {
            schema = null;
        }
        if (!(procedures = this.connector.getMetadataCollector().getProcedures(connection, catalog, schema, null)).isEmpty()) {
            for (ProcedureMetadata procedureMetadata : procedures) {
                String procedureId = ProcedureRetriever.documentId("databaseRoot", catalogId, schemaId, procedureMetadata.getName());
                writer.addChild(procedureId, procedureMetadata.getName());
            }
        }
        return writer.document();
    }

    private Document createDocumentForAllTables(DocumentWriter writer, Connection connection, String catalogId, String schemaId) {
        List<TableMetadata> tables;
        String schema;
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.TABLES);
        writer.setParent(SchemaRetriever.documentId("databaseRoot", catalogId, schemaId, false, false));
        String catalog = catalogId;
        if (catalog.equalsIgnoreCase(this.connector.getDefaultCatalogName())) {
            catalog = null;
        }
        if ((schema = schemaId).equalsIgnoreCase(this.connector.getDefaultSchemaName())) {
            schema = null;
        }
        if (!(tables = this.connector.getMetadataCollector().getTables(connection, catalog, schema, null)).isEmpty()) {
            for (TableMetadata tableMetadata : tables) {
                String tableId = TableRetriever.documentId("databaseRoot", catalogId, schemaId, tableMetadata.getName(), false);
                writer.addChild(tableId, tableMetadata.getName());
            }
        }
        return writer.document();
    }

    private Document createDocumentForSchema(DocumentWriter writer, String catalogId, String schemaId) {
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.SCHEMA);
        writer.setParent(CatalogRetriever.documentId("databaseRoot", catalogId));
        writer.addChild(SchemaRetriever.documentId("databaseRoot", catalogId, schemaId, true, false), TABLES_CONTAINER);
        writer.addChild(SchemaRetriever.documentId("databaseRoot", catalogId, schemaId, false, true), PROCEDURES_CONTAINER);
        return writer.document();
    }

    static String catalogIdFrom(String id, Pattern pattern) {
        Matcher matcher = pattern.matcher(id);
        return matcher.matches() ? matcher.group(2) : null;
    }

    static String schemaIdFrom(String id, Pattern pattern) {
        Matcher matcher = pattern.matcher(id);
        return matcher.matches() ? matcher.group(3) : null;
    }

    @Override
    protected String idFrom(String path) {
        Matcher namedSchemaMatcher = SCHEMA_PATH_PATTERN.matcher(path);
        if (namedSchemaMatcher.matches()) {
            return SchemaRetriever.documentId(namedSchemaMatcher.group(1), namedSchemaMatcher.group(2), namedSchemaMatcher.group(3), false, false);
        }
        Matcher tablesMatcher = TABLES_PATH_PATTERN.matcher(path);
        if (tablesMatcher.matches()) {
            return SchemaRetriever.documentId(tablesMatcher.group(1), tablesMatcher.group(2), tablesMatcher.group(3), true, false);
        }
        Matcher proceduresMatcher = PROCEDURES_PATH_PATTERN.matcher(path);
        if (proceduresMatcher.matches()) {
            return SchemaRetriever.documentId(proceduresMatcher.group(1), proceduresMatcher.group(2), proceduresMatcher.group(3), false, true);
        }
        return null;
    }

    @Override
    protected boolean canHandle(String id) {
        return SCHEMA_ID_PATTERN.matcher(id).matches() || TABLES_ID_PATTERN.matcher(id).matches() || PROCEDURES_ID_PATTERN.matcher(id).matches();
    }

    static String documentId(String databaseId, String catalogId, String schemaId, boolean onlyTables, boolean onlyProcedures) {
        String baseId = SchemaRetriever.generateId(databaseId, catalogId, schemaId);
        if (onlyTables) {
            return SchemaRetriever.generateId(baseId, TABLES_CONTAINER);
        }
        if (onlyProcedures) {
            return SchemaRetriever.generateId(baseId, PROCEDURES_CONTAINER);
        }
        return baseId;
    }
}

