/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.meta.jdbc.AbstractMetadataRetriever;
import org.modeshape.connector.meta.jdbc.CatalogRetriever;
import org.modeshape.connector.meta.jdbc.DBMetadata;
import org.modeshape.connector.meta.jdbc.JdbcMetadataConnector;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.MetadataCollector;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.federation.spi.DocumentWriter;

public final class DatabaseRetriever
extends AbstractMetadataRetriever {
    protected static final String ID = "databaseRoot";
    private static final Pattern ROOT_DB_PATTERN = Pattern.compile("/[^/]*");

    protected DatabaseRetriever(JdbcMetadataConnector connector) {
        super(connector);
    }

    @Override
    protected Document getDocumentById(String id, DocumentWriter writer, Connection connection) {
        MetadataCollector metadataCollector = this.connector.getMetadataCollector();
        DBMetadata dbMetadata = metadataCollector.getDatabaseMetadata(connection);
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.DATABASE_ROOT);
        writer.addProperty(JdbcMetadataLexicon.DATABASE_PRODUCT_NAME, (Object)dbMetadata.getDatabaseProductName());
        writer.addProperty(JdbcMetadataLexicon.DATABASE_PRODUCT_VERSION, (Object)dbMetadata.getDatabaseProductVersion());
        writer.addProperty(JdbcMetadataLexicon.DATABASE_MAJOR_VERSION, (Object)dbMetadata.getDatabaseMajorVersion());
        writer.addProperty(JdbcMetadataLexicon.DATABASE_MINOR_VERSION, (Object)dbMetadata.getDatabaseMinorVersion());
        List<String> catalogs = this.removeEmptyOrNullElements(metadataCollector.getCatalogNames(connection));
        if (catalogs.isEmpty()) {
            catalogs.add(this.connector.getDefaultCatalogName());
        }
        for (String catalogName : catalogs) {
            writer.addChild(CatalogRetriever.documentId(id, catalogName), catalogName);
        }
        return writer.document();
    }

    @Override
    protected String idFrom(String path) {
        if (ROOT_DB_PATTERN.matcher(path).matches()) {
            return ID;
        }
        return null;
    }

    @Override
    protected boolean canHandle(String id) {
        return id.toLowerCase().equalsIgnoreCase(ID);
    }
}

