/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.meta.jdbc.ColumnMetadata;
import org.modeshape.connector.meta.jdbc.JdbcMetadataException;
import org.modeshape.connector.meta.jdbc.JdbcMetadataI18n;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.JdbcMetadataSource;
import org.modeshape.connector.meta.jdbc.MetadataCollector;
import org.modeshape.connector.meta.jdbc.ProcedureMetadata;
import org.modeshape.connector.meta.jdbc.TableMetadata;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.LockFailedException;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.path.DefaultPathNode;
import org.modeshape.graph.connector.path.PathNode;
import org.modeshape.graph.connector.path.PathRepository;
import org.modeshape.graph.connector.path.PathRepositorySource;
import org.modeshape.graph.connector.path.PathWorkspace;
import org.modeshape.graph.connector.path.cache.WorkspaceCache;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.LockBranchRequest;

@ThreadSafe
public class JdbcMetadataRepository
extends PathRepository {
    public static final String TABLES_SEGMENT_NAME = "tables";
    public static final String PROCEDURES_SEGMENT_NAME = "procedures";
    private static final Logger LOGGER = Logger.getLogger(JdbcMetadataRepository.class);
    private final JdbcMetadataSource source;
    private Map<Name, Property> rootNodeProperties;
    private String databaseProductName;
    private String databaseProductVersion;
    private int databaseMajorVersion;
    private int databaseMinorVersion;

    public JdbcMetadataRepository(JdbcMetadataSource source) {
        super((PathRepositorySource)source);
        this.source = source;
        this.initialize();
    }

    protected synchronized void initialize() {
        if (!this.workspaces.isEmpty()) {
            return;
        }
        String defaultWorkspaceName = this.getDefaultWorkspaceName();
        this.workspaces.put(defaultWorkspaceName, new JdbcMetadataWorkspace(defaultWorkspaceName));
        ExecutionContext context = this.source.getRepositoryContext().getExecutionContext();
        PropertyFactory propFactory = context.getPropertyFactory();
        this.rootNodeProperties = new HashMap<Name, Property>();
        Connection conn = this.getConnection();
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            this.databaseProductName = dmd.getDatabaseProductName();
            this.databaseProductVersion = dmd.getDatabaseProductVersion();
            this.databaseMajorVersion = dmd.getDatabaseMajorVersion();
            this.databaseMinorVersion = dmd.getDatabaseMinorVersion();
            Name propName = JdbcMetadataLexicon.DATABASE_PRODUCT_NAME;
            this.rootNodeProperties.put(propName, propFactory.create(propName, new Object[]{this.databaseProductName}));
            propName = JdbcMetadataLexicon.DATABASE_PRODUCT_VERSION;
            this.rootNodeProperties.put(propName, propFactory.create(propName, new Object[]{this.databaseProductVersion}));
            propName = JdbcMetadataLexicon.DATABASE_MAJOR_VERSION;
            this.rootNodeProperties.put(propName, propFactory.create(propName, new Object[]{this.databaseMajorVersion}));
            propName = JdbcMetadataLexicon.DATABASE_MINOR_VERSION;
            this.rootNodeProperties.put(propName, propFactory.create(propName, new Object[]{this.databaseMinorVersion}));
            this.rootNodeProperties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.ROOT}));
            this.rootNodeProperties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.DATABASE_ROOT}));
            this.rootNodeProperties = Collections.unmodifiableMap(this.rootNodeProperties);
        }
        catch (SQLException se) {
            throw new IllegalStateException(JdbcMetadataI18n.couldNotGetDatabaseMetadata.text(new Object[0]), se);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public WorkspaceCache getCache(String workspaceName) {
        return this.source.getPathRepositoryCache().getCache(workspaceName);
    }

    Connection getConnection() {
        try {
            return this.source.getDataSource().getConnection();
        }
        catch (SQLException se) {
            throw new IllegalStateException(JdbcMetadataI18n.errorObtainingConnection.text(new Object[0]), se);
        }
    }

    void closeConnection(Connection connection) {
        assert (connection != null);
        try {
            connection.close();
        }
        catch (SQLException se) {
            LOGGER.error((Throwable)se, JdbcMetadataI18n.errorClosingConnection, new Object[0]);
        }
    }

    private class RootNode
    implements PathNode {
        private final List<Path.Segment> catalogNames;

        private RootNode(List<Path.Segment> catalogNames) {
            this.catalogNames = catalogNames;
        }

        public List<Path.Segment> getChildSegments() {
            return this.catalogNames;
        }

        public Path getPath() {
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            return context.getValueFactories().getPathFactory().createRootPath();
        }

        public UUID getUuid() {
            return JdbcMetadataRepository.this.source.getRootNodeUuid();
        }

        public Map<Name, Property> getProperties() {
            return JdbcMetadataRepository.this.rootNodeProperties;
        }

        public Property getProperty(ExecutionContext context, String name) {
            NameFactory nameFactory = context.getValueFactories().getNameFactory();
            return (Property)JdbcMetadataRepository.this.rootNodeProperties.get(nameFactory.create(name));
        }

        public Property getProperty(Name name) {
            return (Property)JdbcMetadataRepository.this.rootNodeProperties.get(name);
        }

        public Set<Name> getUniqueChildNames() {
            HashSet<Name> childNames = new HashSet<Name>(this.catalogNames.size());
            for (Path.Segment catalogName : this.catalogNames) {
                childNames.add(catalogName.getName());
            }
            return childNames;
        }
    }

    @ThreadSafe
    private class JdbcMetadataWorkspace
    implements PathWorkspace {
        private final String name;
        private final WorkspaceCache cache;

        JdbcMetadataWorkspace(String name) {
            this.name = name;
            this.cache = JdbcMetadataRepository.this.getCache(name);
        }

        public Path getLowestExistingPath(Path path) {
            PathFactory pathFactory = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext().getValueFactories().getPathFactory();
            Path lastWorkingPath = pathFactory.createRootPath();
            for (Path.Segment segment : path.getSegmentsList()) {
                Path newPathToTry = pathFactory.create(lastWorkingPath, new Path.Segment[]{segment});
                try {
                    this.getNode(newPathToTry);
                    lastWorkingPath = newPathToTry;
                }
                catch (PathNotFoundException pnfe) {
                    return lastWorkingPath;
                }
            }
            return path;
        }

        public String getName() {
            return this.name;
        }

        public PathNode getNode(Path path) {
            assert (path != null);
            PathNode node = this.cache.get(path);
            if (node != null) {
                return node;
            }
            List segments = path.getSegmentsList();
            switch (segments.size()) {
                case 0: {
                    node = this.getRoot();
                    break;
                }
                case 1: {
                    node = this.catalogNodeFor(segments);
                    break;
                }
                case 2: {
                    node = this.schemaNodeFor(segments);
                    break;
                }
                case 3: {
                    if (JdbcMetadataRepository.TABLES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) {
                        node = this.tablesNodeFor(segments);
                        break;
                    }
                    if (!JdbcMetadataRepository.PROCEDURES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) break;
                    node = this.proceduresNodeFor(segments);
                    break;
                }
                case 4: {
                    if (JdbcMetadataRepository.TABLES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) {
                        node = this.tableNodeFor(segments);
                        break;
                    }
                    if (!JdbcMetadataRepository.PROCEDURES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) break;
                    node = this.procedureNodeFor(segments);
                    break;
                }
                case 5: {
                    if (!JdbcMetadataRepository.TABLES_SEGMENT_NAME.equals(((Path.Segment)segments.get(2)).getName().getLocalName())) break;
                    node = this.columnNodeFor(segments);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (node != null) {
                this.cache.set(node);
            }
            return node;
        }

        private PathNode catalogNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
            assert (segments != null);
            assert (segments.size() == 1);
            LinkedList<Path.Segment> schemaNames = new LinkedList<Path.Segment>();
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            PropertyFactory propFactory = context.getPropertyFactory();
            Path nodePath = pathFactory.createAbsolutePath(segments);
            Connection conn = JdbcMetadataRepository.this.getConnection();
            String catalogName = segments.get(0).getName().getLocalName();
            try {
                List<String> catalogNames;
                boolean catalogMatchesDefaultName;
                MetadataCollector meta = JdbcMetadataRepository.this.source.getMetadataCollector();
                if (catalogName.equals(JdbcMetadataRepository.this.source.getDefaultCatalogName())) {
                    catalogName = null;
                }
                boolean bl = catalogMatchesDefaultName = (catalogNames = meta.getCatalogNames(conn)).isEmpty() || catalogNames.contains("");
                if (catalogName != null && !catalogNames.contains(catalogName) || catalogName == null && !catalogMatchesDefaultName) {
                    PathNode pathNode = null;
                    return pathNode;
                }
                ArrayList<String> schemaNamesFromMeta = new ArrayList<String>(meta.getSchemaNames(conn, catalogName));
                for (String schemaName : schemaNamesFromMeta) {
                    if (schemaName.length() <= 0) continue;
                    schemaNames.add(pathFactory.createSegment(schemaName));
                }
                if (schemaNames.isEmpty()) {
                    schemaNames.add(pathFactory.createSegment(JdbcMetadataRepository.this.source.getDefaultSchemaName()));
                }
                HashMap<Name, Property> properties = new HashMap<Name, Property>();
                properties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
                properties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.CATALOG}));
                DefaultPathNode defaultPathNode = new DefaultPathNode(nodePath, null, properties, schemaNames);
                return defaultPathNode;
            }
            catch (JdbcMetadataException se) {
                throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetSchemaNames.text(new Object[]{catalogName}), (Throwable)se);
            }
            finally {
                JdbcMetadataRepository.this.closeConnection(conn);
            }
        }

        private PathNode schemaNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
            String schemaName;
            assert (segments != null);
            assert (segments.size() == 2);
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            PropertyFactory propFactory = context.getPropertyFactory();
            Path nodePath = pathFactory.createAbsolutePath(segments);
            Connection conn = JdbcMetadataRepository.this.getConnection();
            String catalogName = segments.get(0).getName().getLocalName();
            if (catalogName.equals(JdbcMetadataRepository.this.source.getDefaultCatalogName())) {
                catalogName = null;
            }
            if ((schemaName = segments.get(1).getName().getLocalName()).equals(JdbcMetadataRepository.this.source.getDefaultSchemaName())) {
                schemaName = null;
            }
            try {
                MetadataCollector meta = JdbcMetadataRepository.this.source.getMetadataCollector();
                List<String> schemaNames = meta.getSchemaNames(conn, catalogName);
                if (schemaName != null && !schemaNames.contains(schemaName) || schemaName == null && !schemaNames.isEmpty()) {
                    PathNode pathNode = null;
                    return pathNode;
                }
                HashMap<Name, Property> properties = new HashMap<Name, Property>();
                properties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
                properties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.SCHEMA}));
                Path.Segment[] children = new Path.Segment[]{pathFactory.createSegment(JdbcMetadataRepository.TABLES_SEGMENT_NAME), pathFactory.createSegment(JdbcMetadataRepository.PROCEDURES_SEGMENT_NAME)};
                DefaultPathNode defaultPathNode = new DefaultPathNode(nodePath, null, properties, Arrays.asList(children));
                return defaultPathNode;
            }
            catch (JdbcMetadataException se) {
                throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetSchemaNames.text(new Object[]{catalogName}), (Throwable)se);
            }
            finally {
                JdbcMetadataRepository.this.closeConnection(conn);
            }
        }

        private PathNode tablesNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
            String schemaName;
            assert (segments != null);
            assert (segments.size() == 3);
            assert (JdbcMetadataRepository.TABLES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            PropertyFactory propFactory = context.getPropertyFactory();
            Path nodePath = pathFactory.createAbsolutePath(segments);
            Connection conn = JdbcMetadataRepository.this.getConnection();
            String catalogName = segments.get(0).getName().getLocalName();
            if (catalogName.equals(JdbcMetadataRepository.this.source.getDefaultCatalogName())) {
                catalogName = null;
            }
            if ((schemaName = segments.get(1).getName().getLocalName()).equals(JdbcMetadataRepository.this.source.getDefaultSchemaName())) {
                schemaName = null;
            }
            try {
                MetadataCollector meta = JdbcMetadataRepository.this.source.getMetadataCollector();
                List<String> schemaNames = meta.getSchemaNames(conn, catalogName);
                if (schemaName != null && !schemaNames.contains(schemaName) || schemaName == null && !schemaNames.isEmpty()) {
                    PathNode pathNode = null;
                    return pathNode;
                }
                HashMap<Name, Property> properties = new HashMap<Name, Property>();
                properties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
                properties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.TABLES}));
                List<TableMetadata> tables = meta.getTables(conn, catalogName, schemaName, null);
                ArrayList<Path.Segment> children = new ArrayList<Path.Segment>(tables.size());
                for (TableMetadata table : tables) {
                    children.add(pathFactory.createSegment(table.getName()));
                }
                DefaultPathNode defaultPathNode = new DefaultPathNode(nodePath, null, properties, children);
                return defaultPathNode;
            }
            catch (JdbcMetadataException se) {
                throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetTableNames.text(new Object[]{catalogName, schemaName}), (Throwable)se);
            }
            finally {
                JdbcMetadataRepository.this.closeConnection(conn);
            }
        }

        private PathNode tableNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
            String schemaName;
            assert (segments != null);
            assert (segments.size() == 4);
            assert (JdbcMetadataRepository.TABLES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            PropertyFactory propFactory = context.getPropertyFactory();
            Path nodePath = pathFactory.createAbsolutePath(segments);
            Connection conn = JdbcMetadataRepository.this.getConnection();
            String catalogName = segments.get(0).getName().getLocalName();
            if (catalogName.equals(JdbcMetadataRepository.this.source.getDefaultCatalogName())) {
                catalogName = null;
            }
            if ((schemaName = segments.get(1).getName().getLocalName()).equals(JdbcMetadataRepository.this.source.getDefaultSchemaName())) {
                schemaName = null;
            }
            String tableName = segments.get(3).getName().getLocalName();
            try {
                MetadataCollector meta = JdbcMetadataRepository.this.source.getMetadataCollector();
                List<TableMetadata> tables = meta.getTables(conn, catalogName, schemaName, tableName);
                if (tables.isEmpty()) {
                    PathNode pathNode = null;
                    return pathNode;
                }
                assert (tables.size() == 1);
                TableMetadata table = tables.get(0);
                HashMap<Name, Property> properties = new HashMap<Name, Property>();
                Name propName = JcrLexicon.PRIMARY_TYPE;
                properties.put(propName, propFactory.create(propName, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
                propName = JcrLexicon.MIXIN_TYPES;
                properties.put(propName, propFactory.create(propName, new Object[]{JdbcMetadataLexicon.TABLE}));
                if (table.getType() != null) {
                    propName = JdbcMetadataLexicon.TABLE_TYPE;
                    properties.put(propName, propFactory.create(propName, new Object[]{table.getType()}));
                }
                if (table.getDescription() != null) {
                    propName = JdbcMetadataLexicon.DESCRIPTION;
                    properties.put(propName, propFactory.create(propName, new Object[]{table.getDescription()}));
                }
                if (table.getTypeCatalogName() != null) {
                    propName = JdbcMetadataLexicon.TYPE_CATALOG_NAME;
                    properties.put(propName, propFactory.create(propName, new Object[]{table.getTypeCatalogName()}));
                }
                if (table.getTypeSchemaName() != null) {
                    propName = JdbcMetadataLexicon.TYPE_SCHEMA_NAME;
                    properties.put(propName, propFactory.create(propName, new Object[]{table.getTypeSchemaName()}));
                }
                if (table.getTypeName() != null) {
                    propName = JdbcMetadataLexicon.TYPE_NAME;
                    properties.put(propName, propFactory.create(propName, new Object[]{table.getTypeName()}));
                }
                if (table.getSelfReferencingColumnName() != null) {
                    propName = JdbcMetadataLexicon.SELF_REFERENCING_COLUMN_NAME;
                    properties.put(propName, propFactory.create(propName, new Object[]{table.getSelfReferencingColumnName()}));
                }
                if (table.getReferenceGenerationStrategyName() != null) {
                    propName = JdbcMetadataLexicon.REFERENCE_GENERATION_STRATEGY_NAME;
                    properties.put(propName, propFactory.create(propName, new Object[]{table.getReferenceGenerationStrategyName()}));
                }
                List<ColumnMetadata> columns = meta.getColumns(conn, catalogName, schemaName, tableName, null);
                ArrayList<Path.Segment> children = new ArrayList<Path.Segment>(columns.size());
                for (ColumnMetadata column : columns) {
                    children.add(pathFactory.createSegment(column.getName()));
                }
                DefaultPathNode defaultPathNode = new DefaultPathNode(nodePath, null, properties, children);
                return defaultPathNode;
            }
            catch (JdbcMetadataException se) {
                throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetTable.text(new Object[]{catalogName, schemaName, tableName}), (Throwable)se);
            }
            finally {
                JdbcMetadataRepository.this.closeConnection(conn);
            }
        }

        private PathNode proceduresNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
            String schemaName;
            assert (segments != null);
            assert (segments.size() == 3);
            assert (JdbcMetadataRepository.PROCEDURES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            PropertyFactory propFactory = context.getPropertyFactory();
            Path nodePath = pathFactory.createAbsolutePath(segments);
            Connection conn = JdbcMetadataRepository.this.getConnection();
            String catalogName = segments.get(0).getName().getLocalName();
            if (catalogName.equals(JdbcMetadataRepository.this.source.getDefaultCatalogName())) {
                catalogName = null;
            }
            if ((schemaName = segments.get(1).getName().getLocalName()).equals(JdbcMetadataRepository.this.source.getDefaultSchemaName())) {
                schemaName = null;
            }
            try {
                MetadataCollector meta = JdbcMetadataRepository.this.source.getMetadataCollector();
                List<String> schemaNames = meta.getSchemaNames(conn, catalogName);
                if (schemaName != null && !schemaNames.contains(schemaName) || schemaName == null && !schemaNames.isEmpty()) {
                    PathNode pathNode = null;
                    return pathNode;
                }
                HashMap<Name, Property> properties = new HashMap<Name, Property>();
                properties.put(JcrLexicon.PRIMARY_TYPE, propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
                properties.put(JcrLexicon.MIXIN_TYPES, propFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{JdbcMetadataLexicon.PROCEDURES}));
                List<ProcedureMetadata> procedures = meta.getProcedures(conn, catalogName, schemaName, null);
                ArrayList<Path.Segment> children = new ArrayList<Path.Segment>(procedures.size());
                for (ProcedureMetadata procedure : procedures) {
                    children.add(pathFactory.createSegment(procedure.getName()));
                }
                DefaultPathNode defaultPathNode = new DefaultPathNode(nodePath, null, properties, children);
                return defaultPathNode;
            }
            catch (JdbcMetadataException se) {
                throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetProcedureNames.text(new Object[]{catalogName, schemaName}), (Throwable)se);
            }
            finally {
                JdbcMetadataRepository.this.closeConnection(conn);
            }
        }

        private PathNode procedureNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
            String schemaName;
            assert (segments != null);
            assert (segments.size() == 4);
            assert (JdbcMetadataRepository.PROCEDURES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            PropertyFactory propFactory = context.getPropertyFactory();
            Path nodePath = pathFactory.createAbsolutePath(segments);
            Connection conn = JdbcMetadataRepository.this.getConnection();
            String catalogName = segments.get(0).getName().getLocalName();
            if (catalogName.equals(JdbcMetadataRepository.this.source.getDefaultCatalogName())) {
                catalogName = null;
            }
            if ((schemaName = segments.get(1).getName().getLocalName()).equals(JdbcMetadataRepository.this.source.getDefaultSchemaName())) {
                schemaName = null;
            }
            String procedureName = segments.get(3).getName().getLocalName();
            try {
                MetadataCollector meta = JdbcMetadataRepository.this.source.getMetadataCollector();
                List<ProcedureMetadata> procedures = meta.getProcedures(conn, catalogName, schemaName, procedureName);
                if (procedures.isEmpty()) {
                    PathNode pathNode = null;
                    return pathNode;
                }
                if (segments.get(3).getIndex() > procedures.size()) {
                    PathNode pathNode = null;
                    return pathNode;
                }
                ProcedureMetadata procedure = procedures.get(segments.get(3).getIndex() - 1);
                HashMap<Name, Property> properties = new HashMap<Name, Property>();
                Name propName = JcrLexicon.PRIMARY_TYPE;
                properties.put(propName, propFactory.create(propName, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
                propName = JcrLexicon.MIXIN_TYPES;
                properties.put(propName, propFactory.create(propName, new Object[]{JdbcMetadataLexicon.PROCEDURE}));
                if (procedure.getDescription() != null) {
                    propName = JdbcMetadataLexicon.DESCRIPTION;
                    properties.put(propName, propFactory.create(propName, new Object[]{procedure.getDescription()}));
                }
                propName = JdbcMetadataLexicon.PROCEDURE_RETURN_TYPE;
                properties.put(propName, propFactory.create(propName, new Object[]{procedure.getType()}));
                DefaultPathNode defaultPathNode = new DefaultPathNode(nodePath, null, properties, Collections.emptyList());
                return defaultPathNode;
            }
            catch (JdbcMetadataException se) {
                throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetProcedure.text(new Object[]{catalogName, schemaName, procedureName}), (Throwable)se);
            }
            finally {
                JdbcMetadataRepository.this.closeConnection(conn);
            }
        }

        private PathNode columnNodeFor(List<Path.Segment> segments) throws RepositorySourceException {
            String schemaName;
            assert (segments != null);
            assert (segments.size() == 5);
            assert (JdbcMetadataRepository.TABLES_SEGMENT_NAME.equals(segments.get(2).getName().getLocalName()));
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            PropertyFactory propFactory = context.getPropertyFactory();
            Path nodePath = pathFactory.createAbsolutePath(segments);
            Connection conn = JdbcMetadataRepository.this.getConnection();
            String catalogName = segments.get(0).getName().getLocalName();
            if (catalogName.equals(JdbcMetadataRepository.this.source.getDefaultCatalogName())) {
                catalogName = null;
            }
            if ((schemaName = segments.get(1).getName().getLocalName()).equals(JdbcMetadataRepository.this.source.getDefaultSchemaName())) {
                schemaName = null;
            }
            String tableName = segments.get(3).getName().getLocalName();
            String columnName = segments.get(4).getName().getLocalName();
            try {
                MetadataCollector meta = JdbcMetadataRepository.this.source.getMetadataCollector();
                List<ColumnMetadata> columns = meta.getColumns(conn, catalogName, schemaName, tableName, columnName);
                if (columns.isEmpty()) {
                    PathNode pathNode = null;
                    return pathNode;
                }
                assert (columns.size() == 1) : "Duplicate column named " + columnName;
                ColumnMetadata column = columns.get(0);
                HashMap<Name, Property> properties = new HashMap<Name, Property>();
                Name propName = JcrLexicon.PRIMARY_TYPE;
                properties.put(propName, propFactory.create(propName, new Object[]{JcrNtLexicon.UNSTRUCTURED}));
                propName = JcrLexicon.MIXIN_TYPES;
                properties.put(propName, propFactory.create(propName, new Object[]{JdbcMetadataLexicon.COLUMN}));
                propName = JdbcMetadataLexicon.JDBC_DATA_TYPE;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getJdbcDataType()}));
                propName = JdbcMetadataLexicon.TYPE_NAME;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getTypeName()}));
                propName = JdbcMetadataLexicon.COLUMN_SIZE;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getColumnSize()}));
                propName = JdbcMetadataLexicon.DECIMAL_DIGITS;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getDecimalDigits()}));
                propName = JdbcMetadataLexicon.RADIX;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getRadix()}));
                if (column.getNullable() != null) {
                    propName = JdbcMetadataLexicon.NULLABLE;
                    properties.put(propName, propFactory.create(propName, new Object[]{column.getNullable()}));
                }
                if (column.getDescription() != null) {
                    propName = JdbcMetadataLexicon.DESCRIPTION;
                    properties.put(propName, propFactory.create(propName, new Object[]{column.getDescription()}));
                }
                if (column.getDefaultValue() != null) {
                    propName = JdbcMetadataLexicon.DEFAULT_VALUE;
                    properties.put(propName, propFactory.create(propName, new Object[]{column.getDefaultValue()}));
                }
                propName = JdbcMetadataLexicon.LENGTH;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getLength()}));
                propName = JdbcMetadataLexicon.ORDINAL_POSITION;
                properties.put(propName, propFactory.create(propName, new Object[]{column.getOrdinalPosition()}));
                if (column.getScopeCatalogName() != null) {
                    propName = JdbcMetadataLexicon.SCOPE_CATALOG_NAME;
                    properties.put(propName, propFactory.create(propName, new Object[]{column.getScopeCatalogName()}));
                }
                if (column.getScopeSchemaName() != null) {
                    propName = JdbcMetadataLexicon.SCOPE_SCHEMA_NAME;
                    properties.put(propName, propFactory.create(propName, new Object[]{column.getScopeSchemaName()}));
                }
                if (column.getScopeTableName() != null) {
                    propName = JdbcMetadataLexicon.SCOPE_TABLE_NAME;
                    properties.put(propName, propFactory.create(propName, new Object[]{column.getScopeTableName()}));
                }
                if (column.getSourceJdbcDataType() != null) {
                    propName = JdbcMetadataLexicon.SOURCE_JDBC_DATA_TYPE;
                    properties.put(propName, propFactory.create(propName, new Object[]{column.getSourceJdbcDataType()}));
                }
                DefaultPathNode defaultPathNode = new DefaultPathNode(nodePath, null, properties, Collections.emptyList());
                return defaultPathNode;
            }
            catch (JdbcMetadataException se) {
                throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetColumn.text(new Object[]{catalogName, schemaName, tableName, columnName}), (Throwable)se);
            }
            finally {
                JdbcMetadataRepository.this.closeConnection(conn);
            }
        }

        public PathNode getRoot() throws RepositorySourceException {
            LinkedList<Path.Segment> catalogNames = new LinkedList<Path.Segment>();
            ExecutionContext context = JdbcMetadataRepository.this.source.getRepositoryContext().getExecutionContext();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            Connection conn = JdbcMetadataRepository.this.getConnection();
            try {
                MetadataCollector meta = JdbcMetadataRepository.this.source.getMetadataCollector();
                for (String catalogName : meta.getCatalogNames(conn)) {
                    if (catalogName.length() <= 0) continue;
                    catalogNames.add(pathFactory.createSegment(catalogName));
                }
                if (catalogNames.isEmpty()) {
                    catalogNames.add(pathFactory.createSegment(JdbcMetadataRepository.this.source.getDefaultCatalogName()));
                }
                RootNode rootNode = new RootNode(catalogNames);
                return rootNode;
            }
            catch (JdbcMetadataException se) {
                throw new RepositorySourceException(JdbcMetadataI18n.couldNotGetCatalogNames.text(new Object[0]), (Throwable)se);
            }
            finally {
                JdbcMetadataRepository.this.closeConnection(conn);
            }
        }

        public void lockNode(PathNode node, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) throws LockFailedException {
        }

        public void unlockNode(PathNode node) {
        }

        public QueryResults query(ExecutionContext context, AccessQueryRequest accessQuery) {
            throw new UnsupportedOperationException();
        }

        public QueryResults search(ExecutionContext context, String fullTextSearchExpression) {
            return null;
        }
    }
}

