/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.connector.meta.jdbc.ColumnMetadata;
import org.modeshape.connector.meta.jdbc.JdbcMetadataException;
import org.modeshape.connector.meta.jdbc.MetadataCollector;
import org.modeshape.connector.meta.jdbc.ProcedureMetadata;
import org.modeshape.connector.meta.jdbc.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class JdbcMetadataCollector
implements MetadataCollector {
    @Override
    public List<String> getCatalogNames(Connection conn) throws JdbcMetadataException {
        LinkedList<String> catalogNames = new LinkedList<String>();
        ResultSet catalogs = null;
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            catalogs = dmd.getCatalogs();
            while (catalogs.next()) {
                catalogNames.add(catalogs.getString("TABLE_CAT"));
            }
            LinkedList<String> linkedList = catalogNames;
            return linkedList;
        }
        catch (SQLException se) {
            throw new JdbcMetadataException(se);
        }
        finally {
            try {
                if (catalogs != null) {
                    catalogs.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    @Override
    public List<ColumnMetadata> getColumns(Connection conn, String catalogName, String schemaName, String tableName, String columnName) throws JdbcMetadataException {
        LinkedList<ColumnMetadata> columnData = new LinkedList<ColumnMetadata>();
        ResultSet columns = null;
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            if (catalogName == null) {
                catalogName = "";
            }
            if (schemaName == null) {
                schemaName = "";
            }
            columns = dmd.getColumns(catalogName, schemaName, tableName, columnName);
            Set<String> columnNames = this.columnsFor(columns);
            while (columns.next()) {
                ColumnMetadata column = new ColumnMetadata(columns.getString("COLUMN_NAME"), columns.getInt("DATA_TYPE"), columns.getString("TYPE_NAME"), columns.getInt("COLUMN_SIZE"), columns.getInt("DECIMAL_DIGITS"), columns.getInt("NUM_PREC_RADIX"), this.getNullableBoolean(columns, "NULLABLE"), columns.getString("REMARKS"), columns.getString("COLUMN_DEF"), columns.getInt("CHAR_OCTET_LENGTH"), columns.getInt("ORDINAL_POSITION"), this.getStringIfPresent(columns, "SCOPE_CATLOG", columnNames), this.getStringIfPresent(columns, "SCOPE_SCHEMA", columnNames), this.getStringIfPresent(columns, "SCOPE_TABLE", columnNames), this.getIntegerIfPresent(columns, "SOURCE_DATA_TYPE", columnNames));
                columnData.add(column);
            }
            LinkedList<ColumnMetadata> linkedList = columnData;
            return linkedList;
        }
        catch (SQLException se) {
            throw new JdbcMetadataException(se);
        }
        finally {
            try {
                if (columns != null) {
                    columns.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    @Override
    public List<String> getSchemaNames(Connection conn, String catalogName) throws JdbcMetadataException {
        LinkedList<String> schemaNames = new LinkedList<String>();
        ResultSet schemas = null;
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            schemas = dmd.getSchemas();
            Set<String> columns = this.columnsFor(schemas);
            boolean hasCatalog = columns.contains(this.identifierFor(dmd, "TABLE_CATALOG"));
            while (schemas.next()) {
                if (hasCatalog) {
                    String catalogNameForSchema = schemas.getString("TABLE_CATALOG");
                    String schemaName = schemas.getString("TABLE_SCHEM");
                    if ((catalogName != null || catalogNameForSchema != null) && (catalogName == null || !catalogName.equals(catalogNameForSchema))) continue;
                    schemaNames.add(schemaName);
                    continue;
                }
                schemaNames.add(schemas.getString("TABLE_SCHEM"));
            }
            LinkedList<String> linkedList = schemaNames;
            return linkedList;
        }
        catch (SQLException se) {
            throw new JdbcMetadataException(se);
        }
        finally {
            try {
                if (schemas != null) {
                    schemas.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    @Override
    public List<TableMetadata> getTables(Connection conn, String catalogName, String schemaName, String tableName) throws JdbcMetadataException {
        LinkedList<TableMetadata> tableData = new LinkedList<TableMetadata>();
        ResultSet tables = null;
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            if (catalogName == null) {
                catalogName = "";
            }
            if (schemaName == null) {
                schemaName = "";
            }
            tables = dmd.getTables(catalogName, schemaName, tableName, null);
            Set<String> columns = this.columnsFor(tables);
            while (tables.next()) {
                TableMetadata table = new TableMetadata(tables.getString("TABLE_NAME"), tables.getString("TABLE_TYPE"), tables.getString("REMARKS"), this.getStringIfPresent(tables, "TYPE_CAT", columns), this.getStringIfPresent(tables, "TYPE_SCHEM", columns), this.getStringIfPresent(tables, "TYPE_NAME", columns), this.getStringIfPresent(tables, "SELF_REFERENCING_COL_NAME", columns), this.getStringIfPresent(tables, "REF_GENERATION", columns));
                tableData.add(table);
            }
            LinkedList<TableMetadata> linkedList = tableData;
            return linkedList;
        }
        catch (SQLException se) {
            throw new JdbcMetadataException(se);
        }
        finally {
            try {
                if (tables != null) {
                    tables.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    @Override
    public List<ProcedureMetadata> getProcedures(Connection conn, String catalogName, String schemaName, String procedureName) throws JdbcMetadataException {
        LinkedList<ProcedureMetadata> procedureData = new LinkedList<ProcedureMetadata>();
        ResultSet procedures = null;
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            if (catalogName == null) {
                catalogName = "";
            }
            if (schemaName == null) {
                schemaName = "";
            }
            procedures = dmd.getProcedures(catalogName, schemaName, procedureName);
            while (procedures.next()) {
                ProcedureMetadata procedure = new ProcedureMetadata(procedures.getString("PROCEDURE_NAME"), procedures.getString("REMARKS"), procedures.getShort("PROCEDURE_TYPE"));
                procedureData.add(procedure);
            }
            LinkedList<ProcedureMetadata> linkedList = procedureData;
            return linkedList;
        }
        catch (SQLException se) {
            throw new JdbcMetadataException(se);
        }
        finally {
            try {
                if (procedures != null) {
                    procedures.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    private Boolean getNullableBoolean(ResultSet rs, String columnName) throws SQLException {
        Boolean b = rs.getBoolean(columnName);
        if (rs.wasNull()) {
            b = null;
        }
        return b;
    }

    private Set<String> columnsFor(ResultSet rs) throws SQLException {
        ResultSetMetaData rmd = rs.getMetaData();
        int count = rmd.getColumnCount();
        HashSet<String> columns = new HashSet<String>(count);
        for (int i = 1; i <= count; ++i) {
            columns.add(rmd.getColumnName(i));
        }
        return columns;
    }

    private String getStringIfPresent(ResultSet rs, String columnName, Set<String> resultSetColumns) throws SQLException {
        if (!resultSetColumns.contains(columnName)) {
            return null;
        }
        return rs.getString(columnName);
    }

    private Integer getIntegerIfPresent(ResultSet rs, String columnName, Set<String> resultSetColumns) throws SQLException {
        if (!resultSetColumns.contains(columnName)) {
            return null;
        }
        int i = rs.getInt(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return i;
    }

    private String identifierFor(DatabaseMetaData dmd, String rawIdentifier) throws SQLException {
        assert (rawIdentifier != null);
        if (dmd.storesLowerCaseIdentifiers()) {
            return rawIdentifier.toLowerCase();
        }
        return rawIdentifier;
    }
}

