/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;

public final class JdbcJcrValueFactory {
    protected static final SimpleDateFormat ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private JdbcJcrValueFactory() {
    }

    public static Value createValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).equalsIgnoreCase("NULL")) {
            return null;
        }
        return new JdbcJcrValue(value);
    }

    private static class JdbcJcrValue
    implements Value {
        private final Object value;

        protected JdbcJcrValue(Object value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        public boolean getBoolean() throws IllegalStateException {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            return Boolean.parseBoolean(this.value.toString());
        }

        @Override
        public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
            if (this.value instanceof Date) {
                Calendar c = Calendar.getInstance();
                c.setTime((Date)this.value);
                return c;
            }
            if (this.value instanceof Calendar) {
                return (Calendar)this.value;
            }
            try {
                Date iso8601Format = ISO8601.parse(this.value.toString());
                Calendar c = Calendar.getInstance();
                c.setTime(iso8601Format);
                return c;
            }
            catch (ParseException e) {
                throw new ValueFormatException("Value not instance of Date", e);
            }
        }

        @Override
        public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
            if (this.value instanceof Number) {
                return ((Number)this.value).doubleValue();
            }
            try {
                return Double.parseDouble(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException("Value not a Double", e);
            }
        }

        @Override
        public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
            if (this.value instanceof Number) {
                return ((Number)this.value).longValue();
            }
            try {
                return Long.parseLong(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException("Value not a Long");
            }
        }

        @Override
        public Binary getBinary() throws RepositoryException {
            if (this.value instanceof Binary) {
                return (Binary)this.value;
            }
            if (this.value instanceof byte[]) {
                final byte[] bytes = (byte[])this.value;
                return new Binary(){

                    @Override
                    public void dispose() {
                    }

                    @Override
                    public long getSize() {
                        return bytes.length;
                    }

                    @Override
                    public InputStream getStream() {
                        return new ByteArrayInputStream(bytes);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public int read(byte[] b, long position) throws IOException {
                        if (this.getSize() <= position) {
                            return -1;
                        }
                        InputStream stream = null;
                        try {
                            long skipped;
                            stream = this.getStream();
                            for (long skip = position; skip > 0L; skip -= skipped) {
                                skipped = stream.skip(skip);
                                if (skipped > 0L) continue;
                                int n = -1;
                                return n;
                            }
                            int n = stream.read(b);
                            return n;
                        }
                        finally {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                };
            }
            throw new ValueFormatException("Value not a Binary");
        }

        @Override
        public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
            if (this.value instanceof BigDecimal) {
                return (BigDecimal)this.value;
            }
            try {
                return new BigDecimal(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException("Value not a Decimal");
            }
        }

        @Override
        public InputStream getStream() throws IllegalStateException, RepositoryException {
            if (this.value instanceof Binary) {
                return ((Binary)this.value).getStream();
            }
            if (this.value instanceof InputStream) {
                return (InputStream)this.value;
            }
            if (this.value instanceof byte[]) {
                return new ByteArrayInputStream((byte[])this.value);
            }
            throw new ValueFormatException("Value not an InputStream");
        }

        @Override
        public String getString() throws IllegalStateException {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return this.value.toString();
        }

        @Override
        public int getType() {
            if (this.value instanceof String) {
                return 1;
            }
            if (this.value instanceof Boolean) {
                return 6;
            }
            if (this.value instanceof Date || this.value instanceof Calendar) {
                return 5;
            }
            if (this.value instanceof Double || this.value instanceof Float) {
                return 4;
            }
            if (this.value instanceof Long || this.value instanceof Integer) {
                return 3;
            }
            if (this.value instanceof BigDecimal) {
                return 12;
            }
            if (this.value instanceof byte[] || this.value instanceof Binary || this.value instanceof InputStream) {
                return 2;
            }
            return 0;
        }
    }
}

