/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jdbc.rest.ChildNodeDefinition;
import org.modeshape.jdbc.rest.ItemDefinition;
import org.modeshape.jdbc.rest.JSONHelper;
import org.modeshape.jdbc.rest.NodeTypes;
import org.modeshape.jdbc.rest.PropertyDefinition;

@Immutable
public class NodeType
implements javax.jcr.nodetype.NodeType {
    private final String name;
    private final boolean isAbstract;
    private final boolean isMixin;
    private final boolean isQueryable;
    private final boolean hasOrderableChildNodes;
    private final String primaryItemName;
    private final Map<PropertyDefinition.Id, PropertyDefinition> propertyDefinitions;
    private final Map<ChildNodeDefinition.Id, ChildNodeDefinition> childNodeDefinitions;
    private final List<String> declaredSuperTypes;
    private final NodeTypes nodeTypes;
    private List<NodeType> allSuperTypes;
    private Set<String> allSuperTypeNames;
    private Map<PropertyDefinition.Id, PropertyDefinition> allPropertyDefinitions;
    private Map<ChildNodeDefinition.Id, ChildNodeDefinition> allChildNodeDefinitions;

    protected NodeType(JSONObject json, NodeTypes nodeTypes) {
        this.nodeTypes = nodeTypes;
        this.name = JSONHelper.valueFrom(json, "jcr:nodeTypeName");
        assert (this.name != null);
        this.isMixin = JSONHelper.valueFrom(json, "jcr:isMixin", false);
        this.isAbstract = JSONHelper.valueFrom(json, "jcr:isAbstract", false);
        this.hasOrderableChildNodes = JSONHelper.valueFrom(json, "jcr:hasOrderableChildNodes", false);
        this.isQueryable = JSONHelper.valueFrom(json, "jcr:isQueryable", false);
        this.primaryItemName = JSONHelper.valueFrom(json, "jcr:primaryItemName");
        this.declaredSuperTypes = JSONHelper.valuesFrom(json, "jcr:supertypes");
        this.propertyDefinitions = new HashMap<PropertyDefinition.Id, PropertyDefinition>();
        this.childNodeDefinitions = new HashMap<ChildNodeDefinition.Id, ChildNodeDefinition>();
        if (json.has("children")) {
            try {
                JSONObject children = json.getJSONObject("children");
                Iterator itr = children.keys();
                while (itr.hasNext()) {
                    ItemDefinition defn;
                    String key = (String)itr.next();
                    JSONObject child = children.getJSONObject(key);
                    if (child == null) continue;
                    String type = this.getPrimaryType(key, child);
                    if (type.startsWith("nt:propertyDefinition") || type.startsWith("jcr:propertyDefinition")) {
                        defn = new PropertyDefinition(this.name, child, this.nodeTypes);
                        this.propertyDefinitions.put(((PropertyDefinition)defn).id(), (PropertyDefinition)defn);
                        continue;
                    }
                    if (!type.startsWith("nt:childNodeDefinition") && !type.startsWith("jcr:childNodeDefinition")) continue;
                    defn = new ChildNodeDefinition(this.name, child, this.nodeTypes);
                    this.childNodeDefinitions.put(((ChildNodeDefinition)defn).id(), (ChildNodeDefinition)defn);
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public javax.jcr.nodetype.NodeType[] getDeclaredSupertypes() {
        return this.nodeTypes.toNodeTypes(this.declaredSuperTypes);
    }

    @Override
    public javax.jcr.nodetype.NodeType[] getSupertypes() {
        List<NodeType> allSuperTypes = this.allSuperTypes();
        return allSuperTypes.toArray(new javax.jcr.nodetype.NodeType[allSuperTypes.size()]);
    }

    @Override
    public String[] getDeclaredSupertypeNames() {
        return this.declaredSuperTypes.toArray(new String[this.declaredSuperTypes.size()]);
    }

    @Override
    public NodeTypeIterator getDeclaredSubtypes() {
        ArrayList<NodeType> results = new ArrayList<NodeType>();
        for (NodeType nodeType : this.nodeTypes.nodeTypes()) {
            if (nodeType == this || !nodeType.declaredSuperTypes.contains(this.name)) continue;
            results.add(nodeType);
        }
        return this.iterator(results);
    }

    @Override
    public NodeTypeIterator getSubtypes() {
        ArrayList<NodeType> results = new ArrayList<NodeType>();
        for (NodeType nodeType : this.nodeTypes.nodeTypes()) {
            if (nodeType == this || !nodeType.allSuperTypeNames().contains(this.name)) continue;
            results.add(nodeType);
        }
        return this.iterator(results);
    }

    protected List<NodeType> allSuperTypes() {
        if (this.allSuperTypes == null) {
            NodeType ntBase;
            ArrayList<NodeType> allSuperTypes = new ArrayList<NodeType>();
            HashSet<String> allSuperTypeNames = new HashSet<String>();
            for (String superTypeName : this.declaredSuperTypes) {
                NodeType superType = this.nodeTypes.getNodeType(superTypeName);
                if (superType == null) continue;
                allSuperTypes.add(superType);
                allSuperTypeNames.add(superType.getName());
                allSuperTypes.addAll(superType.allSuperTypes());
                allSuperTypeNames.addAll(superType.allSuperTypeNames());
            }
            if (allSuperTypes.isEmpty() && !this.isMixin && (ntBase = this.nodeTypes.getNodeType("nt:base")) != null) {
                allSuperTypes.add(ntBase);
                allSuperTypeNames.add(ntBase.getName());
            }
            this.allSuperTypes = allSuperTypes;
            this.allSuperTypeNames = allSuperTypeNames;
        }
        return this.allSuperTypes;
    }

    protected Set<String> allSuperTypeNames() {
        this.allSuperTypes();
        return this.allSuperTypeNames;
    }

    @Override
    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        return this.childNodeDefinitions.values().toArray(new NodeDefinition[this.childNodeDefinitions.size()]);
    }

    @Override
    public NodeDefinition[] getChildNodeDefinitions() {
        Collection<ChildNodeDefinition> allDefns = this.allChildNodeDefinitions();
        return allDefns.toArray(new NodeDefinition[allDefns.size()]);
    }

    protected Collection<ChildNodeDefinition> declaredChildNodeDefinitions() {
        return this.childNodeDefinitions.values();
    }

    protected Collection<ChildNodeDefinition> allChildNodeDefinitions() {
        if (this.allChildNodeDefinitions == null) {
            HashMap<ChildNodeDefinition.Id, ChildNodeDefinition> allDefns = new HashMap<ChildNodeDefinition.Id, ChildNodeDefinition>();
            allDefns.putAll(this.childNodeDefinitions);
            for (NodeType superType : this.allSuperTypes()) {
                for (ChildNodeDefinition childDefn : superType.declaredChildNodeDefinitions()) {
                    if (allDefns.containsKey(childDefn.id())) continue;
                    allDefns.put(childDefn.id(), childDefn);
                }
            }
            this.allChildNodeDefinitions = allDefns;
        }
        return this.allChildNodeDefinitions.values();
    }

    @Override
    public javax.jcr.nodetype.PropertyDefinition[] getDeclaredPropertyDefinitions() {
        return this.propertyDefinitions.values().toArray(new javax.jcr.nodetype.PropertyDefinition[this.propertyDefinitions.size()]);
    }

    @Override
    public javax.jcr.nodetype.PropertyDefinition[] getPropertyDefinitions() {
        Collection<PropertyDefinition> allDefns = this.allPropertyDefinitions();
        return allDefns.toArray(new javax.jcr.nodetype.PropertyDefinition[allDefns.size()]);
    }

    protected Collection<PropertyDefinition> declaredPropertyDefinitions() {
        return this.propertyDefinitions.values();
    }

    protected Collection<PropertyDefinition> allPropertyDefinitions() {
        if (this.allPropertyDefinitions == null) {
            HashMap<PropertyDefinition.Id, PropertyDefinition> allDefns = new HashMap<PropertyDefinition.Id, PropertyDefinition>();
            allDefns.putAll(this.propertyDefinitions);
            for (NodeType superType : this.allSuperTypes()) {
                for (PropertyDefinition propDefn : superType.declaredPropertyDefinitions()) {
                    if (allDefns.containsKey(propDefn.id())) continue;
                    allDefns.put(propDefn.id(), propDefn);
                }
            }
            this.allPropertyDefinitions = allDefns;
        }
        return this.allPropertyDefinitions.values();
    }

    protected String getPrimaryType(String key, JSONObject child) {
        try {
            String primaryType = child.getString("jcr:primaryType");
            return primaryType != null ? primaryType : key;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPrimaryItemName() {
        return this.primaryItemName;
    }

    @Override
    public boolean hasOrderableChildNodes() {
        return this.hasOrderableChildNodes;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isMixin() {
        return this.isMixin;
    }

    @Override
    public boolean isQueryable() {
        return this.isQueryable;
    }

    @Override
    public boolean isNodeType(String nodeTypeName) {
        if (nodeTypeName == null) {
            return false;
        }
        if (this.name.equals(nodeTypeName)) {
            return true;
        }
        return this.allSuperTypeNames().contains(nodeTypeName);
    }

    @Override
    public boolean canAddChildNode(String childNodeName) {
        return false;
    }

    @Override
    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        return false;
    }

    @Override
    public boolean canRemoveItem(String itemName) {
        return false;
    }

    @Override
    public boolean canRemoveNode(String nodeName) {
        return false;
    }

    @Override
    public boolean canRemoveProperty(String propertyName) {
        return false;
    }

    @Override
    public boolean canSetProperty(String propertyName, Value value) {
        return false;
    }

    @Override
    public boolean canSetProperty(String propertyName, Value[] values) {
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeType) {
            return this.name.equals(((NodeType)obj).name);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.name);
        sb.append(']');
        if (this.getDeclaredSupertypeNames().length != 0) {
            sb.append(" > ");
            boolean first = true;
            for (String typeName : this.getDeclaredSupertypeNames()) {
                if (typeName == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(typeName);
            }
        }
        if (this.isAbstract()) {
            sb.append(" abstract");
        }
        if (this.isMixin()) {
            sb.append(" mixin");
        }
        if (!this.isQueryable()) {
            sb.append(" noquery");
        }
        if (this.hasOrderableChildNodes()) {
            sb.append(" orderable");
        }
        if (this.getPrimaryItemName() != null) {
            sb.append(" primaryitem ").append(this.getPrimaryItemName());
        }
        for (PropertyDefinition propDefn : this.declaredPropertyDefinitions()) {
            sb.append('\n').append(propDefn);
        }
        for (ChildNodeDefinition childDefn : this.declaredChildNodeDefinitions()) {
            sb.append('\n').append(childDefn);
        }
        sb.append('\n');
        return sb.toString();
    }

    private NodeTypeIterator iterator(final List<NodeType> nodeTypes) {
        return new NodeTypeIterator(){
            private int position = 0;
            private Iterator<NodeType> iterator = nodeTypes.iterator();

            @Override
            public javax.jcr.nodetype.NodeType nextNodeType() {
                NodeType nodeType = this.iterator.next();
                ++this.position;
                return nodeType;
            }

            @Override
            public void skip(long skipNum) {
                int i = 0;
                while ((long)i < skipNum) {
                    ++this.position;
                    if ((long)this.position >= this.getSize()) {
                        throw new NoSuchElementException();
                    }
                    this.nextNodeType();
                    ++i;
                }
            }

            @Override
            public long getSize() {
                return nodeTypes.size();
            }

            @Override
            public long getPosition() {
                return this.position;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public Object next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

