/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.IOException;
import java.io.InputStream;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.logging.Logger;

@NotThreadSafe
public class SelfClosingInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger(SelfClosingInputStream.class);
    private final InputStream stream;

    public SelfClosingInputStream(InputStream stream) {
        assert (stream != null);
        this.stream = stream;
    }

    @Override
    public int available() throws IOException {
        try {
            return this.stream.available();
        }
        catch (IOException e) {
            this.closeStream();
            throw e;
        }
        catch (RuntimeException e) {
            this.closeStream();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.stream.mark(readlimit);
        }
        catch (RuntimeException e) {
            this.closeStream();
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return this.stream.markSupported();
        }
        catch (RuntimeException e) {
            this.closeStream();
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int result = this.stream.read(b, off, len);
            if (result == -1) {
                this.closeStream();
            }
            return result;
        }
        catch (IOException e) {
            this.closeStream();
            throw e;
        }
        catch (RuntimeException e) {
            this.closeStream();
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            int result = this.stream.read(b);
            if (result == -1) {
                this.closeStream();
            }
            return result;
        }
        catch (IOException e) {
            this.closeStream();
            throw e;
        }
        catch (RuntimeException e) {
            this.closeStream();
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int result = this.stream.read();
            if (result == -1) {
                this.closeStream();
            }
            return result;
        }
        catch (IOException e) {
            this.closeStream();
            throw e;
        }
        catch (RuntimeException e) {
            this.closeStream();
            throw e;
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.stream.reset();
        }
        catch (IOException e) {
            this.closeStream();
            throw e;
        }
        catch (RuntimeException e) {
            this.closeStream();
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.stream.skip(n);
        }
        catch (IOException e) {
            this.closeStream();
            throw e;
        }
        catch (RuntimeException e) {
            this.closeStream();
            throw e;
        }
    }

    public String toString() {
        return this.stream.toString();
    }

    public InputStream wrappedStream() {
        return this.stream;
    }

    private void closeStream() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            LOGGER.error(e, CommonI18n.errorClosingWrappedStream, new Object[0]);
        }
    }
}

