/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.logging;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.LogFactory;

@ThreadSafe
public abstract class Logger {
    private static final AtomicReference<Locale> LOGGING_LOCALE = new AtomicReference<Object>(null);

    public static Locale getLoggingLocale() {
        return LOGGING_LOCALE.get();
    }

    public static Locale setLoggingLocale(Locale locale) {
        return LOGGING_LOCALE.getAndSet(locale != null ? locale : Locale.getDefault());
    }

    public static Logger getLogger(Class<?> clazz) {
        return LogFactory.getLogFactory().getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        return LogFactory.getLogFactory().getLogger(name);
    }

    public abstract String getName();

    public void log(Level level, I18nResource message, Object ... params) {
        if (message == null) {
            return;
        }
        switch (level) {
            case DEBUG: {
                this.debug(message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case ERROR: {
                this.error(message, params);
                break;
            }
            case INFO: {
                this.info(message, params);
                break;
            }
            case TRACE: {
                this.trace(message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case WARNING: {
                this.warn(message, params);
                break;
            }
        }
    }

    public void log(Level level, Throwable t, I18nResource message, Object ... params) {
        if (message == null) {
            return;
        }
        switch (level) {
            case DEBUG: {
                this.debug(t, message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case ERROR: {
                this.error(t, message, params);
                break;
            }
            case INFO: {
                this.info(t, message, params);
                break;
            }
            case TRACE: {
                this.trace(t, message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case WARNING: {
                this.warn(t, message, params);
                break;
            }
        }
    }

    public abstract void debug(String var1, Object ... var2);

    public abstract void debug(Throwable var1, String var2, Object ... var3);

    public abstract void error(I18nResource var1, Object ... var2);

    public abstract void error(Throwable var1, I18nResource var2, Object ... var3);

    public abstract void info(I18nResource var1, Object ... var2);

    public abstract void info(Throwable var1, I18nResource var2, Object ... var3);

    public abstract void trace(String var1, Object ... var2);

    public abstract void trace(Throwable var1, String var2, Object ... var3);

    public abstract void warn(I18nResource var1, Object ... var2);

    public abstract void warn(Throwable var1, I18nResource var2, Object ... var3);

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isDebugEnabled();

    public abstract boolean isTraceEnabled();

    public static enum Level {
        OFF,
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        TRACE;

    }
}

